<?php
// $Horde: horde/lib/Auth/sql.php,v 1.2 2000/09/26 22:45:53 chuck Exp $

require_once 'DB.php';

/**
 * The Auth_sql class provides a sql implementation of the Horde
 * authentication system.
 *
 * @author   Chuck Hagenbuch <chuck@horde.org>
 * @version  $Revision: 1.2 $
 * @since    Horde 1.3
 */
class Auth_sql extends Auth {
    
    /** Hash containing connection parameters. */
    var $params = array();
    
    /** Handle for the current database connection. */
    var $db;
    
    /** Boolean indicating whether or not we're connected to the SQL server. */
    var $connected = false;
	
    
    /**
     * Constructs a new SQL permissions object.
     *
     * @param $params   A hash containing connection parameters.
     */
    function Auth_sql($params = array())
    {
        $this->params = $params;
    }
	
	
    /**
     * Attempts to open a persistent connection to the SQL server.
     *
     * @return AUTH_OK on success, AUTH_ERROR_* on failure.
     */
    function connect()
    {
        if (!$this->connected) {
            if (!is_array($this->params)) return AUTH_ERROR_PARAMS;
            if (!isset($this->params['phptype'])) return AUTH_ERROR_PARAMS;
            if (!isset($this->params['hostspec'])) return AUTH_ERROR_PARAMS;
            if (!isset($this->params['username'])) return AUTH_ERROR_PARAMS;
            if (!isset($this->params['password'])) return AUTH_ERROR_PARAMS;
            if (!isset($this->params['database'])) return AUTH_ERROR_PARAMS;
            if (!isset($this->params['table'])) return AUTH_ERROR_PARAMS;

            /* Connect to the SQL server using the supplied parameters. */
            $this->db = &DB::connect($this->params, true);
            if (DB::isError($this->db) || DB::isWarning($this->db)) {
                return AUTH_ERROR_CONNECT;
            }

            $this->connected = true;
        }

        return AUTH_OK;
    }
	
    /**
     * Disconnect from the SQL server and clean up the connection.
     *
     * @return true on success, false on failure.
     */
    function disconnect()
    {
        if ($this->connected) {
            $this->connected = false;
            return $this->db->disconnect();
        }

        return true;
    }
	
    /**
	 * Find out if a set of login credentials are valid.
	 * 
	 * @param $userID The userID to check.
	 * @param $pass The password to use.
	 * 
	 * @return bool Whether or not the credentials are valid.
	 */
    function auth ($userID, $pass)
	{
        if (Auth::checkAuth($userID)) {
            return true;
        }
        
		if ($this->connect() != AUTH_OK) return $default;
		
        /* Build the SQL query. */
        $query = 'SELECT user_id FROM ' . $this->params['table'];
        $query .= " WHERE user_id = '" . $userID . "' AND user_pass = '" . md5($pass) . "'";
        
        /* Execute the query. */
        $result = $this->db->query($query);
		
        if (is_object($result)) {
            $row = $result->fetchRow(DB_GETMODE_ASSOC);
            if (is_array($row)) {
                $result->free();
                Auth::setAuth($userID);
                return true;
            } else {
				$result->free();
				return false;
			}
        } else {
			return false;
		}
	}
	
    /**
	 * Add a set of authentication credentials.
	 * 
	 * @param $userID The userID to add.
	 * @param $pass The password to use.
	 */
    function add ($userID, $pass)
	{
        if ($this->connect() != AUTH_OK) return false;
        
        /* Build the SQL query. */
        $query = "INSERT INTO " . $this->params['table'] . " (user_id, user_pass) ";
        $query .= "VALUES ('" . $userID . "', '" . md5($pass) . "')";
        
        /* Execute the query. */
        $result = $this->db->query($query);
        
        // check $result now...
        return AUTH_OK;
	}
	
    /**
	 * Update a set of authentication credentials.
	 * 
	 * @param $oldID The old userID.
	 * @param $newID The new userID.
	 * @param $pass The new password.
	 */
    function update ($oldID, $newID, $pass)
	{
        if ($this->connect() != AUTH_OK) return false;
        
        /* Build the SQL query. */
        $query = "UPDATE " . $this->params['table'] . " SET user_id = '" . $newID . "', user_pass = '" . md5($pass) . "'";
        $query .= "WHERE user_id = '" . $oldID . "'";
        
        /* Execute the query. */
        $result = $this->db->query($query);
        
        // check $result now...
        return AUTH_OK;
	}
	
    /**
	 * Delete a set of authentication credentials.
	 * 
	 * @param $userID The userID to delete.
	 */
    function delete ($userID)
	{
        if ($this->connect() != AUTH_OK) return false;
        
        /* Build the SQL query. */
        $query = "DELETE FROM " . $this->params['table'];
        $query .= "WHERE user_id = '" . $userID . "'";
        
        /* Execute the query. */
        $result = $this->db->query($query);
        
        // check $result now...
        return AUTH_OK;
	}
	
}
?>
