<?php
// $Horde: horde/lib/Auth/imap.php,v 1.3 2000/10/07 17:25:50 chuck Exp $

/**
 * The Auth_imap class provides an IMAP implementation of the Horde
 * authentication system.
 *
 * @author   Chuck Hagenbuch <chuck@horde.org>
 * @author   Gaudenz Steinlin <gaudenz.steinlin@id.unibe.ch>
 * @version  $Revision: 1.3 $
 * @since    Horde 1.3
 */
class Auth_imap extends Auth {
    
    /** Hash containing connection parameters. */
    var $params = array();
    
    
    /**
     * Constructs a new IMAP permissions object.
     *
     * @param $params   A hash containing connection parameters.
     */
    function Auth_imap($params = array())
    {
        $this->setParams($params);
    }
	
    
    /**
	 * Take a hash and build the connection string out of it.
	 * 
	 * @param $params   A hash specifying an IMAP mailbox.
	 */
	function setParams($params)
    {
        if (empty($params['dsn'])) {
            if (isset($params['server'])) 
                $params['dsn'] = '{' . $params['server'];
            else
                $params['dsn'] = '{localhost';
            
            if (isset($params['protocol'])) 
                $params['dsn'] .= '/' . $params['protocol'];
            else
                $params['dsn'] .= '/imap';
            
            if (isset($params['port'])) 
                $params['dsn'] .= ':' . $params['port'] . '}';
            else
                $params['dsn'] .= ':143}';
            
            if (isset($params['folder']))
                $params['dsn'] .= $params['folder'];
        }
        $this->params = $params;
    }
    
    /**
	 * Find out if a set of login credentials are valid.
	 * 
	 * @param $userID The userID to check.
	 * @param $pass The password to use.
	 * 
	 * @return bool Whether or not the credentials are valid.
	 */
    function auth ($userID, $pass)
    {
        if (Auth::checkAuth($userID)) {
            return true;
        }
        
        $imap = @imap_open($this->params['dsn'], $userID, $pass, OP_HALFOPEN);
        
        if ($imap) {
            @imap_close($imap);
            Auth::setAuth($userID);
            return true;
        }
        
        @imap_close($imap);
        return false;
    }
	
    /**
	 * Add a set of authentication credentials.
	 * 
	 * @param $userID The userID to add.
	 * @param $pass The password to use.
	 */
    function add ($userID, $pass)
    {
        return AUTH_ERROR_UNSUPPORTED;
    }
	
    /**
	 * Update a set of authentication credentials.
	 * 
	 * @param $oldID The old userID.
	 * @param $newID The new userID.
	 * @param $pass The new password.
	 */
    function update ($oldID, $newID, $pass)
    {
        return AUTH_ERROR_UNSUPPORTED;
    }
	
    /**
	 * Delete a set of authentication credentials.
	 * 
	 * @param $userID The userID to delete.
	 */
    function delete ($userID)
    {
        return AUTH_ERROR_UNSUPPORTED;
    }
	
}
?>
