<?php
// $Horde: horde/lib/Auth.php,v 1.5 2001/01/09 21:42:41 chuck Exp $

/* Return codes */
define('AUTH_OK',                 0);    // Operation succeeded
define('AUTH_ERROR',             -1);    // operation failed
define('AUTH_ERROR_PARAMS',      -2);    // Bad or missing parameters ($params)
define('AUTH_ERROR_CONNECT',     -3);    // Connection failure
define('AUTH_ERROR_AUTH',        -4);    // Authentication failure
define('AUTH_ERROR_EMPTY',       -5);    // Empty retrieval result
define('AUTH_ERROR_UNSUPPORTED', -6);    // Auth subclass does not support that method

/**
 * The Auth:: class provides a common abstracted interface into the
 * various backends for the Horde authentication system.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.5 $
 * @since   Horde 1.3
 */
class Auth {
    
    /**
     * Attempts to return a concrete Auth instance based on $driver.
     * 
     * @param $driver The type of concrete Auth subclass to return.
     *                This is based on the storage driver ($driver).  The
     *                code is dynamically included.
     * @param $params (optional) A hash containing any additional
     *                configuration or connection parameters a subclass
     *                might need.
     *
     * @return The newly created concrete Auth instance, or false
     *         on an error.
     */
    function factory($driver, $params = array())
    {
        if (empty($driver) || (strcasecmp($driver, 'none') == 0)) {
            return new Auth;
        }
        
        $classfile = dirname(__FILE__) . '/Auth/' . $driver . '.php';
        
        if (@is_readable($classfile)) {
            include_once $classfile;
            $class = 'Auth_' . $driver;
            return new $class($params);
        } else {
            return false;
        }
    }
	
    /**
     * Attempts to return a reference to a concrete Auth instance based on
     * $driver. It will only create a new instance if no Auth instance
     * with the same parameters currently exists.
     *
     * This should be used if multiple permissions sources (and, thus,
     * multiple Auth instances) are required.
     *
     * This method must be invoked as: $var = &Auth::singleton()
     *
     * @param $driver The type of concrete Auth subclass to return.
     *                This is based on the storage driver ($driver). The
     *                code is dynamically included.
     * @param $params (optional) A hash containing any additional
     *                configuration or connection parameters a subclass
     *                might need.
     *
     * @return The concrete Auth reference, or false on an error.
     */
    function &singleton($driver, $params = array())
    {
        static $instances;

        if (!isset($instances)) $instances = array();

        $signature = md5($driver . '][' . implode('][', $params));
        if (!isset($instances[$signature])) {
            $instances[$signature] = Auth::factory($driver, $params);
        }
        
        return $instances[$signature];
    }
	
    /**
	 * Find out if a set of login credentials are valid.
	 * 
	 * @param $userID The userID to check.
	 * @param $pass The password to use.
	 * 
	 * @return bool Whether or not the credentials are valid.
	 */
    function auth($userID, $pass)
	{
        return Auth::checkAuth($userID);
	}
	
    /**
	 * Add a set of authentication credentials.
	 * 
	 * @param $userID The userID to add.
	 * @param $pass The password to use.
	 */
    function add($userID, $pass) {}
	
    /**
	 * Update a set of authentication credentials.
	 * 
	 * @param $oldID The old userID.
	 * @param $newID The new userID.
	 * @param $pass The new password.
	 */
    function update ($oldID, $newID, $pass) {}
	
    /**
	 * Delete a set of authentication credentials.
	 * 
	 * @param $userID The userID to delete.
	 */
    function delete ($userID) {}
    
    /**
     * Checks if there is a session with valid auth information.
     *
     * @param $userID The userID we are expecting in the session.
     */
    function checkAuth($userID)
    {
        if (isset($GLOBALS['HTTP_SESSION_VARS']['__auth'])) {
            if (!empty($GLOBALS['HTTP_SESSION_VARS']['__auth']['authenticated']) &&
                !empty($GLOBALS['HTTP_SESSION_VARS']['__auth']['userID']) &&
                $GLOBALS['HTTP_SESSION_VARS']['__auth']['userID'] == $userID) {
                return true;
            }
        }
        return false;
    }
	
    /**
     * Return the currently logged in user, if there is one.
     *
     * @return mixed $userID The userID of the current user, or false
     *                       if no user is logged in.
     */
    function getAuth()
    {
        if (isset($GLOBALS['HTTP_SESSION_VARS']['__auth'])) {
            if (!empty($GLOBALS['HTTP_SESSION_VARS']['__auth']['authenticated']) &&
                !empty($GLOBALS['HTTP_SESSION_VARS']['__auth']['userID'])) {
                return $GLOBALS['HTTP_SESSION_VARS']['__auth']['userID'];
            }
        }
        return false;
    }
    
    /**
     * Set a variable in the session saying that authorization has
     * succeeded, note which userID was authorized, and note when the
     * login took place.
     *
     * @param $userID The userID who has been authorized.
     */
    function setAuth($userID)
    {
        if (!isset($GLOBALS['HTTP_SESSION_VARS']['__auth'])) {
            session_register('__auth');
        }
        $GLOBALS['__auth'] = &$GLOBALS['HTTP_SESSION_VARS']['__auth'];
        $GLOBALS['__auth'] = array();
        $GLOBALS['__auth']['authenticated'] = true;
        $GLOBALS['__auth']['userID'] = $userID;
        $GLOBALS['__auth']['timestamp'] = time();
    }
    
    /**
     * Clear any authentication tokens in the current session.
     */
    function clearAuth()
    {
        if (isset($GLOBALS['HTTP_SESSION_VARS']['__auth'])) {
            $GLOBALS['__auth'] = &$GLOBALS['HTTP_SESSION_VARS']['__auth'];
            $GLOBALS['__auth'] = array();
            $GLOBALS['__auth']['authenticated'] = null;
        }
    }
    
}
?>
