<?php
/*
 * $Horde: horde/index.php,v 2.31 2001/01/10 19:24:19 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999, 2000 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

$horde_configured = (@file_exists('./config/horde.php') &&
                     @file_exists('./config/html.php') &&
                     @file_exists('./config/mime.php') &&
                     @file_exists('./config/registry.php'));

if ($horde_configured) {
    include './config/horde.php';
    error_reporting($horde['debug_level']);

    include_once './lib/Horde.php';
    include_once './lib/Browser.php';

    $browser = new Browser();
    
    if ($browser->hasFeature('wml')) {
        include $horde['horde']['paths']['templates'] . '/index/wap.inc';
    } else if ($horde['floating_bar'] && (!$browser->hasQuirk('avoid_popup_windows'))) {
        include './config/registry.php';
        $flmenu_width = count($__horde_applications) * 50;
        include $horde['horde']['paths']['templates'] . '/index/floating_index.inc';
    } else {
        include $horde['horde']['paths']['templates'] . '/index/frames_index.inc';
    }
} else {
    $horde['horde']['paths']['root'] = dirname($HTTP_SERVER_VARS['SCRIPT_NAME']);
    $horde['sitename'] = 'Horde Application Framework';
    $title = _("Horde is not fully configured.");
    include './templates/common-header.inc';
    include './templates/index/horde_notconfigured.inc';
    include './templates/common-footer.inc';
}

?>
