<?php
/*
 * $Horde: horde/horde.php,v 2.30 2001/01/10 19:24:19 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999, 2000 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

require './config/horde.php';
require './config/registry.php';
error_reporting($horde['debug_level']);

require_once './lib/Horde.php';
require_once './lib/Browser.php';
$browser = new Browser();

/* Define target */
$opener = false;
if ($horde['floating_bar'] && (!$browser->hasQuirk('avoid_popup_windows'))) {
    $opener = true;
    $title = _("Horde System");
}

require $horde['horde']['paths']['templates'] . '/doctype.inc';
require $horde['horde']['paths']['templates'] . '/common-header.inc';

/* Build the menu out of the modules array */
$moduletext = '';

/*
 * Now print a link for each module (no links are fine since there
 * will be other stuff here)
 */
if (isset($__horde_applications) && is_array($__horde_applications)) {
    foreach ($__horde_applications as $service => $params) {
        $line = '<td class="header" align="center" valign="bottom">';
        if (!$opener) {
            $line .= '<a class="menuitem" href="' . $params['webroot'].'" target="main">';
        } else {
            $line .= '<a class="menuitem" href="javascript:void(0)" onClick="window.opener.location.href=\'' . $params['webroot'] . '\';return false">';
        }
        $line .= '<img src="' . $params['icon'] .
                 '"border="0" hspace="5" align="absmiddle"><br>' .
                 $params['name'] . '</a></td>';
        $moduletext .= "$line\n";
    }
}

require $horde['horde']['paths']['templates'] . '/horde/modules.inc';
require $horde['horde']['paths']['templates'] . '/common-footer.inc';

?>
