<?php
/*
 * $Horde: horde/help.php,v 2.30 2001/01/04 18:37:21 jon Exp $
 *
 * Copyright 1999, 2000 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

require './config/horde.php';
error_reporting($horde['debug_level']);

require_once './lib/Horde.php';
require_once './lib/Help.php';

require './config/lang.php';
$language = Lang::select();
putenv("LANG=$language");
@setlocale(LC_ALL, $language);
bindtextdomain('horde', './locale');
textdomain('horde');

$title = _('Help');
require $horde['horde']['paths']['templates'] . '/doctype.inc';

$show = (isset($show)) ? strtolower($show) : 'index';
$module = (!empty($module)) ? strtolower(basename($module)) : 'horde';
$help_dir = ($module == 'horde') ? './locale/' : "./$module/locale/";
$help_file = $help_dir . "$language/help.xml";

if ($show == 'index') {
    include $horde['horde']['paths']['templates'] . '/help/index.inc';
} else {
    include $horde['horde']['paths']['templates'] . '/common-header.inc';
    if ($show == 'menu') {
        include $horde['horde']['paths']['templates'] . '/help/menu.inc';
    } else {
        include $horde['horde']['paths']['templates'] . '/help/header.inc';
        
        $help = new Help(HELP_SOURCE_FILE, $help_file);
        if (($show == 'entry') && isset($topic) && (strlen($topic) > 0)) {
            $help->lookup($topic);
            $help->display();
        } else {
            while (list($id, $title) = each($help->topics())) {
                echo '<a class="smallheader" href="' . $horde['horde']['paths']['root'].'/help.php?show=entry';
                echo '&module=' . $module . '&topic=' . $id . '">';
                echo $title . "</a><br>\n";
            }
        }
        $help->cleanup();
        
        include $horde['horde']['paths']['templates'] . '/help/footer.inc';
    }
}

require $horde['horde']['paths']['templates'] . '/common-footer.inc';

?>
