<?php

error_reporting(E_ALL);

// 0 == debugging off, 1 == debugging on
define('DEBUG', 0);

// define a class to do all the work - save state internally, etc.
class Parser {
  
  var $text = ''; // the full text being parsed
  var $pos  = 0;  // current position in the text
  var $len  = 0;  // length of the text. need to check it for overflow
  var $tokens;    // array of tokens
  
  
  function Parser ($text='') {
    $this->text = $text;  // default to empty text (that's not a very useful parser).
    $this->pos = 0;       // start at the beginning
    $this->len = strlen($this->text);   // take the length once so we don't have to over and over again
  } // Constructor
  
  
  /* char(): return the character at the specified position, or, if
     the $pos parameter is not specified, at the current object
     position ($this->pos). In either case do overflow checking. */
  function char ($pos=-1) {
    if ($pos == -1) {
      if ($this->pos >= $this->len) {
	if (DEBUG) echo "overran the end of the text<br>\n";
	return -1;
      } else {
	return $this->text[$this->pos];
      }
    } else {
      if ($pos >= $this->len) {
	if (DEBUG) echo "overran the end of the text<br>\n";
	return -1;
      } else {
	return $this->text[$pos];
      }
    }
  } // char()
  

  /* nextChar(): advance the internal position pointer one step,
     returning the character we now point to. Make sure we don't
     overflow the end of the text. */
  function nextChar () {
    $this->pos++;
    if ($this->pos >= $this->len) {
      if (DEBUG) echo "overran the end of the text<br>\n";
      return -1;
    }
    return $this->text[$this->pos - 1];
  } // nextChar()
  
  
  /* skipWhitespace(): while the current character is a whitespace
     character, increment the internal position pointer. */
  function skipWhitespace () {
    while (preg_match('/\s/', $this->char())) {
      $this->pos++;
    }
  } // skipWhitespace()
  
  
  /* skipComments(): if the next non-space characters are comment
     characters (defined in the DuctTape grammar as "//", skip ahead until
     we are past the comment and at the next non-whitespace
     character. */
  function skipComments () {
    $this->skipWhitespace();
    if ($this->char() == '/' && $this->char($this->pos + 1) == '/') {
      $this->pos = strpos($this->text, "\n", $this->pos) + 1;
      if (DEBUG) echo 'pos now set to ' . $this->pos . "<br>\n";
    }
    $this->skipWhitespace();
  } // skipComment()
  
  
  /* getString(): return the next string token, defined as a set of
     characters enclosed in non-escaped double quotes (") */
  function getString () {
    $string = '';
    
    if ($this->char() != '"') {
      return $this->getToken();
    }
    
    $this->nextChar(); // discard '"'
    $cur = $this->nextChar();
    $pre = '';
    $string = '';
    while (($cur != -1) && ($cur != '"' || ($cur == '"' && $pre == "\\"))) {
      $string .= $cur;
      $pre = $cur;
      $cur = $this->nextChar();
      if (DEBUG) echo 'curren char is ' . $cur . ' and previous is ' . $pre . "<br>\n";
    }
    return '"' . $string . '"';
  } // getString()
  
  
  /* getToken(): return the next non-string token, defined as per the
     grammar. */
  function getToken () {
      $localpos = 0;
      $token = '';
      $this->skipComments();
      $c = $this->nextChar();
      if ($c == -1) {
	  if (DEBUG) echo "overran the file<br>\n";
	  return -1;
      }
      if (DEBUG) echo 'current char is ' . $c . "<br>\n";
      while (($c != -1) && !preg_match('|\s|', $c) && $c != ',' && $c != ';') {
	  if ($c == '=' || $c == '(' || $c == ')' || $c == '{' || $c == '}' || $c == ',' || $c == ';') { // catch 1-char tokens
	      if ($localpos == 0) {
		  return $c;
	      } else {
		  $this->pos--;
		  return $token;
	      }
	  }
	  $localpos++;
	  $token .= $c;
	  $c = $this->nextChar();
	  if (DEBUG) echo 'current char is ' . $c . "<br>\n";
      }
      if ($c == ',' || $c == ';') {
	  if ($localpos == 0) {
	      return $c;
	  } else {
	      $this->pos--;
	      return $token;
	  }
      }
      return $token;
  } // getToken()
  
  
  /* nextToken(): return the next token, whether it is a string or other. */
  function nextToken () {
    $this->skipComments();
    if ($this->char() == -1) {
      if (DEBUG) echo "past end of file<br>\n";
      return -1;
    } else if ($this->char() == '"') {
      $token = $this->getString();
    } else {
      $token = $this->getToken();
    }
    return $token;
  } // nextToken()
  
  
  /* listTokens(): utility function to run through and display all of
     the tokens that get parsed out. for testing purposes. */
  function listTokens () {
    $t = $this->nextToken();
    while ($t != -1) {
      echo 'token: ' . htmlentities($t) . "<br>\n";
      $t = $this->nextToken();
    }
  } // listTokens()
  
  
  /* reset(): utility function to clear state and go back to the
     beginning of the text. */
  function reset () {
    $this->pos = 0;
    $this->tokens = array();
  } // reset()
  
  
  /* tokenize(): create an array (stored in $this->tokens) holding all
     of the tokens in the text, to work with later. */
  function tokenize () {
    $this->reset();
    $t = $this->nextToken();
    while ($t != -1) {
      $this->tokens[] = $t;
      $t = $this->nextToken();
    }
  } // tokenize()
  
  
  /* parse(): the workhorse, very-DuctTape-specific parsing
     function. Assumes that $this->tokenize() has been called (though
     doesn't call it itself just in case there were some mumbo-jumbo
     that needed to be done in between the two steps. */
  function parse () {
    // make sure we're at the beginning of the array
    reset($this->tokens);
    
    // module_begin
    // get module name
    list(,$token) = each($this->tokens);
    if ($token != 'module') {
      echo "ERROR: file does not begin with module keyword<br>\n";
      return false;
    }
    list(,$token) = each($this->tokens);
    $module_name = $token;
    
    // find out what it implements
    list(,$token) = each($this->tokens);
    if ($token != 'implements') {
      echo "ERROR: implements keyword missing or in wrong place<br>\n";
      return false;
    }
    list(,$token) = each($this->tokens);
    $interface_implemented = $token;
    
    // opening brace
    list(,$token) = each($this->tokens);
    if ($token != '{') {
      echo "ERROR: malformed file (opening brace)<br>\n";
      return false;
    }
    
    // module_body
    // module_definition
    list(,$token) = each($this->tokens);
    if ($token != 'definition') {
      echo "ERROR: module definition not found<br>\n";
      return false;
    }
    // opening brace
    list(,$token) = each($this->tokens);
    if ($token != '{') {
      echo "ERROR: malformed file (opening brace)<br>\n";
      return false;
    }
    
    // could use some error checking in this loop...
    list(,$token) = each($this->tokens);
    while ($token != '}') {
	list(,) = each($this->tokens); // consume an '='
	list(,$value) = each($this->tokens);
	$def_params[$token] = $value;
	list(,) = each($this->tokens); // consume the ';'
	list(,$token) = each($this->tokens);
    }
    
    // methods
    list(,$token) = each($this->tokens);
    while ($token != '}') { // check for the '}' that closes the module
	
	// start parsing the method
	if ($token != 'method') { // not opening a method properly
	    echo "ERROR: expecting 'method ...'<br>\n";
	    return false;
	}
	list(,$method_name) = each($this->tokens); // grab method name
	$methods[] = $method_name;
	list(,$token) = each($this->tokens); // grab method name
	
	// method arguments
	if ($token != '(') {
	    echo "ERROR: expecting '('<br>\n";
	    return false;
	}
	list(,$token) = each($this->tokens);
	while ($token != ')') {
	    if ($token == '{') break;
	    $arg = '';
	    while ($token != ',' && $token != ')') {
		if ($arg != '') $arg .= ' ';
		$arg .= $token;
		list(,$token) = each($this->tokens);
	    }
	    if (DEBUG) echo htmlspecialchars($arg) . '<br>';
	    $method_args[$method_name][] = $arg;
	    list(,$token) = each($this->tokens);
	}
	
	// method body
	if ($token != '{') {
	    echo "ERROR: expecting '{'<br>\n";
	    return false;
	}
	list(,$token) = each($this->tokens);
	while ($token != '}') {
	    $param = '';
	    $param = "'" . $token . "' => ";
	    list(,) = each($this->tokens); // eat the '='
	    list(,$val) = each($this->tokens);
	    $param .= $val;
	    
	    list(,) = each($this->tokens); // eat the ';'
	    
	    if (DEBUG) echo htmlspecialchars($param) . '<br>';
	    $method_params[$method_name][] = $param;
	    list(,$token) = each($this->tokens);
	}

	list(,$token) = each($this->tokens);
    }
    
    
    // spit stuff out
    if (DEBUG) {
      echo 'module ' . $module_name . ' implements ' . $interface_implemented . "<br>\n";
      reset($def_params);
      while (list($key, $val) = each($def_params)) {
        echo $key . ' = ' . $val . "<br>\n";
      }
    }
    
    reset($methods);
    while (list(,$val) = each($methods)) {
	echo '$' . "__horde_registry['" . $interface_implemented . "']['" . $val . "'] = '" . $module_name . "';\n" . '<br>';
    }
    
    reset($methods);
    while (list(,$val) = each($methods)) {
	$method = $method_params[$val];
	reset($method);
	$params = 'array(';
	while (list(,$param) = each($method)) {
	    if ($params != 'array(') $params .= ",\n";
	    $params .= $param;
	}
	$params .= ');';
	echo htmlspecialchars('$' . "__horde_registered_services['" . $module_name . "']['" . $interface_implemented . "']['" . $val . "'] = " . $params) . '<br>';;
    }
    
  } // parse()
  
} // end Parser


$interface = implode('', file('./imp.i'));
// echo '<pre>' . htmlentities($interface) . '</pre>';

$p = new Parser($interface);
// $p->listTokens();
$p->tokenize();
$p->parse();

?>
