<?php
/*
 * $Horde: horde/css.php,v 1.4 2000/12/21 18:35:05 chuck Exp $
 *
 * Copyright 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

if (@file_exists('./config/html.php')) {
    include './config/html.php';
} else {
    include './config/html.php.dist';
}

if (@file_exists('./config/horde.php')) {
    include './config/horde.php';
} else {
    $horde['css']['cached'] = false;
}


if (isset($HTTP_GET_VARS['app'])) {
    $css_file = './' . basename($HTTP_GET_VARS['app']) . '/config/html.php';
    if (@file_exists($css_file)) {
        include $css_file;
    }
    
    $conf_file = './' . basename($HTTP_GET_VARS['app']) . '/config/conf.php';
    if (@file_exists($conf_file)) {
        include $conf_file;
    }
    
    if (isset($conf['css']['cached']))
        $horde['css']['cached'] = $conf['css']['cached'];
}

if ($horde['css']['cached']) {
    $mod_gmt = gmdate('D, d M Y H:i:s', getlastmod()) . ' GMT';
    header('Last-Modified: ' . $mod_gmt);
    header('Cache-Control: public, max-age=86400');
} else {
    header('Expires: -1');
    header('Pragma: no-cache');
    header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
}

header('Content-type: text/css');

if (is_array($css)) {
    
    foreach ($css as $class => $params) {
        echo "$class {\n";
        if (is_array($params)) {
            foreach ($params as $key => $val) {
                echo "\t$key: $val;\n";
            }
        }
        echo "}\n\n";
    }
}

?>
