#
#  File: dbpasswd.sh
#  $Horde: horde/scripts/database/dbpasswd.sh,v 1.1.2.8 2000/09/15 06:48:46 jon Exp $
#

# Describe what this script does.
#
echo
echo "This script changes the password for the Horde database user.  It"
echo "makes the change to the database itself, and to the configuration"
echo "files used by Horde/IMP to access it.  You will need your database"
echo "administrator password, and permission to change your Horde/IMP"
echo "configuration files."
echo

# Determine OS and its techniques.
#
case "`uname -s`" in
Linux|FreeBSD|OpenBSD)
    N="-n"; C=""
    ;;
*)
    N=""; C="\c"
    ;;
esac

# Determine where the IMP defaults file is; make sure it's writable.
#
if [ -f imp/config/defaults.php3 ]; then
    IMP_CDIRG=imp/config
elif [ -f horde/imp/config/defaults.php3 ]; then
    IMP_CDIRG=horde/imp/config
elif [ -f ../../imp/config/defaults.php3 ]; then
    IMP_CDIRG=../../imp/config
else
    IMP_CDIRG=
fi
IMP_DEFAULTS=
while [ -z "$IMP_DEFAULTS" ]; do
    echo $N "What is your IMP configuration directory [$IMP_CDIRG]? $C"
    read IMP_CDIR
    if [ -z "$IMP_CDIR" ]; then
        IMP_CDIR="$IMP_CDIRG"
    fi
    if [ -f $IMP_CDIR/defaults.php3 ]; then
        IMP_DEFAULTS=$IMP_CDIR/defaults.php3
    else
        echo "$0: $IMP_CDIR/defaults.php3 not found" >&2
    fi
done
if [ ! -w $IMP_DEFAULTS ]; then
    echo "$0: you don't have permission to change $IMP_DEFAULTS" >&2
    exit 77  # EX_NOPERM
fi

# Read IMP's idea of the database driver, user name, and (old) password.
#
IMP_DD=`grep '\$default->database_driver' $IMP_DEFAULTS | sed -e "s/^[^']*'//" -e "s/'[^']*$//"`
if [ -z "$IMP_DD" ]; then
    echo "$0: unable to read '\$default->database_driver' from $IMP_DEFAULTS" >&2
    exit 78  # EX_CONFIG
fi
IMP_USER=`grep '\$default->db_user_name' $IMP_DEFAULTS | sed -e "s/^[^']*'//" -e "s/'[^']*$//"`
if [ -z "$IMP_USER" ]; then
    echo "$0: unable to read '\$default->db_user_name' from $IMP_DEFAULTS" >&2
    exit 78  # EX_CONFIG
fi
IMP_OPASS=`grep '\$default->db_password' $IMP_DEFAULTS | sed -e "s/^[^']*'//" -e "s/'[^']*$//"`
if [ -z "$IMP_OPASS" ]; then
    echo "$0: unable to read '\$default->db_password' from $IMP_DEFAULTS" >&2
    exit 78  # EX_CONFIG
fi
echo "Your IMP configuration file is:       $IMP_DEFAULTS"
echo "  It says the database driver is:       $IMP_DD"
echo "  It says the database user name is:    $IMP_USER"
echo "  It says the old password is:          $IMP_OPASS"

# Check early for tool availability, before we've asked a lot of questions.
#
case "$IMP_DD" in
mysql)
    mysqladmin --help 2>/dev/null | grep ping >/dev/null
    if [ $? -ne 0 ]; then
        echo "$0: can't run mysqladmin (not in your PATH?); aborting." >&2
        exit 3
    fi
    mysqladmin --user=$IMP_USER "--password=$IMP_OPASS" ping >/dev/null 2>&1
    if [ $? -ne 0 ]; then
        echo "$0: can't run mysqladmin as '$IMP_USER'; aborting." >&2
        exit 4
    fi
    ;;
pgsql)
    if [ -z "$PGUSER" ]; then
        PGUSER=postgres
    fi
    export PGUSER
    psql -ql 2>/dev/null | grep template1 >/dev/null
    if [ $? -ne 0 ]; then
        echo "$0: can't run psql as '$PGUSER'; aborting." >&2
        echo "$0: (set PGUSER environment variable and re-run)" >&2
        exit 5
    fi
    ;;
*)
    echo "$0: not yet implemented for database $IMP_DD; sorry." >&2
    exit 70  # EX_SOFTWARE
    ;;
esac

# Determine where the PHPLIB local.inc file is; make sure it's writable.
#
PHP_LDIRG=
for p in phplib horde-phplib php; do
    if [ -f $p/local.inc ]; then
        PHP_LDIRG=$p
    elif [ -f ../$p/local.inc ]; then
        PHP_LDIRG=../$p
    elif [ -f ../../$p/local.inc ]; then
        PHP_LDIRG=../../$p
    elif [ -f ../../../../$p/local.inc ]; then
        PHP_LDIRG=../../../../$p
    fi
done
PHP_LOCAL=
while [ -z "$PHP_LOCAL" ]; do
    echo $N "What is your PHPLIB directory [$PHP_LDIRG]? $C"
    read PHP_LDIR
    if [ -z "$PHP_LDIR" ]; then
        PHP_LDIR="$PHP_LDIRG"
    fi
    if [ -f $PHP_LDIR/local.inc ]; then
        PHP_LOCAL=$PHP_LDIR/local.inc
    else
        echo "$0: $PHP_LDIR/local.inc not found" >&2
    fi
done
if [ ! -w $PHP_LOCAL ]; then
    echo "$0: you don't have permission to change $PHP_LOCAL" >&2
    exit 77  # EX_NOPERM
fi

# Read PHPLIB's idea of the database user name.
#
PHP_USER=`grep 'var $User' $PHP_LOCAL | sed -e "s/^[^']*'//" -e "s/'[^']*$//"`
if [ -z "$PHP_USER" ]; then
    echo "$0: unable to read 'var \$User' from $PHP_LOCAL" >&2
    exit 78  # EX_CONFIG
fi
echo "Your PHPLIB configuration file is:    $PHP_LOCAL"
echo "  It says the database user name is:    $PHP_USER"
if [ "$PHP_USER" != "$IMP_USER" ]; then
    echo "$0: database user names must match in the configuration files" >&2
    exit 78  # EX_CONFIG
fi

# Get the password they want to use.
#
IMP_PASS=
IMP_PASS2=_xyzzy_
while [ "$IMP_PASS" != "$IMP_PASS2" ]; do
    echo
    echo $N "Enter the new '$IMP_USER' database password: $C"
    read IMP_PASS
    echo $N "Enter the password again to confirm: $C"
    read IMP_PASS2
    if [ "$IMP_PASS" != "$IMP_PASS2" ]; then
        echo "$0: passwords don't match; try again" >&2
    elif [ -z "$IMP_PASS" ]; then
        echo "$0: WARNING: empty password is probably a bad idea" >&2
    fi
done

# Confirm the change.
#
echo
echo $N "Change the '$IMP_USER' database password now? $C"
read YN
if [ "$YN" != y -a "$YN" != yes -a "$YN" != Y ]; then
    echo "$0: aborting change." >&2
    exit 1
fi

# Make the change in the database.
#
echo
echo "Changing the database password..."
case "$IMP_DD" in
mysql)
    mysqladmin --user=$IMP_USER "--password=$IMP_OPASS" password "$IMP_PASS"
    if [ $? -ne 0 ]; then
        echo "$0: password change failed; aborting." >&2
        exit 2
    fi
    ;;
pgsql)
    psql -qc "ALTER USER $IMP_USER WITH PASSWORD '$IMP_PASS';" template1
    if [ $? -ne 0 ]; then
        echo "$0: password change failed; aborting." >&2
        exit 6
    fi
    ;;
esac

# Make the change in the configuration files.
#
cp -p $PHP_LOCAL $PHP_LOCAL.bak
if [ $? -ne 0 ]; then
    echo "$0: error creating $PHP_LOCAL.bak" >&2
    exit 73  # EX_CANTCREAT
fi
awk "/var \\\$Password/ { print \"  var \$Password = '$IMP_PASS';\"; next; } { print \$0; }" <$PHP_LOCAL.bak >$PHP_LOCAL
if [ $? -ne 0 ]; then
    echo "$0: error changing password in $PHP_LOCAL" >&2
    cp -p $PHP_LOCAL.bak $PHP_LOCAL
    exit 74  # EX_IOERR
fi
cp -p $IMP_DEFAULTS $IMP_DEFAULTS.bak
if [ $? -ne 0 ]; then
    echo "$0: error creating $IMP_DEFAULTS.bak" >&2
    exit 73  # EX_CANTCREAT
fi
awk "/\\\$default->db_password/ { print \"\$default->db_password                    = '$IMP_PASS';\"; next; } { print \$0; }" <$IMP_DEFAULTS.bak >$IMP_DEFAULTS
if [ $? -ne 0 ]; then
    echo "$0: error changing password in $IMP_DEFAULTS" >&2
    cp -p $IMP_DEFAULTS.bak $IMP_DEFAULTS
    exit 74  # EX_IOERR
fi

# Done.
#
echo
echo "The password change has been made."
exit 0
