/* IMP database creation script for Sybase */

/* (c) Mike Hardy, 1999 released under the GPL */
/* see the file COPYING in this distribution for license info */

/* To initialize the Sybase ASE SQL Server for IMP do this: */
/* <prompt>% isql -i sybase_create.sql -U<username> -P<password> */

set nocount on

/* I assume you have already created the database "horde" */
/*use horde*/
/*go*/

/* ============================================================ */
/*   Table : ACTIVE_SESSIONS                                    */
/* ============================================================ */
create table ACTIVE_SESSIONS
(
    P_SID       varchar(32)            not null,
    P_NAME      varchar(32)            not null,
    P_VALPOS    varchar(6)             not null,
    P_VALENC    varchar(16)            not null,
    P_VAL       text                   null,
    P_CHANGED   varchar(14)            not null,
    constraint PK_ACTIVE_SESSIONS primary key (P_NAME, P_SID, P_VALPOS)
)
go

/* ============================================================ */
/*   Index : CHANGED                                            */
/* ============================================================ */
create index CHANGED on ACTIVE_SESSIONS (P_CHANGED)
go


IF EXISTS (SELECT * FROM imp.dbo.sysobjects WHERE name = "Imp_Pref")
BEGIN
DROP TABLE Imp_Pref
END
GO

CREATE TABLE Imp_Pref (
       UserName	      VARCHAR(255) NOT NULL,
       Sig	      TEXT,
       FullName	      VARCHAR(70),
       ReplyTo	      VARCHAR(70),
       Lang	      VARCHAR(70)
)
GO

IF EXISTS (SELECT * FROM imp.dbo.sysobjects WHERE name = "Imp_Addr")
BEGIN
DROP TABLE Imp_Addr
END
GO

CREATE TABLE Imp_Addr (
       UserName	      VARCHAR(255) NOT NULL,
       Address	      VARCHAR(255),
       NickName	      VARCHAR(255),
       FullName	      VARCHAR(255)
)
GO

GRANT Select,Insert,Update,Delete ON Imp_Pref,Imp_Addr TO nobody
