# $Horde: horde/scripts/database/mysql_create.sql,v 1.1.2.8 2000/09/02 00:49:28 jon Exp $
#
# You can simply direct this file to mysql as STDIN:
# $ mysql (user/pass/host args) < mysql_create.sql

CONNECT mysql;

REPLACE INTO user ( host, user, password )
    VALUES (
        'localhost',
        'hordemgr',
        password('hordemgr')
    );

REPLACE INTO db ( host, db, user, select_priv, insert_priv, update_priv,
                  delete_priv, create_priv, drop_priv )
    VALUES (
        'localhost',
        'horde',
        'hordemgr',
        'Y', 'Y', 'Y', 'Y',
        'Y', 'Y'
    );

# MySQL 3.23.x appears to have "CREATE DATABASE IF NOT EXISTS" and
# "CREATE TABLE IF NOT EXISTS" which would be a nice way to handle
# reinstalls gracefully (someday).  For now, use mysql_drop.sql first
# to avoid CREATE errors.

CREATE DATABASE horde;
CONNECT horde;

CREATE TABLE active_sessions (
    sid         varchar(32) not null,
    name        varchar(32) not null,
    val         text,
    changed     varchar(14) not null,
    primary key (name, sid),
    key changed (changed)
);

# create the address table
CREATE TABLE imp_addr (
    user        varchar(120) not null,
    address     varchar(120) not null,
    nickname    varchar(255),
    fullname    varchar(255),
    primary key (user, address)
);


# now create the pref table
CREATE TABLE imp_pref (
    user        varchar(255) not null primary key,
    fullname    varchar(70),
    replyto     varchar(70),
    lang        varchar(30),
    sig         text
);

FLUSH PRIVILEGES;

# done!
