<?php

/*
 
 File: signup.php3
 $Author: chuck $
 $Revision: 2.1.2.10 $
 $Date: 2000/07/27 00:29:45 $
 
 HORDE: Copyright 1999 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
*/

/* Send the browser back to the correct page */
function return_to_page() {
    global $this_client, $return_url;
    if (isset($return_url)) {
        if(! $this_client->lynx ) {
            echo "<script language=\"JavaScript\">window.location=\"" . $return_url . "\"</script></body></html>";
        } else {
            header("Location: " . $return_url);
        }
    } else {
        if(! $this_client->lynx ) {
            echo "<script language=\"JavaScript\">window.location=\"login.php3\"</script></body></html>";
        } else {
            header('Location: index.php3');
        }
    }
    exit;
}



/* Obtain the date offset. Thanks to Javier Kohen <jkohen@tough.com>
 * for fixing this for wrap-around
 */
function gm_offset () {
  $date = date('H');
  $gmdate = gmdate('H');
  /* Adjust for wrap-around, the difference can't be more than 12 hours.
   * AFAIK, -1200 is invalid, the correct one is +1200 (ie: at New Zealand).
   */
  if ($gmdate + 12 < $date) {
    $gmdate += 24;
  } else if ($date + 12 <= $gmdate) {
    $date += 24;
  }
  $offset = $date - $gmdate;
  if ($offset >= 0) {
    return sprintf("+%02d", $offset) . "00";
  } else {
    return sprintf("-%02d", -$offset) . "00";
  }
}


$need_horde_db = 1;
$db_lib_loaded = 0;
require ('./lib/horde.lib');
require( './config/horde.php3' );
require './lib/version.php';

if (empty($default->signup)) {
	echo 'this is disabled';
	exit;
}

/* Html styles configuration */
require('./config/html.php3');
require('./config/mime.php3');

require ('./lib/mime.lib');

$language = select_lang();
require ("./locale/$language/signup.lang");
require ('./locale/local/signup.lang');
$help_file = 'signup.help';
require ("./locale/defines/$help_file");

$this_client = new WebClient;

page_open(array('sess' => 'HordeSession'));
page_close();

error_reporting($default->error_level);

if (!empty($message)) $message = stripSlashes($message);
if (!empty($subject)) $subject = stripSlashes($subject);

if (!$this_client->lynx) {
  $actions[$lang->button_signup] = SEND_MESSAGE;
  $actions[$lang->button_cancel_signup] = NO_ACTION;
} else {
  if (!empty($actionID)) {
    if ($actionID == $lang->button_signup) { $actionID = SEND_MESSAGE; }
  } else {
    $actionID = NO_ACTION;
  }
}    


if (isset($actionID)) {

  /* translate non-int values into the correct int */
  if (strcspn($actionID, '0123456789')) { $actionID = $actions[$actionID]; }

  switch ($actionID) {
    case SEND_MESSAGE:

        if ($subject && $user1 && $user2 && $user3 && $pass1 && $pass2 && $email && $real_name ) { // need to check to make sure the other parts are there as well
            /* somehow need to verify email addresses */

      $message = str_replace("\r\n", "\n", $message);
      $mime = new MimeMessage($message);

      $text_part = new mime_part;
      $text_part->type = 'text';
      $text_part->subtype = 'plain';
      $text_part->contents = wrap_message("$message\n\nName: $real_name\nEmail: $email\n\nUsername: $user1, $user2, $user3\nPassword: $pass1, $pass2\n\n", 80, "\n");

      /* add footer to text_part */
      if ($default->append_trailer && @file_exists('./config/trailer.txt')) {
        $config_trailer = "\n" . implode('', @file('./config/trailer.txt'));
        $config_trailer = set_env_in_string($config_trailer);
        $text_part->contents .= $config_trailer;
      }

      $mime->add_begin_part($text_part);
      $msg = $mime->generate();

      $envelope['Message-ID'] = '<' . uniqid(time() . '.') . '@' . $SERVER_NAME . '>';
      $envelope['Date'] = date("D, d M Y H:i:s ") . gm_offset();
      $envelope['To'] = $default->signup_email;
      $envelope['From'] = 'horde-signup@localhost';
      $recipients = $default->signup_email;
      $envelope['Subject'] = $lang->signup_subject;
      $envelope = $mime->header($envelope);
      $envelope['User-Agent'] = 'HORDE/PHP3 ' . HORDE_VERSION;
      /* hack to work with the mailfrom function depending on horde; this is fixed
 in 2.3 */
      class tempOb {
      }
      $imp = new tempOb;
      $imp->server = 'localhost';
      $imp->user = 'horde-signup';
      $imp->from_server = 'localhost';

      /* If you really wanted to do something automatic, here would be the */
      /* place to do it. The data elements are all set at this point, you */
      /* just need to write a script that takes them and does something. */
      /* Place the script name in the following line, and uncomment the following block */

      //$return = exec("SCRIPT-NAME-HERE.pl $subject $user1 $user2 $user3 $pass1 $pass2 $email $real_name");

      /* Check to make sure everything went well, display error and try again if it didn't */

      //if($return != 'LAST LINE OF SUCCESSFUL CREATION OUTPUT HERE) {
      //  status($return);
      //}
      /* you will also probably want to comment out the mailfrom block below */

      if (mailfrom($recipients, $envelope, $msg)) {
        return_to_page();
      } else {
        $ACTION_TEXT = $lang->horde_signup;
      }
    } else {
      /* something wasn't quite right. strange */
      $ACTION_TEXT = $lang->horde_signup;
      status($lang->alert);
    }
        break;

    case NO_ACTION:
    default:
        return_to_page();
        break;

    }
} else { $ACTION_TEXT = $lang->signup; }
if (!isset($status_sent)) { status($lang->signup); }
$title = $lang->signup;
$sidebar = false;
require("$default->horde_include_dir/generic-header.inc");

$from = 'horde-signup@localhost';
$barefrom = 'horde-signup@localhost';
if (!isset($msg)) { $msg = ''; }
if (!isset($subject)) { $subject = ''; }

   if(! $this_client->lynx ) {
     require("$default->horde_include_dir/signup/signup.inc");
   } else {
     require("$default->horde_include_dir/signup/lynx_signup.inc");
   }

   require("$default->horde_include_dir/generic-footer.inc");
?>
