#
#   File: mysql_create.sql
#   $Horde: horde/scripts/database/mysql_create.sql,v 1.1.2.5 2000/07/31 12:49:13 bjn Exp $
#
#   You can simply direct this file to mysql as STDIN:
#   $ mysql (user/pass/host args) < mysql_create.sql

CONNECT mysql;

REPLACE INTO user ( host, user, password )
    VALUES (
        'localhost',
        'hordemgr',
        password('hordemgr')
    );

REPLACE INTO db ( host, db, user, select_priv, insert_priv, update_priv,
                  delete_priv, create_priv, drop_priv )
    VALUES (
        'localhost',
        'horde',
        'hordemgr',
        'Y', 'Y', 'Y', 'Y',
        'Y', 'Y'
    );

# MySQL 3.23.x appears to have "CREATE DATABASE IF NOT EXISTS" and
# "CREATE TABLE IF NOT EXISTS" which would be a nice way to handle
# reinstalls gracefully (someday).  For now, use mysql_drop.sql first
# to avoid CREATE errors.

CREATE DATABASE horde;
CONNECT horde;

CREATE TABLE active_sessions (
    sid varchar(32) DEFAULT '' NOT NULL,
    name varchar(32) DEFAULT '' NOT NULL,
    val text,
    changed varchar(14) DEFAULT '' NOT NULL,
    PRIMARY KEY (name,sid),
    KEY changed (changed)
);

# create the address table
CREATE TABLE imp_addr (
    user text,
    address text,
    nickname text,
    fullname text
);


# now create the pref table
CREATE TABLE imp_pref (
    user text,
    fullname text,
    replyto text,
    lang varchar(30),
    sig text
);

FLUSH PRIVILEGES;

# done!
