<?php
/*
Copyright 1999 Jason Orcutt
*/
require( './templates/setup/session.lib' );

if (!($language)) { $language = select_lang(); }

$session = create_session_object();
$session->set_lang($language);      

require ("./locale/$language/setup.lang");
require ('./locale/local/setup.lang');

/*
Setup wizard modes :
*/
define( "IMP_SETUP_WIZ_STEP_1",  1000 );
define( "IMP_SETUP_WIZ_STEP_2",  2000 ); 
define( "IMP_SETUP_WIZ_STEP_3",  3000 ); 
define( "IMP_SETUP_WIZ_STEP_4",  4000 );
define( "IMP_SETUP_WIZ_STEP_5",  5000 ); 
define( "IMP_SETUP_WIZ_STEP_6",  6000 );
define( "IMP_SETUP_WIZ_STEP_7",  7000 );
define( "IMP_SETUP_WIZ_STEP_8",  8000 );
define( "IMP_SETUP_WIZ_STEP_9",  9000 );
define( "IMP_SETUP_WIZ_STEP_10",  10000 );
define( "IMP_SETUP_WIZ_STEP_11",  11000 );
define( "IMP_SETUP_WIZ_STEP_WRITE_FILE",  999999 );

/* Determine which modules are present and configure thy self */
/*if ( is_dir( './imp' ) {}
if ( is_dir( './nag' ) {} */

$FORM_MAPPINGS = Array();
$FORM_MAPPINGS[ IMP_SETUP_WIZ_STEP_1 ]    = 'language.inc';
$FORM_MAPPINGS[ IMP_SETUP_WIZ_STEP_2 ]    = 'server_specific.inc';
$FORM_MAPPINGS[ IMP_SETUP_WIZ_STEP_3 ]    = 'web_server.inc';
$FORM_MAPPINGS[ IMP_SETUP_WIZ_STEP_4 ]    = 'mail_server.inc';
$FORM_MAPPINGS[ IMP_SETUP_WIZ_STEP_5 ]    = 'cookie.inc';
$FORM_MAPPINGS[ IMP_SETUP_WIZ_STEP_6 ]    = 'external_binaries.inc';
$FORM_MAPPINGS[ IMP_SETUP_WIZ_STEP_7 ]    = 'user_abilites.inc';
$FORM_MAPPINGS[ IMP_SETUP_WIZ_STEP_8 ]    = 'new_mail_popup.inc';
$FORM_MAPPINGS[ IMP_SETUP_WIZ_STEP_9 ]    = 'message_options.inc';
$FORM_MAPPINGS[ IMP_SETUP_WIZ_STEP_10 ]   = 'database.inc';
$FORM_MAPPINGS[ IMP_SETUP_WIZ_STEP_11 ]   = 'verify_write_file.inc';
$FORM_MAPPINGS[ IMP_SETUP_WIZ_STEP_WRITE_FILE ]    = 'write_file.inc';

Function comment_string( $comment ) {
   return '/* ' . $comment . ' */' . "\n";
}

Function set_val( $val_name, $value , $comment = '' ) {
   $val_string = $val_name;
   for( $i = strlen( $val_name ); $i < 40; $i++ ) {
      $val_string .= ' ';
   }
   $val_string .= ' = ';

   if ( is_string( $value ) && $value != 'true' && $value != 'false' ) { 
   $val_string .= '"' . $value . '";' . "\n" ;   
   } else {
   $val_string .= $value . ';' . "\n" ;   
   }

   if ( $comment  != '' ) {
      for( $i = strlen( $comment ) ; $i < 15; $i++ ) {
         $val_string .= ' ';
      }
      $val_string .= '/* ' . $comment . ' */';
   }

   return $val_string;
}

Function section_break() { return "\n\n"; }

Function create_imp_defaults_php3() {
   global $default;

   $output = '';
   $output .= '<?php' . "\n";
   $output .= comment_string( 'file: defaults.php3' );
   $output .= comment_string( 'setup.php3 by Jason "ZeroDiVide" Orcutt < zerodiv@atcjet.net >' );
   $output .= section_break();

   $output .= comment_string( 'For debugging purposes' );
   $output .= set_val( '$default->error_level', 15 );
   $output .= section_break();

   $output .= comment_string( 'The longest that things like file uploads and slow functions' );
   $output .= comment_string( 'should be allowed to run. 0 means run until termination' );
   $output .= comment_string( '(forever if infinite loop).' );
   $output .= section_break();
   $output .= comment_string( 'NOTE: you can\'t set this to 0 if safe_mode is on.' );
   $output .= set_val( '$default->max_execution_time', 0 );
   $output .= section_break();

   $output .= comment_string( 'Server Specific Configuration' );
   $output .= set_val( '$default->localhost',         $default->localhost );
   $output .= section_break();

   $output .= comment_string( 'Web Server Configuration' );
   if ($default->root_url == '/imp/' ) {
      $default->root_url = '/imp/';
      $default->graphics_url = '/imp/graphics';
   } 
   $output .= set_val( '$default->root_url',          $default->root_url );
   $output .= set_val( '$default->include_dir',       $default->include_dir );
   if ($default->root_url == '/imp/' ) {
      $default->graphics_url = '/imp/graphics';
   }
   $output .= set_val( '$default->graphics_url',      $default->graphics_url );
   $output .= section_break();

   $output .= comment_string( 'Default IMAP Server Configuration' );
   $output .= set_val( '$default->server',            $default->server );
   $output .= set_val( '$default->from_server',       $default->from_server );
   $output .= set_val( '$default->port',              $default->port );
   $output .= section_break();

   $output .= comment_string( 'Default IMAP Folder Configuration' );
   $output .= set_val( '$default->folders',              $default->folders );
   $output .= set_val( '$default->use_imap_subscribe',   $default->use_imap_subscribe );
   $output .= set_val( '$default->show_dotfiles',        $default->show_dotfiles );
   $output .= set_val( '$default->save_sent_mail',       $default->save_sent_mail );
   $output .= set_val( '$default->sent_mail',            $default->sent_mail );
   $output .= set_val( '$default->postponed',            $default->postponed );
   $output .= section_break();

   $output .= comment_string( 'Allow caching of the pages' );
   $output .= set_val( '$default->cache_pages',          $default->cache_pages );
   $output .= section_break();

   $output .= comment_string( 'Ldap searching' );
   $output .= set_val( '$default->use_ldap_search',      $default->use_ldap_search );
   $output .= section_break();

   $output .= comment_string( 'Server list : user is presented with a list' );
   $output .= comment_string( 'of available imap servers' );
   $output .= set_val( '$default->use_server_list',      $default->use_server_list );
   $output .= section_break();

   $output .= comment_string( 'User changeable items' );
   $output .= set_val( '$default->user_change_server',   $default->user_change_server );
   $output .= set_val( '$default->user_change_folder',   $default->user_change_folder );
   $output .= set_val( '$default->user_change_from',     $default->user_change_from );
   $output .= set_val( '$default->user_change_fullname', $default->user_change_fullname );
   $output .= set_val( '$default->user_use_addressbook', $default->user_use_addressbook );
   $output .= section_break();

   $output .= comment_string( 'Check For New Mail Configuration' );
   $output .= set_val( '$default->newmail_popup',        $default->newmail_popup );
   $output .= set_val( '$default->refresh_delay',        $default->refresh_delay );
   $output .= section_break();

   $output .= comment_string( 'Cookie Configuration' ); 
   $output .= set_val( '$default->cookie_timeout',       $default->cookie_timeout );
   $output .= set_val( '$default->session_enabled',      $default->session_enabled );
   $output .= set_val( '$default->session_timeout',      $default->session_timeout );
   $output .= section_break();
  
   $output .= comment_string( 'External Binaries Configuration' );
   $output .= set_val( '$default->path_to_sendmail',     $default->path_to_sendmail,         'Sendmail' );
   $output .= set_val( '$default->path_to_ispell',       $default->path_to_ispell,           'ISpell' );
   $output .= set_val( '$default->path_to_mswordview',   $default->path_to_mswordview,       'M$WordView' );
   $output .= set_val( '$default->path_to_tar',          $default->path_to_tar,              'Tar' );
   $output .= section_break();

   $output .= comment_string( 'SSL Configuration' );
   $output .= set_val( '$default->secure',               $default->secure );
   $output .= section_break();

   $output .= comment_string( 'Cyrus Configuration' );
   $output .= set_val( '$default->personal_folders',    $default->personal_folders,         'i.e. INBOX.' );
   $output .= section_break();
 
   $output .= comment_string( 'Default Language Configuration' );
   $output .= set_val( '$default->language',              $default->lang );
   $output .= section_break();

   $output .= comment_string( 'Message Configuration' );
   $output .= set_val( '$default->append_header',     $default->append_header );
   $output .= set_val( '$default->append_trailer',    $default->append_trailer );
   $output .= section_break();

   $output .= comment_string( 'Text Viewing' );
   $output .= set_val( '$default->text_parts_inline', $default->text_parts_inline );
   $output .= section_break();

   $output .= comment_string( 'Database Configuration' );
   if ( $default->database_driver == 'dummy_driver' ) { $default->use_db = 'false'; }
   $output .= set_val( '$default->use_db',            $default->use_db );
   $output .= set_val( '$default->database_driver',   $default->database_driver );
   $output .= set_val( '$default->db_user_name',      $default->db_user_name );
   $output .= set_val( '$default->db_password',       $default->db_password );
   $output .= set_val( '$default->db_name',           $default->db_name );
   $output .= set_val( '$default->db_server_name',    $default->db_server_name );
   $output .= set_val( '$default->db_pref_table',     $default->db_pref_table );
   $output .= set_val( '$default->db_address_table',  $default->db_address_table );
   $output .= set_val( '$default->db_connect_string', $default->db_connect_string );
   $output .= set_val( '$default->db_server_port',    $default->db_server_port );
   $output .= set_val( '$default->db_server_options', $default->db_server_options );
   $output .= set_val( '$default->db_server_tty',     $default->db_server_tty );
   $output .= section_break();

   $output .= '?>' . "\n";
   return $output;
}

Function write_file() {
   $output = create_imp_defaults_php3();
   $fh = fopen( './imp/config/defaults.php3', 'w' );
   fwrite( $fh, $output, strlen( $output ) );
   fclose( $fh );
}

Function find_binary( $input_value, $binary_names ) {
   $temp_array = Array(
      '/bin',
      '/sbin',
      '/usr/bin',
      '/usr/sbin',
      '/opt/bin',
      '/opt/sbin',
      '/usr/local/bin',
      '/usr/local/sbin'
   );
   if ( $input_value != '' ) {
      /* We've got a path for it already. */
      return $input_value;
   }

   /* Let's determine that path */
   $bin_path = Array();
   $found    = false;
   for( $x = 0 ; $x < count( $temp_array ) ; $x++ ) {
      for( $z = 0 ; $z < count( $binary_names ) ; $z++ ) {
      $bin = $temp_array[ $x ] . '/' . $binary_names[ $z ];
      if ( is_executable( $bin ) ) {
         $bin_path[] = $bin;
         $found = true;
      }

      }
   }
   if ( $found == false ) {
      $bin_path[] = '[ NOT FOUND ]';
   }
   return $bin_path;
}

Function set_default( $cur_value, $input_value, $default_value ) {
   if ( $cur_value == '' && $input_value == '' ) {
      return $default_value;
   } else {
      return $input_value;
   }
}

Function setup_defaults() {
global $default;

global $localhost;

global $root_url;
global $graphics_url;
global $server;

global $from_server;
global $port;
global $personal_folders;
global
   $folders,                     $use_imap_subscribe,
   $show_dotfiles,               $save_sent_mail,
   $sent_mail,                   $postponed;

global $session_enabled, $session_timeout, $cookie_timeout, $cache_pages;

global 
   $path_to_sendmail,            $path_to_ispell,
   $path_to_mswordview,          $path_to_tar;

global
   $user_change_server,          $user_change_folder,
   $user_change_from,            $user_change_fullname,
   $use_ldap_search,             $user_use_addressbook;

global $refresh_delay, $newmail_popup;

global $language;

global $append_trailer, $append_header, $text_parts_inline;

global 
      $use_db,                   $database_driver,
      $db_user_name,             $db_password,
      $db_name,                  $db_server_name,
      $db_pref_table,            $db_address_table;

$default->localhost = set_default( 
   $default->localhost,
   $localhost,
   getenv( 'SERVER_NAME' )
);

$default->include_dir = set_default(
   $default->include_dir,
   $include_dir,
   './templates'
);

$default->root_url = set_default(
   $default->root_url,
   $root_url,
   '/imp'
);
if ( $default->graphics_url == '' && $graphics_url == '') {
   if ( $default->root_url != '' ) {
      $graphics_url = $default->root_url . '/graphics';
      $default->graphics_url = $default->root_url . '/graphics';
   } else {
      $graphics_url = '/imp/graphics';
      $default->graphics_url = '/imp/graphics';
   }
} 
$default->graphics_url = set_default(
   $default->graphics_url,
   $graphics_url,
   $default->root_url . '/imp/graphics'
);
$default->server = set_default(
   $default->server,
   $server,
   $default->localhost
);
$default->from_server = set_default(
   $default->from_server,
   $from_server,
   $default->localhost
);
$default->port = set_default(
   $default->port,
   $port,
   143
);
$default->personal_folders = set_default(
   $default->personal_folders,    
   $personal_folders,
   'INBOX'
);

$default->folders = set_default( 
   $default->folders,
   $folders,
   ''
);
$default->use_imap_subscribe = set_default(
   $default->use_imap_subscribe,
   $use_imap_subscribe,
   true
);
$default->show_dotfiles = set_default(
   $default->show_dotfiles,
   $show_dotfiles,
   false
);
$default->save_sent_mail = set_default(
   $default->save_sent_mail,
   $save_sent_mail,
   true
);
$default->sent_mail = set_default(
   $default->sent_mail,
   $sent_mail,
   'sent-mail'
);
$default->postponed = set_default(
   $default->postponed,
   $postponed,
   'postponed'
);
$default->session_enabled = set_default(
   $default->session_enabled,
   $sesion_enabled,
   0
);

$default->cache_pages   = 
   set_default( 
    $default->cache_pages,
    $cache_pages, 
    'false'
   );
$default->use_server_list = 
   set_default(
    $default->use_server_list,
    $use_server_list,
    'false'
   );

$default->secure = 
   set_default(
    $default->secure,
    $secure,
    'true'
   );

$default->session_timeout = set_default(
   $default->session_timeout,
   $session_timeout,
   10000
);

$default->cookie_timeout = set_default(
   $default->cookie_timeout,
   $cookie_timeout,
   300
);

$default->path_to_sendmail = find_binary(
   $path_to_sendmail,
   Array( 'sendmail' )
);

$default->path_to_ispell = find_binary(
   $path_to_ispell,
   Array( 'ispell' )
);

$default->path_to_mswordview = find_binary(
   $path_to_mswordview,
   Array( 'mswordview' )
);

$default->path_to_tar = find_binary( 
   $path_to_tar,
   Array( 'tar', 'gtar' )
);

$default->user_change_server = set_default(
   $default->user_change_server,
   $user_change_server,
   true
);
$default->user_change_folder = set_default(
   $default->user_change_folder,
   $user_change_folder,
   true
);
$default->user_change_from = set_default(
   $default->user_change_from,
   $user_change_from,
   true
);
$default->user_change_fullname = set_default(
   $default->user_change_fullname,
   $user_change_fullname,
   true
);
$default->use_ldap_search = set_default(
   $default->use_ldap_search,
   $use_ldap_search,
   false
);
$default->user_use_addressbook = set_default(
   $default->user_use_addressbook,
   $user_use_addressbook,
   true
);
$default->newmail_popup = set_default(
   $default->newmail_popup,
   $newmail_popup,
   true
);
$default->refresh_delay = set_default(
   $default->refresh_delay,
   $refresh_delay,
   300
);

$default->lang = set_default(
   $default->lang,
   $language,
   'en'
);

$default->append_header = set_default(
   $default->append_header,
   $append_header,
   true
);
$default->append_trailer = set_default(
   $default->append_trailer,
   $append_trailer,
   true
);
$default->text_parts_inline = set_default(
   $default->text_parts_inline,
   $text_parts_inline,
   true
);


$default->use_db  = set_default(
   $default->use_db,
   $use_db,
   false
);
$default->database_driver = set_default(
   $default->database_driver,
   $database_driver,
   'dummy'
);
$default->db_user_name = set_default(
   $default->db_user_name,
   $db_user_name,
   ''
);
$default->db_password = set_default(
   $default->db_password,
   $db_password,
   ''
);
$default->db_name = set_default(
   $default->db_name,
   $db_name,
   'imp'
);
$default->db_server_name = set_default(
   $default->db_server_name,  
   $db_server_name,
   'localhost'
);
$default->db_pref_table = set_default(
   $default->db_pref_table,
   $db_pref_table,
   'imp_pref'
);
$default->db_address_table = set_default(
   $default->db_address_table,
   $db_address_table,
   'imp_addr'
);

}

Function hidden_elems( $my_mode ) {
   global $default;
   $names_vals = Array();
   $names_vals[ 'mode' ]                  = $my_mode;
   $names_vals[ 'localhost' ]             = $default->localhost;
   $names_vals[ 'root_url' ]              = $default->root_url;
   $names_vals[ 'graphics_url' ]          = $default->graphics_url;
   $names_vals[ 'server' ]                = $default->server;
   $names_vals[ 'from_server' ]           = $default->from_server;
   $names_vals[ 'port' ]                  = $default->port;
   $names_vals[ 'personal_folders' ]      = $default->personal_folders;
   $names_vals[ 'folders' ]               = $default->folders;
   $names_vals[ 'use_imap_subscribe' ]    = $default->use_imap_subscribe;
   $names_vals[ 'show_dotfiles' ]         = $default->show_dotfiles;
   $names_vals[ 'sent_mail' ]             = $default->sent_mail;
   $names_vals[ 'save_sent_mail' ]        = $default->save_sent_mail;
   $names_vals[ 'postponed' ]             = $default->postponed;
   $names_vals[ 'session_enabled' ]       = $default->session_enabled;
   $names_vals[ 'session_timeout' ]       = $default->session_timeout;
   $names_vals[ 'cache_pages' ]           = $default->cache_pages;
   $names_vals[ 'path_to_sendmail' ]      = $default->path_to_sendmail;
   $names_vals[ 'path_to_ispell' ]        = $default->path_to_ispell;
   $names_vals[ 'path_to_mswordview' ]    = $default->path_to_mswordview;
   $names_vals[ 'path_to_tar' ]           = $default->path_to_tar;
   $names_vals[ 'user_change_server' ]    = $default->user_change_server;
   $names_vals[ 'user_change_folder' ]    = $default->user_change_folder;
   $names_vals[ 'user_change_from' ]      = $default->user_change_from;
   $names_vals[ 'user_change_fullname' ]  = $default->user_change_fullname;
   $names_vals[ 'use_ldap_search' ]       = $default->use_ldap_search;
   $names_vals[ 'user_use_addressbook' ]  = $default->user_use_addressbook;
   $names_vals[ 'refresh_delay' ]         = $default->refresh_delay;
   $names_vals[ 'newmail_popup' ]         = $default->newmail_popup;
   $names_vals[ 'language' ]              = $default->lang;
   $names_vals[ 'append_header' ]         = $default->append_header;
   $names_vals[ 'append_trailer' ]        = $default->append_trailer;
   $names_vals[ 'text_parts_inline' ]     = $default->text_parts_inline;
   $names_vals[ 'use_db' ]                = $default->use_db;
   $names_vals[ 'database_driver' ]       = $default->database_driver;
   $names_vals[ 'db_user_name' ]          = $default->db_user_name;
   $names_vals[ 'db_password' ]           = $default->db_password;
   $names_vals[ 'db_name' ]               = $default->db_name;
   $names_vals[ 'db_server_name' ]        = $default->db_server_name;
   $names_vals[ 'db_pref_table' ]         = $default->db_pref_table;
   $names_vals[ 'db_address_table' ]      = $default->db_address_table;

   while( list( $name, $value ) = each( $names_vals ) ) {
      include( './templates/setup/form_hidden_elem.inc' );
   }

}

class temp_default_obj {}

$default = new temp_default_obj;

/*
Color and theme defaults.
*/
$default->dark_bg                = '#002266';
$default->light_bg               = '#e9e9e9';
$default->nav_bg                 = '#dcdcdc';
$default->item_bg                = '#ffffcc';

$default->text_on_light          = new temp_default_obj;
$default->text_on_dark           = new temp_default_obj;

$default->text_on_light->color   = '#000000';
$default->text_on_dark->color    = '#ffffff';

$default->font                   = new temp_default_obj;
$default->font->face             = 'Arial,Helvetica';


if (
      ! file_exists( './config/defaults.php3' )
   || ! file_exists( './lib/horde.lib' )
   || ! file_exists( './lib/mime.lib' )
   || ! file_exists( './imp/config/defaults.php3' )
   || ! file_exists( './imp/lib/db.lib' )
   || ! file_exists( './imp/lib/imp.lib' )
   || ! file_exists( './imp/lib/mimetypes.lib' )
) { 
/*
NO Configuration file found.
*/
   $form_title = '';
   include( './templates/setup/form_header.inc' );
   echo( '<p>
   Please goto the top level directory for your installation and
   run sh ./install.sh this will enable the configuration manager.
   </p>' );
   
} else if (
         ! is_writeable( './config/defaults.php3' )
      || ! is_writeable( './lib/horde.lib' )
      || ! is_writeable( './lib/mime.lib' )
      || ! is_writeable( './imp/config/defaults.php3' )
      || ! is_writeable( './imp/lib/db.lib' )
      || ! is_writeable( './imp/lib/imp.lib' )
      || ! is_writeable( './imp/lib/mimetypes.lib' )
) {
   $form_title = '';
   include( './templates/setup/form_header.inc' );
   echo( '<p>
   Please goto the top level directory for your imp installation and
   run sh ./install.sh this will enable the configuration
   manager.
   </p>' );
} else {


   setup_defaults();

   if ( ereg( '(.*)Back', $go, $temp ) ) {
      switch( $mode ) {
         case IMP_SETUP_WIZ_STEP_3:
            $mode = IMP_SETUP_WIZ_STEP_1;
            break;
         case IMP_SETUP_WIZ_STEP_4:
            $mode = IMP_SETUP_WIZ_STEP_2;
            break;
         case IMP_SETUP_WIZ_STEP_5:
            $mode = IMP_SETUP_WIZ_STEP_3;
            break;
         case IMP_SETUP_WIZ_STEP_6:
            $mode = IMP_SETUP_WIZ_STEP_4;
            break;
         case IMP_SETUP_WIZ_STEP_7:
            $mode = IMP_SETUP_WIZ_STEP_5;
            break;
         case IMP_SETUP_WIZ_STEP_8:
            $mode = IMP_SETUP_WIZ_STEP_6;
            break;
         case IMP_SETUP_WIZ_STEP_9:
            $mode = IMP_SETUP_WIZ_STEP_7;
            break;
         case IMP_SETUP_WIZ_STEP_10:
            $mode = IMP_SETUP_WIZ_STEP_8;
            break;
         case IMP_SETUP_WIZ_STEP_11:
            $mode = IMP_SETUP_WIZ_STEP_9;
            break;
         case IMP_SETUP_WIZ_STEP_WRITE_FILE:
            $mode = IMP_SETUP_WIZ_STEP_10;
            break;
         default:
            break;
      }
   }
   $form_next = IMP_SETUP_WIZ_STEP_1;
   $step_num  = 1;

   switch ( $mode ) {
      case IMP_SETUP_WIZ_STEP_1:
         /* include( './config/defaults.php3' ); */
         include( './imp/config/defaults.php3' );
         $form_next        = IMP_SETUP_WIZ_STEP_2;
         $step_num  = 1;
         break;
      case IMP_SETUP_WIZ_STEP_2:
         $form_next        = IMP_SETUP_WIZ_STEP_3;
         $step_num  = 2;
         break;
      case IMP_SETUP_WIZ_STEP_3:
         $form_next        = IMP_SETUP_WIZ_STEP_4;
         $step_num  = 3;
         break;
      case IMP_SETUP_WIZ_STEP_4:
         $form_next        = IMP_SETUP_WIZ_STEP_5;
         $step_num  = 4;
         break;
      case IMP_SETUP_WIZ_STEP_5:
         $form_next        = IMP_SETUP_WIZ_STEP_6;
         $step_num  = 5;
         break;
      case IMP_SETUP_WIZ_STEP_6:
         $form_next        = IMP_SETUP_WIZ_STEP_7;
         $step_num  = 6;
         break;
      case IMP_SETUP_WIZ_STEP_7:
         $form_next        = IMP_SETUP_WIZ_STEP_8;
         $step_num  = 7;
         break;
      case IMP_SETUP_WIZ_STEP_8:
         $form_next        = IMP_SETUP_WIZ_STEP_9;
         $step_num  = 8;
         break;
      case IMP_SETUP_WIZ_STEP_9:
         $form_next        = IMP_SETUP_WIZ_STEP_10;
         $step_num  = 9;
         break;
      case IMP_SETUP_WIZ_STEP_10:
         $form_next        = IMP_SETUP_WIZ_STEP_11;
         $step_num  = 10;
         break;
      case IMP_SETUP_WIZ_STEP_11:
         $form_next        = IMP_SETUP_WIZ_STEP_WRITE_FILE;
         $step_num  = 11;
         break;
      case IMP_SETUP_WIZ_STEP_WRITE_FILE:
         $form_next        = IMP_SETUP_WIZ_STEP_WRITE_FILE;
         $step_num         = 12;
         write_file();
         break;
      default:
         $form_next  = IMP_SETUP_WIZ_STEP_2;
         $mode       = IMP_SETUP_WIZ_STEP_1;
         $step_num  = 1;
         break;
   }

   if ( $FORM_MAPPINGS[ $mode ] != '' ) {
   $form_title       = 
         $lang->title . ' ( ' . 
            $step_num . ' of ' . count( $FORM_MAPPINGS ) . ' )';
   include( './templates/setup/imp/' . $FORM_MAPPINGS[ $mode ] );
   }

}

?>

