<?php

/*
  
  File: manager.php3
  $Author: zerodiv $
  $Revision: 1.7 $
  $Date: 1999/04/21 22:43:50 $
  
  IMP: Copyright 1998 Charles J. Hagenbuch  <chuck@horde.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/

if (!defined("HORDE_LIB")) include ('./lib/horde.lib');
require('./config/defaults.php3');

$IMP = 0;
$NAG = 0;

/* LOAD Horde COnfiguration */
include( './config/defaults.php3' );
include( './config/html.php3' );
include( './config/db.php3' );
include( './lib/db.lib' );

if ( is_dir( './imp' )  ) {
$IMP = 1;
include('./imp/lib/imp.lib');      /* IMPlib is the IMP function library  */
include('./imp/config/defaults.php3' );
include('./imp/config/html.php3' );
}

if ( is_dir( './nag' ) ) {
$NAG = 1;
include('./nag/lib/nag.lib');      /* NAGlib is the NAG function library  */
include('./nag/lib/db.lib' );
include('./nag/config/defaults.php3' );
include('./nag/config/html.php3' );
}

$language = select_lang();

/*
error_reporting( $default->error_level );
*/

switch ( $action ) {
   case LOGIN_MODE:
      $mode             = $action;
      $sidebar          = false;
      break;
   case MGR_USER_ADD_FRM:
      $mode             = $action;
      $sidebar          = false;
      break;
   case MGR_USER_EDIT_SELECT_FRM:
      $mode             = $action;
      $sidebar          = false;
      break;
   case MGR_USER_EDIT_FRM:
      $mode             = $action;
      $sidebar          = false;
      break;
   case MGR_USER_ADD:
      $mode             = $action;
      $sidebar          = false;
      break;
   case MGR_USER_EDIT:
      $mode             = $action;
      $sidebar          = false;
      break;
}

$title   = 'Horde Manager';
require( "./templates/doctype.inc" );
require( "./templates/generic-header.inc" );

$user_db       = new HordeDb_User();
$temp_obj      = new HordeUser;

$temp_obj->user_name          = $horde_user;
$temp_obj->password           = $horde_password;

$ret_vals = $user_db->Verify( $temp_obj );

$LOGGED_IN = 0;

if ( $ret_vals[ 0 ] == 1 ) {
   $LOGGED_IN = 1;
} else {
   $LOGGED_IN = 0;
   $action    = -1;
   $mode      = -1;
   include( './templates/manager/login.inc' );
}
switch ( $action ) {

   case MGR_USER_ADD_FRM:
      
      include( './templates/manager/user/add/form.inc' );
      break;

   case MGR_USER_EDIT_SELECT_FRM:

      include( './templates/manager/user/add/process_form.inc' );
      break;

   case MGR_USER_EDIT_FRM:
      include( "$default->include_dir/manager/edit_user.inc" );
      break;
   
   case MGR_USER_ADD:
      include( "$default->include_dir/manager/add_user_results.inc" );
      break;

   case MGR_USER_EDIT:
      include( "$default->include_dir/manager/edit_user_results.inc" );
      break;

   case LOGIN_MODE:
      include( './templates/manager/toolbar.inc' );
      break;

   default:
      include( './templates/manager/login.inc' );
      break;
}
?>

<hr>
Horde Manager
<br>
By: ZeroDiVide
</body>
</html>
