<?php

/*
 
 File: problem.php3
 $Author: rkrusty $
 $Revision: 1.11 $
 $Date: 1999/04/19 19:28:13 $
 
 HORDE: Copyright 1999 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */

    
/* Send the browser back to the correct page */
function return_to_page() {
    global $this_client, $return_url;
    if (isset($return_url)) {
	if(! $this_client->lynx ) {
	    echo "<script language=\"JavaScript\">window.location=\"" . $return_url . "\"</script></body></html>";
	} else {
	    header("Location: " . $return_url);
	}
    } else {
	if(! $this_client->lynx ) {
	    echo "<script language=\"JavaScript\">window.location=\"login.php3\"</script></body></html>";
	} else {
	    header("Location: login.php3");
	}
    }
    exit;
}

$need_horde_db = 1;
$db_lib_loaded = 0;
require ('./lib/horde.lib');    /* Horde lib is the HORDE function library  */
require ('./config/defaults.php3');          /* Defaults configuration file         */
require( './config/horde.php3' );

/* Html styles configuration */
require('./config/html.php3');
require('./config/mime.php3');

require ('./lib/mime.lib');                  /* Mime lib for composing mime messages */
$language = select_lang();
require ("./locale/$language/problem.lang");
require ("./locale/local/problem.lang");

/* Setup the this_client object */
$this_client = new WebClient;

/* send headers to ensure that the page will reload correctly. */
$Check_Client = true;
caching_headers($Check_Client);

error_reporting($default->error_level);      /* set error level from imp.lib   */

/* array to translate string actions into the appropriate integer ID */
if ( ! $this_client->lynx ) {
    $actions[$lang->button_send]          = SEND_MESSAGE;
    $actions[$lang->button_cancel]        = NO_ACTION;
} else {
    $actions[ '[ ' . $lang->button_send . ' ]']          = SEND_MESSAGE;
    $actions[ '[ ' . $lang->button_cancel . ' ]']        = NO_ACTION;
}

/* doctype */
require("$default->horde_include_dir/doctype.inc");

/* Run through action handlers */

if (isset($actionID)) {
    /* translate non-int values into the correct int */
    if (strcspn($actionID, '0123456789')) { $actionID = $actions[$actionID]; }
    
    switch ($actionID) {
	
    case SEND_MESSAGE:
	
	if ($subject && $message) { // need to check to make sure the other parts are there as well
	    /* somehow need to verify email addresses */

	    $message = str_replace("\r\n", "\n", $message);
	    
	    $mime = new mime_message;
	    $mime->init($message);
	    
	    $text_part = new mime_part;
	    $text_part->type = 'text';
	    $text_part->subtype = 'plain';
	    $text_part->contents = wrap_message($message, 80, "\n");

	    /* add footer to text_part */
	    if ($default->append_trailer) {
		$config_trailer = "\n" . implode(@file('./config/trailer.txt'), '');
		$config_trailer = set_env_in_string($config_trailer);
		$text_part->contents .= $config_trailer;
	    }
	    
	    $mime->add_begin_part($text_part);
	    
	    $msg = $mime->generate();

            $from = 'horde-problem@localhost';
            $barefrom = 'horde-problem@localhost';

	    $hdrs  = "Errors-To: $barefrom\n";
	    $hdrs .= "Reply-To: $from\n";
	    $hdrs .= $mime->header();
	    
	    $hdrs .= 'X-Mailer: HORDE/PHP3 ' . HORDE_LIB_VERSION;
	    $hdrs .= "\n";

            $subject = $lang->problem_subject;
	    $to = $default->problem_email;
	    
	    if (mailfrom($to, $from, $barefrom, $subject, $hdrs, $msg)) {
	
	
		/* we succeeded. print success message, load mailbox, and quit */
		status($lang->status_send_success);
                return_to_page();
	    }
	} else {

	    /* something wasn't quite right. strange */
	    $ACTION_TEXT = $lang->action_compose;
	    status($lang->status_error_required_field);
	}
	break;
	
    case NO_ACTION:
    default:
	return_to_page();
	break;
	
    }
} else { $ACTION_TEXT = $lang->action_compose; }
if (!isset($status_sent)) { status($lang->status_composition); }

$title = $lang->status_composition;
$sidebar = false;
require("$default->horde_include_dir/generic-header.inc");

$from = 'horde-problem@localhost';
$barefrom = 'horde-problem@localhost';
if (!isset($message)) { $message = ''; }
if (!isset($subject)) { $subject = ''; }

if (!$this_client->lynx) {
    include("$default->horde_include_dir/problem/problem.inc");
} else {
    include("$default->horde_include_dir/problem/lynx_problem.inc");
}

require("$default->horde_include_dir/generic-footer.inc");
if (!$this_client->lynx) {
    include("$default->horde_include_dir/problem/javascript.inc");
}

?>
