<?php

/*
 
 File: signup.php3
 $Author: rkrusty $
 $Revision: 1.5 $
 $Date: 1999/04/13 22:49:51 $
 
 HORDE: Copyright 1999 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
*/

/*
 * Replace %ENV_NAME% in string with the respective environmental
 * variable
 */
function set_env_in_string($text) {
  while(ereg("%([A-Za-z_]+)%", $text, $regs)) {
    $text = ereg_replace( "%([A-Za-z_]+)%", getenv($regs[1]), $text );
  }
  return $text;
}

/* function that interfaces to sendmail, so from address and all headers
 * are set correctly
 */

function mailfrom($to, $from, $barefrom, $subject, $hdrs, $mesg) {
   global $default;

   $hdrs .= "Sender: $barefrom\n";
   if ($default->append_header) {
     $config_hdrs = implode(@file('./config/header.txt'), '');
     $config_hdrs = set_env_in_string($config_hdrs);
     $hdrs .= $config_hdrs;
   }


   if (is_executable($default->path_to_sendmail)) {
      $mail = popen("$default->path_to_sendmail -t -i -f '$barefrom'", 'w');

      $result  = fputs($mail, "From: $from\n");
      $result += fputs($mail, "To: $to\n");
      $result += fputs($mail, $hdrs);
      $result += fputs($mail, "Subject: [IMP Signup] $subject\n\n");
      $result += fputs($mail, $mesg);

      if (pclose($mail) != 0) $result = 0;

   } else {

      $hdrs = "From: $from\n" . $hdrs;

      if (mail($to, $subject, $mesg, $hdrs)) { $result = 1; }
      else { $result = 0; }
   }

   if ($result > 0) { return 1; }
   else { return 0; }
}


$need_horde_db = 1;
$db_lib_loaded = 0;
require ('./lib/horde.lib');
require ('./config/defaults.php3');
require( './config/horde.php3' );

/* Html styles configuration */
require('./config/html.php3');
require('./config/mime.php3');
require('./config/lang.php3');

require ('./lib/mime.lib');

$language = select_lang();
require ("./locale/$language/signup.lang");
require ('./locale/local/signup.lang');
$help_file = 'signup.help';
require ("./locale/defines/$help_file");

$this_client = new WebClient;

error_reporting($default->error_level);
caching_headers();


/* array to translate string actions into the appropriate integer ID */
if ( ! $this_client->lynx ) {
    $actions[$lang->button_signup]          = SEND_MESSAGE;
    $actions[$lang->button_cancel_signup]        = NO_ACTION;
} else {
    $actions[ '[ ' . $lang->button_signup . ' ]']          = SEND_MESSAGE;
    $actions[ '[ ' . $lang->button_signup_cancel . ' ]']        = NO_ACTION;
}

if (!($from_imp)) {
   $from_imp='false';
}


require("$default->horde_include_dir/doctype.inc");

if (isset($actionID)) {
    /* translate non-int values into the correct int */
    if (strcspn($actionID, '0123456789')) { $actionID = $actions[$actionID]; }

    switch ($actionID) {

    case SEND_MESSAGE:

        if ($subject && $user1 && $user2 && $user3 && $pass1 && $pass2 && $email && $real_name ) { // need to check to make sure the other parts are there as well
            /* somehow need to verify email addresses */

            $mime = new mime_message;
            $mime->init($message);

            $text_part = new mime_part;
            $text_part->type = 'text';
            $text_part->subtype = 'plain';
            $text_part->contents = wrap_message("$message\n\nName: $real_name\nEmail: $email\n\nUsername: $user1, $user2, $user3\nPassword: $pass1, $pass2\n\n", 80, "\n");

            /* add footer to text_part */
            if ($default->append_trailer) {
                $config_trailer = "\n" . implode(@file('./config/trailer.txt'),
'');
                $config_trailer = set_env_in_string($config_trailer);
                $text_part->contents .= $config_trailer;
            }

            $mime->add_begin_part($text_part);

            $msg = $mime->generate();

              $from = 'imp-signup@localhost';
              $barefrom = 'imp-signup@localhost';

            $hdrs  = "Errors-To: $barefrom\n";
            $hdrs .= "Reply-To: $from\n";
            $hdrs .= $mime->header();

            $hdrs .= 'X-Mailer: IMP/PHP3 Imap webMail Program ' . IMP_VERSION;
            $hdrs .= "\n";


            $to = $default->signup_email;

            if (mailfrom($to, $from, $barefrom, $subject, $hdrs, $msg)) {

                /* we succeeded. print success message, load mailbox, and quit */
                status($lang->status_send_success);
        if(! ($from_imp == 'false')) {
                if(! $this_client->lynx ) {
                    echo '<script language="JavaScript">window.location="imp/login.php3"</script></body></html>';
                } else {
                    include( './imp/login.php3' );
                }
         } else {
               if(! $this_client->lynx ) {
                    echo '<script language="JavaScript">window.location="login.php3"</script></body></html>';
                } else {
                    include( './login.php3' );
                }      

         }
                exit;
            }
        } else {

            /* something wasn't quite right. strange */
            $ACTION_TEXT = $lang->imp_signup;
            status($lang->alert);
        }
        break;

    case NO_ACTION:
    default:
        if(! ($from_imp == 'false')) {
        if(! $this_client->lynx ) {
            echo '<script language="JavaScript">window.location="imp/login.php3"</script></body></html>';
        } else {
            include( './imp/login.php3' );
        }
        } else {
                if(! $this_client->lynx ) {
                    echo '<script language="JavaScript">window.location="login.php3"</script></body></html>';
                } else {         
                    include( './login.php3' );
                }      

        }
        exit;
        break;

    }
} else { $ACTION_TEXT = $lang->imp_signup; }
if (!isset($status_sent)) { status($lang->signup); }
$title = $lang->signup;
$sidebar = false;
require("$default->horde_include_dir/generic-header.inc");

$from = 'imp-signup@localhost';
$barefrom = 'imp-signup@localhost';
if (!isset($msg)) { $msg = ''; }
if (!isset($subject)) { $subject = ''; }


   require("$default->horde_include_dir/signup/signup.inc");
   require("$default->horde_include_dir/generic-footer.inc");
?>
