#!/usr/bin/perl -w

# Simplified module build script

sub print_usage {
   print <<"USAGE"

buildlib.pl : Horde Library build program.

   This program builds a Horde library.

   It can take as arguments the location of a file with more directives:
      ./build.pl --with-config=./build.opts

   Another example would be :
      ./build.pl --with-config=/etc/horde/build.opts

   Or the directives themselves:
      ./build.pl --with-database=postgres
	  
USAGE
}

# Default file containing all the options
$Options_File = "build.opts";

# Final resting place of the module's libraries
$Horde_Library_File = "../lib/horde.lib";


# Parse command-line arguments
foreach $Argument (@ARGV) {

    # Check to see if they gave us a database
    if($Argument =~ /--with-database=(.*)/) {
	$Options{"database"} = $1;

    # Check to see if they tell us a new config file location
    } elsif($Argument =~ /--with-config=(.*)/) {
	$Options_File = $1;
    }
}

# If it exists, Open the options file and set all of the options into a hash
if(-e $Options_File) {
    open(OPTIONS, $Options_File) ||
	die "Couldn't open options file $Options_File: $!\n";
    
    while(<OPTIONS>) {
	chomp();
	($Option_Name, $Option_Value) = split('=', $_);
	$Options{$Option_Name} = $Option_Value;
	#print "Set $Option_Name equal to $Option_Value\n";  # debugging
    }
    close(OPTIONS);
} else {
    open(OPTIONS, $Options_File) ||
	warn "Couldn't open options file $Options_File: $!\n";
}


# Construct the basic list of files to include for the main IMP library
@Horde_Library_Files = (
			'includes/HordeCopyright.inc',
			'defines/GlobalDefines.def',
			'defines/HordeDb.def',
			'defines/HordeLibVersion.def',
			'objects/HordeAdminPrivlage.object',
			'objects/HordeConfigForm.object',
			'objects/HordeCookies.object',
			'objects/HordeDataGrant.object',
			'objects/HordeDefaults.object',
			'objects/HordeGrant.object',
			'objects/HordeGroup.object',
			'objects/HordeHelp.object',
			'objects/HordeImapServer.object',
			'objects/HordeLocaleLang.object',
			'objects/HordeSession.object',
			'objects/Html/HtmlBold.object',
			'objects/Html/HtmlDocument.object',
			'objects/Html/HtmlFont.object',
			'objects/Html/HtmlTable.object',
			'objects/Html/HtmlTableCell.object',
			'objects/Html/HtmlTableRow.object',
			'objects/HordeUser.object',
			'objects/WebClient.object'
			);

# Build the library
build_lib($Horde_Library_File, @Horde_Library_Files);


# Helper functions
sub build_lib {

    # Get the library name and the array of files to build from the argument list
    local($Library_Name, @Library_Files) = @_;

    # Open the library file up or die trying
    open( LIBRARY, "> $Library_Name" )
   	|| die "Can\'t open $Library_Name for writing: $!\n";

    # Start the file with the requisite PHP magic
    print LIBRARY "<?php\n\n";

    # Put all of the files into the library
    foreach $Library_File (@Library_Files) {
	#print "I should be adding: $Library_File\n"; # debugging
	add_file(LIBRARY, $Library_File);
    }

    # Close the file with the requisite PHP magic
    print LIBRARY "?>\n";
    close( LIBRARY );
}

sub add_file {
   local(*OUT_FH, $Filename) = @_;
   #print "\tAdding file : $Filename\n"; #debugging

   # Open the library section with a comment on the upcoming source file
   print OUT_FH "/*\nSource File - $Filename\n*/\n";

   # Open the source file and dump the contents into the library
   open( IN_FH, $Filename ) || die "Unable to open $Filename: $!\n";
   while( <IN_FH> ) { print OUT_FH $_; }
   close( IN_FH );   

   # Close the library section with a comment
   print OUT_FH "/*  EOF - $Filename  */\n";
}


