<?php
// $Horde: forwards/main.php,v 1.1.1.1.2.4 2002/10/09 04:28:59 ericr Exp $

define('FORWARDS_BASE', dirname(__FILE__));
include_once FORWARDS_BASE . '/lib/base.php';
require_once FORWARDS_BASE . '/config/conf.php';

// create a driver
require_once FORWARDS_BASE . '/lib/Driver.php';
$driver = &Forwards_Driver::factory($conf['server']['driver'], $conf['server']['params']);

// Get the current login username and realm
$split = explode('@', Auth::getAuth());
$user = @$split[0]; $realm = @$split[1];
if (empty($realm)) {
    $realm = "default";
}

$submit=Horde::getFormData('submit', false);

if ( $submit ) {
    $forwardmode=Horde::getFormData('mode', "error");
    if ($forwardmode === "error") {
        Horde::raiseMessage(_("You must specify the mode"),
                            HORDE_WARNING);
    }

    // Check for refused usernames, using current horde username

    if (in_array($user, $conf['user']['refused'])) {
        $msg=sprintf (_("You can't change Forwards for user %s"), $user);
        Horde::raiseMessage($msg,HORDE_ERROR);
        $forwardmode = "error";
    }
    $oldpassword=Horde::getFormData('oldpassword', false);
    if (!$oldpassword) {
        Horde::raiseMessage(_("You must give your password"),HORDE_WARNING);
        $forwardmode = "error";
    }

    $metoo=Horde::getFormData('metoo', false);
    if ($metoo != "on") $metoo = "off";

    switch ($forwardmode) {
    case "error":
        break;

    case "set":
        $forwardwhere=Horde::getFormData('where', false);
        if (!$forwardwhere) {
            Horde::raiseMessage(_("You must supply an e-mail address"),HORDE_WARNING);
        } else {
            if ($driver->enableForwarding($user, $realm, $oldpassword, $forwardwhere, $metoo)) {
                Horde::raiseMessage(_("Forward set!"),HORDE_SUCCESS);
            } else {
                Horde::raiseMessage( _("Failure in setting forward : ") . 
                    $driver->err_str, HORDE_ERROR);
            }
        }
        break;

    case "unset":
        if ($driver->disableForwarding($user, $realm, $oldpassword)) {
            Horde::raiseMessage(_("Forward removed!"),HORDE_SUCCESS);
        } else {
            Horde::raiseMessage( _("Failure in removing forward : ") . 
                    $driver->err_str, HORDE_ERROR);
        }
        break;

    default:
        break;
    }
}

    include_once $registry->getTemplatePath('horde') . '/javascript/open_help_win.js';
    require $registry->getTemplatePath() . '/common-header.inc';
    require $registry->getFileRoot() . '/status.php';
    require $registry->getTemplatePath() . '/main.inc';
    require $registry->getTemplatePath() . '/common-footer.inc';
?>
