<?php

    class forwards {

    var $fp;
    var $err_str;

function random_hex($length=16)
{
        srand(time());
        $pool = "0123456789ABCDEF";
        $value = "";
        for ($index = 0; $index < $length; $index++)
                { $value .= substr($pool, (rand()%(strlen($pool))),1); }
        return $value;
}

function create_temp_file($user,$contents)
{
        $oldUmask = umask(0077);
        $myTempFile = "/tmp/" . $user . $this->random_hex();

        if (file_exists($myTempFile)) {
            $this->err_str = _("File open failed - File exists");
            return false;
        } 
        if (!($fileHandle = fopen($myTempFile, "w"))) {
            $this->err_str = _("Could not create file");
            return false;
        }
        if (!(fputs($fileHandle, $contents))) {
            $this->err_str = _("Could not write to file");
            return false;
        }
        fclose($fileHandle);
        umask($oldUmask);
        return $myTempFile;
}

function ftp_delete_file($user, $realm, $pass, $file)
{
        if (!($ftpConnection = @ftp_connect($this->get_server($realm),
                                            $this->get_port($realm)))) {
            $this->err_str = _("Server connection failed");
            return false;
        }

        if (!(@ftp_login($ftpConnection, $user, $pass))) {
            $this->err_str = _("Could not login - check password!");
            @ftp_quit($ftpConnection);
            return false;
        }
        // should probably do a cwd to their home, but we don't...
        //ftp_chdir($ftpConnection, "/home/eric/");
        if (!(@ftp_delete($ftpConnection, $file))) {
            $this->err_str = "Error deleting $file file -- Maybe you didn't have a forward installed?";
            @ftp_quit($ftpConnection);
            return false;
        }
        @ftp_quit($ftpConnection);
        return true;
}

function ftp_copy_file($user, $realm, $pass, $src, $dst, $mode=FTP_ASCII)
{
        if (!($ftpConnection = @ftp_connect($this->get_server($realm),
                                            $this->get_port($realm)))) {
            $this->err_str = _("Server connection failed");
            return false;
        }

        if (!(@ftp_login($ftpConnection, $user, $pass))) {
            $this->err_str = _("Could not login -- check password!");
            @ftp_quit($ftpConnection);
            return false;
        }
        // should probably do a cwd to their home, but we don't...
        //ftp_chdir($ftpConnection, "/home/eric/");
        // ftp_put won't overwrite existing file, so nuke it unconditionally
        @ftp_delete($ftpConnection, $dst);
        if (!(@ftp_put($ftpConnection, $dst, $src, $mode))) {
            $this->err_str = _("Could not set forwarding!");
            @ftp_quit($ftpConnection);
            return false;
        }
        @ftp_quit($ftpConnection);
        return true;
}

    function get_server($realm) {
        $conf = &$GLOBALS['conf'];
        $server = @$conf['server']['default']['host'];
        if ( isset($realm) && $realm != "" ) {
           if (isset($conf['server'][$realm]['host']) )
              $server = $conf['server'][$realm]['host'];
        }
        if ( $server == "") {
           $this->err_str = _("Warning: Module not properly configured! Assuming localhost");
           $server = "localhost";
        }
       return $server;
    }

    function get_port($realm) {
        $conf = &$GLOBALS['conf'];
        $port = @$conf['server']['default']['port'];
        if ( isset($realm) && $realm != "" ) {
           if (isset($conf['server'][$realm]['port']) )
              $port = $conf['server'][$realm]['port'];
        }
        if ( $port == "") {
           $port = "21";
        }
       return $port;
    }

    function set_forward($user, $realm, $pass, $where, $metoo) {
        $conf = &$GLOBALS['conf'];
        $address = $where;
        if ($metoo == "on") $address .= ", \\$user";
        $myFile = $this->create_temp_file($user, "$address");
        if (!file_exists($myFile)) return false;
        $status = $this->ftp_copy_file($user, $realm, $pass, $myFile, ".forward");
        unlink($myFile);
        if (! $status) return false;
        return true;
    }

    function unset_forward($user, $realm, $pass) {
        if (! $this->ftp_delete_file($user, $realm, $pass, ".forward") )
             return false;
        return true;
    }

}

?>
