<?php
/*
 * $Horde: chora/co.php,v 1.9.2.3 2002/03/20 20:30:03 chuck Exp $
 *
 * Copyright 2000-2002 Anil Madhavapeddy <anil@recoil.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('CHORA_BASE', dirname(__FILE__));
require_once CHORA_BASE . '/lib/base.php';
require_once HORDE_BASE . '/config/mime_mapping.php';
require_once HORDE_BASE . '/config/mime_drivers.php';
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/MIME/Part.php';
require_once HORDE_BASE . '/lib/MIME/Magic.php';
require_once HORDE_BASE . '/lib/MIME/Viewer.php';

if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

if (Chora::isRestricted($where)) {
    fatal('403 Forbidden', "$where: forbidden by server configuration");
}

/* Should we pretty-print this output or not? */

$plain = Horde::getFormData('p', 0);

/* Create the CVSLib_File object and populate it */

checkError($file = new CVSLib_File($CVS, $fullname, CVSLIB_LOG_FULL));
checkError($file->getBrowseInfo());

/* Get the revision number. */

$r = Horde::getFormData('r', 0);

/* If no revision is specified, default to HEAD.
 * If a revision is specified, it's safe to cache for a long time */

if ($r == 0) {
    $r = $file->queryRevision();
    header('Cache-Control: max-age=60, must-revalidate');
} else {
    header('Cache-Control: max-age=2419200');
}

/* Is this a valid revision being requested? */

if (!CVSLib_rev::valid($r)) {
    fatal('404 Not Found', "Revision Not Found: $r is not a valid RCS revision number");
}

/* Retrieve the actual checkout */

$checkOut = CVSLib_Checkout::get($CVS, $fullname, $r);

/* Calculate the file extension, to identify the MIME type */

$extension = $file->getExtension();

/* Check error status, and either show error page, or the checkout contents */

if (is_object($checkOut) && $checkOut->id() == CVSLIB_ERROR) {
    checkError($checkOut);
} else if (!$plain) {
    /* Pretty-print the checked out copy */
    $pretty = CVSLib_Checkout::pretty($CVS, $extension, $checkOut);
    $log = $file->logs[$r];
    $log_print = htmlify($log->queryLog());

    if ($pretty->getType() == 'text/html' || $pretty->getType() == 'text/plain') {
        $title = sprintf(_("CVS Checkout of %s (revision %s)"), basename($fullname), $r);
        $js_onLoad = null;
        include CHORA_TEMPLATES . '/common-header.inc';
        include CHORA_TEMPLATES . '/checkout/header.inc';
        if ($pretty->getType() == 'text/plain') {
            echo '<pre>' . htmlspecialchars($pretty->render()) . '</pre>';
        } else {
            echo $pretty->render();
        }
        include CHORA_TEMPLATES . '/checkout/footer.inc';
        include CHORA_TEMPLATES . '/common-footer.inc';
    } else {
        header('Content-Type: ' . $pretty->getType());
        print $pretty->render();
    }
} else {
    /* Just dump the checked out copy to the user as-is */
    $mime_type = MIME_Magic::extToMIME($extension);
    header("Content-Type: $mime_type");
    fpassthru(CVSLib_Checkout::get($CVS, $fullname, $r));
}

?>
