<?php
/*
 * $Horde: babel/test.php,v 1.3 2000/09/27 19:36:06 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999, 2000 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

session_start();
/* Register a session. */
if (!isset($horde_test_count)) {
	$horde_test_count = 0;
	session_register("horde_test_count");
}

/* We want to be as verbose as possible here. */
error_reporting(E_ALL);

function status($foo) {
    if ($foo) {
        echo '<font color="green"><b>Yes</b></font>';
    } else {
        echo '<font color="red"><b>No</b></font>';
    }
}

/* PHP Version */
$version = phpversion();
$major = $version[0];
if ($major == 3) {
    $bits = explode('.', $version);
    $minor = $bits[count($bits) - 1];
} else {
	if (strspn($version, '0123456789.') == strlen($version)) {
		$bits = explode('.', $version);
		$minor = $bits[count($bits) - 1];
	} else {
		$minor = substr($version, 3);
	}
}

/* PHP module capabilities */
$imap = function_exists('imap_open');
$ldap = function_exists('ldap_bind');
$mysql = function_exists('mysql_pconnect');
$pgsql = function_exists('pg_pconnect');
$mcal = function_exists('mcal_open');
$ftp = function_exists('ftp_connect');
$gettext = function_exists('gettext');
$xml = function_exists('xml_parser_create');

/* PHP Settings */
$magic_quotes_gpc = !get_magic_quotes_gpc();
$magic_quotes_runtime = !get_magic_quotes_runtime();

/* Handle special modes */
if (isset($mode)) {
    switch ($mode) {
    case 'phpinfo':
        phpinfo();
        exit;
        break;
    
    case 'unregister':
        session_unregister("horde_test_count");
        ?>
        <html>
        <body bgcolor="white" text="black">
        <font face="Helvetica, Arial, sans-serif" size="2">
        The test session has been unregistered.<br>
        <a href="test.php">Go back</a> to the test.php page.<br>
        <?php
        exit;
        break;
    
    default:
        break;
    }
} else {
?>

<html>
<head>
<title>Horde: System Capabilities Test</title>
</head>

<body bgcolor="#ffffff" text="#000000">

<font face="Helvetica, Arial, sans-serif" size="2">
<a href="test.php?mode=phpinfo">View phpinfo() screen</a>

<h3>PHP Version</h3>
<ul>
   <li>PHP Version: <?php echo $version; ?></li>
   <li>PHP Major Version: <?php echo $major; ?></li>
   <li>PHP Minor Version: <?php echo $minor; ?></li>
   <?php if ($major == 3) {
     if ($minor < 12): ?>
     <li><font color="red">Your PHP3 version is older than 3.0.12. You should upgrade.</font></li>
     <?php else: ?>
     <li><font color="green">Your PHP3 version is recent. You should not have any problems with Horde modules.</font></li>
     <?php endif;
   } elseif (strstr($minor, 'b')) {
     if ($minor[1] < 3): ?>
       <li><font color"red">Your PHP4 is older than Beta3. You should upgrade.</font></li>
			 <?php else: ?>
				     <li><font color="green">You are running a recent beta of PHP4. You should be okay.</font></li>
				     <?php endif;
   } elseif (strstr($minor, 'RC')) { ?>
     <li><font color="green">You are running a release candidate of PHP4. You should be okay.</font></li>
   <?php } elseif ($minor >= 0) { ?>
     <li><font color="green">You are running a stable release of PHP4. Enjoy the ride!</font></li>
   <?php } else { ?>
     <li><font color="orange">Wow, a mystical PHP from the future. Let <a href="mailto:dev@lists.horde.org">dev@horde.org</a> know what version you have so we can fix this script.</font></li>
   <?php } ?>
</ul>

<h3>PHP Module Capabilities</h3>
<ul>
   <li>IMAP Support: <?php status($imap) ?></li>
   <?php if (!$imap) { ?><li><font color="red">Without IMAP support, <a href="http://horde.org/imp/">IMP</a> will not run. You will need to fix this if you want to run IMP.</font></li><?php } ?>
   <li>LDAP Support: <?php status($ldap); ?></li>
   <li>MySQL Support: <?php status($mysql); ?></li>
   <li>PostgreSQL Support: <?php status($pgsql); ?></li>
   <li>MCAL Support: <?php status($mcal); ?></li>
   <li>FTP Support: <?php status($ftp); ?></li>
   <li>Gettext Support: <?php status($gettext); ?></li>
   <li>XML Support: <?php status($xml); ?></li>
</ul>

<h3>Miscellaneous PHP Settings</h3>
<ul>
   <li>magic_quotes_gpc set to Off: <?php echo status($magic_quotes_gpc); ?></li>
   <?php if (!$magic_quotes_gpc) { ?>
   <li><font color="red">magic_quotes_gpc causes data coming from GET, POST, or COOKIE modes to be processed so that single quotes and backslashes are prefixed with a backslash (\'). This makes your email look very ugly. Turn it off.</font></li>
   <?php } ?>
   <li>magic_quotes_runtime set to Off: <?php echo status($magic_quotes_runtime); ?></li>
   <?php if (!$magic_quotes_runtime) { ?>
   <li><font color="red">magic_quotes_runtime may not cause quite as many problems as magic_quotes_gpc, but you still do not need it. Turn it off.</font></li>
   <?php } ?>
</ul>

<h3>PHP Sessions</h3>
<?php $horde_test_count++; ?>
<ul>
   <li>Session counter: <?php echo $horde_test_count; ?></li>
   <li>To unregister the session: <A HREF="test.php?mode=unregister">click here</A>
</ul>

</font>

<?php } ?>

</body>
</html>
