<?php

####################
# request structure
####################
class RequestObj {
    var $dbh = ''; // the database handle
    var $topic = ''; // the topic
    var $action = ''; // the module being run
    var $id = ''; // the current id
    var $user_id = ''; // the users id
    var $anon_id = ''; // the user id for anonymous posts
    var $post; // post hash - the current post
    var $read_posts; // read posts array - the posts that have been read
    var $open_posts; // open posts array - the post folders that are open
    var $child_ids;  // children
    var $topic_root = '';
    var $posts; // posts array - the hash caching retrieved posts
    var $editors; // array of editors
    var $link = '';
  
    function RequestObj () {
        $this->post = array();
        $this->read_posts = array();
        $this->open_posts = array();
        $this->posts = array();
        $this->editors = array();
        $this->child_ids = array();
    }
}


// random list utility functions
function member ($elt, $list) {
    while (list($key, $val) = each($list)) {
        if ($val == $elt)
            return true;
    }
  
    return false;
}

function reverse ($list) {
    $len = count($list);
    $new = array();
  
    for ($i = 0; $i < $len; $i++) {
        $new[($len-$i-1)] = $list[$i];
    }
  
    return $new;
}

function pop (&$list) {
    if (count($list) == 0)
        return '';
    else if (count($list) == 1) {
        $tmp = $list[0];
        $list = array();
        return $tmp;
    } else {
        $len = count($list);
        $val = $list[$len-1];
        $new = array();
    
        for ($i = 0; $i < ($len-1); $i++) {
            $new[] = $list[$i];
        }
    
        $list = $new;
        return $val;
    }
}

/* constants */

define('FAILURE', false);
define('SUCCESS', true);


function init_action (&$request_ref) {
    global $PATH_INFO, $conf;
    
    if (!isset($PATH_INFO) || !$PATH_INFO) {
        $action = $conf['default_action'];
    } else {
        if ($PATH_INFO[0] == '/') $PATH_INFO = substr($PATH_INFO, 1, strlen($PATH_INFO)-1);
        $info = explode('/', $PATH_INFO);
        
        if (isset($info[0]))
            $action = $info[0];
        else
            $action = $conf['default_action'];
    }
    
    $request_ref->action = $action;
    
    return success();
} // init_action()

function init_editors_list (&$request_ref) {
  global $conf;
  
  if (!isset($conf['editors']) || !($editors = split(",[[:alnum:]_]?", $conf['editors'])))
    return success();
  
  $request_ref->editors = $editors;
  
  return success();
}

function init_id (&$request_ref) {
    global $PATH_INFO;
  
    if (!isset($PATH_INFO) || !$PATH_INFO) {
        $id = 0;
    } else {
        if ($PATH_INFO[0] == '/') $PATH_INFO = substr($PATH_INFO, 1, strlen($PATH_INFO)-1);
        $info = explode('/', $PATH_INFO);
    
        if (isset($info[2]))
            $id = $info[2];
        else
            $id = $request_ref->topic_root;
    }
  
    $request_ref->id = $id;
  
    return success();
} // init_id()

function init_open_posts (&$request_ref) {
    global $babel;
  
    if (!($topic = $request_ref->topic))
        return success();
  
    if (!isset($babel['open_posts'][$topic])) {
        $babel['open_posts'][$topic] = array();
    }
    $request_ref->open_posts = $babel['open_posts'][$topic];
    return success();
}

function init_read_posts (&$request_ref) {
    global $babel;
  
    if (!($topic = $request_ref->topic))
        return success();
  
    if (!isset($babel['read_posts'][$topic])) {
        $babel['read_posts'][$topic] = array();
    }
    $request_ref->read_posts = $babel['read_posts'][$topic];
    return success();
}

function init_time (&$request_ref) {
    $request_ref->time = time();
    
    return success();
}

function init_topic (&$request_ref) {
    global $PATH_INFO;
    
    if (!isset($PATH_INFO) || !$PATH_INFO) {
        $topic = '';
    } else {
        if ($PATH_INFO[0] == '/') $PATH_INFO = substr($PATH_INFO, 1, strlen($PATH_INFO)-1);
        $info = explode('/', $PATH_INFO);
        
        if (isset($info[1]))
            $topic = $info[1];
        else
            $topic = '';
    }
    
    $request_ref->topic  = $topic;
    
    return success();
} // init_topic()

function init_topic_conf (&$request_ref) {
    global $conf;
    
    if (!($conf_directory = $conf['paths']['forums']))
        return error("conf_directory not set in conf");
    
    if (!($topic = $request_ref->topic))
        return success();
    
    $topic_conf_filename = "$conf_directory/$topic.conf";
    
    if (!read_conf_file($topic_conf_filename))
        return error("could not read $topic_conf_filename");
    
    return success();
}

function init_topic_root (&$request_ref) {
    global $dbh;
    
    if (!isset($request_ref->topic) || !$request_ref->topic) {
        return success();
    } else {
        $topic = $request_ref->topic;
        
        $query = "SELECT id FROM babel WHERE topic = '$topic' AND parent = 0";
        if (DB::isError($result = $dbh->query($query))) {
            return error($result->toString());
        }
        
        if (DB::isError($row = $result->fetchRow()))
            return run_bootstrap($request_ref);
        
        if ($row == NULL) $row[0] = 1;
        if (!($request_ref->topic_root = $row[0]))
            return error("could not set topic root");
        
        $result->free();
        return success();
    }
}

function init_url (&$request_ref) {
    global $conf;
  
    $conf['url'] = Horde::selfURL();
    
    return success();
}

function init_user_id (&$request_ref) {
    global $auth;
    
    if (!($username = $request_ref->username))
        return error("'username' not specified");
    
    $id = isset($auth) ? $auth->auth['uid'] : 1;
    
    if (!($request_ref->user_id = $id))
        return error("user_id not found in row");
  
    return success();
}

function init_username (&$request_ref) {
    global $auth, $conf;
  
    if (isset($auth) && $auth->auth['uname'] != 'nobody') {
        $username = $auth->auth['uname'];
    } else {
        $username = $conf['anonymous']['login'];
    }
  
    $request_ref->username = $username;
    return success();
}

function init_users_list (&$request_ref) {
    global $conf;
  
    if (!isset($conf['users']) || !($users = split(",[[:alnum:]_]?", $conf['users'])))
        return success();
  
    $request_ref->users = $users;
  
    return success();
}


function abort (&$request_ref, $error_message = '') {
    global $conf;
  
    chop ($date = `date +%m-%d-%y-%H:%M:%S`);
    print_error();
  
    if ($error_message) {
        $var_hash['error_message'] = $error_message;
    } else {
        global $global_error_stack;
        $var_hash['error_message'] = $global_error_stack[0];
    }
  
    $var_hash['body_tags'] = make_body_tags();
    $var_hash['contact'] = $conf['admin']['email'];
  
    print_template('error_template', $var_hash) or
        print_error($request_ref);
  
    exit(0);
}

function build_down_button (&$request_ref, &$button_ref) {
    $id = $request_ref->id;
  
    $siblings = array();
    if (isset($request_ref->post['siblings'])) $siblings = $request_ref->post['siblings'];
  
    if (get_next_in_list($next, $id, $siblings)) {
        $button_ref  = '<a href="';
        $button_ref .= $GLOBALS['conf']['url'];
        $button_ref .= "/$request_ref->link";
        $button_ref .= "/$request_ref->topic";
        $button_ref .= "/$next";
        $button_ref .= '">';
        $button_ref .= $GLOBALS['conf']['buttons']['down'];
        $button_ref .= '</a>';
    } else {
        $button_ref  = $GLOBALS['conf']['buttons']['down_grey'];
    }
  
    return success();
}

function build_global_error_message (&$error_message_ref) {
    global $global_error_stack;
  
    $error_message_ref  = implode("<br>\n", $global_error_stack);
    $error_message_ref .= "\n";
  
    return SUCCESS;
}

function build_help_button (&$request_ref, &$button_ref) {
    if (!isset($request_ref->post['id']))
        $request_ref->post['id'] = '';
    $button_ref  = '<a href="';
    $button_ref .= $GLOBALS['conf']['url'];
    $button_ref .= '/help';
    $button_ref .= "/$request_ref->topic";
    $button_ref .= '/' . $request_ref->post['id'];
    $button_ref .= '">';
    $button_ref .= $GLOBALS['conf']['buttons']['help'];
    $button_ref .= '</a>';
  
    return success();
}

function build_home_button (&$request_ref, &$button_ref) {
    $button_ref  = '<a href="' . $GLOBALS['conf']['url'] . '">';
    $button_ref .= $GLOBALS['conf']['buttons']['home'];
    $button_ref .= '</a>';
  
    return success();
}

function build_left_button (&$request_ref, &$button_ref) {
    if (isset($request_ref->post['parent']) && $request_ref->post['parent']) {
        $button_ref  = '<a href="';
        $button_ref .= $GLOBALS['conf']['url'];
        $button_ref .= "/$request_ref->link";
        $button_ref .= "/$request_ref->topic";
        $button_ref .= '/' . $request_ref->post['parent'];
        $button_ref .= '">';
        $button_ref .= $GLOBALS['conf']['buttons']['left'];
        $button_ref .= '</a>';
    } else {
        $button_ref  = $GLOBALS['conf']['buttons']['left_grey'];
    }
  
    return success();
}

function build_navigation_bar (&$request_ref, &$nav_bar_ref) {
    $request_ref->link = $request_ref->action == 'tree' ? 'tree' : 'show';
    
    if (!(build_home_button($request_ref, $c1)))
        return error("could not build home button");
    
    if (!(build_up_button($request_ref, $c2)))
        return error("could not build up button");
    
    if (!(build_help_button($request_ref, $c3)))
        return error("could not build help button");
  
    if (!(build_left_button($request_ref, $c4)))
        return error("could not build left button");
  
    if (!(build_tree_button($request_ref, $c5)))
        return error("could not build tree button");
  
    if (!(build_right_button($request_ref, $c6)))
        return error("could not build right button");
  
    if (!(build_prev_button($request_ref, $c7)))
        return error("could not build prev button");
  
    if (!(build_down_button($request_ref, $c8)))
        return error("could not build down button");
  
    if (!(build_next_button($request_ref, $c9)))
        return error("could not build next button");
  
    if (!(build_post_button($request_ref, $c10)))
        return error("could not build post button");
  
    $nav_bar_ref  = "$c1$c2$c3<br>\n";
    $nav_bar_ref .= "$c4$c5$c6<br>\n";
    $nav_bar_ref .= "$c7$c8$c9<br>\n";
    $nav_bar_ref .= "$c10<br>\n";
  
    return success();
}

function build_next_button (&$request_ref, &$button_ref) {
    if (get_next($request_ref, $next)) {
        $button_ref  = '<a href="';
        $button_ref .= $GLOBALS['conf']['url'];
        $button_ref .= "/$request_ref->link";
        $button_ref .= "/$request_ref->topic";
        $button_ref .= "/$next";
        $button_ref .= '">';
        $button_ref .= $GLOBALS['conf']['buttons']['next'];
        $button_ref .= '</a>';
    } else {
        $button_ref  = $GLOBALS['conf']['buttons']['next_grey'];
    }
  
    return success();
}

function build_next_unread_button ($request_ref, &$button_ref) {
    if (get_next_unread($request_ref, $request_ref->id, $next_unread)) {
        $button_ref  = '<a href="';
        $button_ref .= $GLOBALS['conf']['url'];
        $button_ref .= "/$request_ref->link";
        $button_ref .= "/$request_ref->topic";
        $button_ref .= "/$next_unread";
        $button_ref .= '">';
        $button_ref .= $GLOBALS['conf']['buttons']['next_unread'];
        $button_ref .= '</a>';
    }
  
    return success();
}

function build_post_button (&$request_ref, &$button_ref) {
    if (!(isset($request_ref->topic) && $request_ref->topic)) {
        $button_ref = '';
        return success();
    }
  
    $button_ref  = '<a href="';
    $button_ref .= $GLOBALS['conf']['url'];
    $button_ref .= '/new';
    $button_ref .= "/$request_ref->topic";
    $button_ref .= "/$request_ref->topic_root";
    $button_ref .= '">';
    $button_ref .= $GLOBALS['conf']['buttons']['addpost'];
    $button_ref .= '</a>';
  
    return success();
}

function build_prev_button (&$request_ref, &$button_ref) {
    if (get_prev($request_ref, $prev)) {
        $button_ref  = '<a href="';
        $button_ref .= $GLOBALS['conf']['url'];
        $button_ref .= "/$request_ref->link";
        $button_ref .= "/$request_ref->topic";
        $button_ref .= "/$prev";
        $button_ref .= '">';
        $button_ref .= $GLOBALS['conf']['buttons']['prev'];
        $button_ref .= '</a>';
    } else {
        $button_ref  = $GLOBALS['conf']['buttons']['prev_grey'];
    }
  
    return success();
}

function build_restore_post_query ($topic, $id, &$query_ref) {
    if (!$topic)
        return error("'topic' undefined");
  
    if (!$id)
        return error("'id' undefined");
  
    $query_ref  = "SELECT ";
    $query_ref .= "id, parent, subject, ";
    $query_ref .= "author_id, created, modified, ";
    $query_ref .= "locked, body ";
    $query_ref .= "FROM babel ";
    $query_ref .= "WHERE topic = '$topic' ";
    $query_ref .= "AND id = '$id' ";
  
    return success();
}

function build_right_button (&$request_ref, &$button_ref) {
    if (isset($request_ref->post['children']) && is_array($request_ref->post['children'])) {
        $button_ref  = '<a href="';
        $button_ref .= $GLOBALS['conf']['url'];
        $button_ref .= "/$request_ref->link";
        $button_ref .= "/$request_ref->topic";
        $button_ref .= '/' . $request_ref->post['children'][0];
        $button_ref .= '">';
        $button_ref .= $GLOBALS['conf']['buttons']['right'];
        $button_ref .= '</a>';
    } else {
        $button_ref  = $GLOBALS['conf']['buttons']['right_grey'];
    }
  
    return success();
}

function build_search_button ($request_ref, &$search_ref) {
    if (!($topic = $request_ref->topic))
        return success();
  
    $search_ref  = '<a href="' . $GLOBALS['conf']['url'] . "/search/$topic\">";
    $search_ref .= $GLOBALS['conf']['buttons']['search'];
    $search_ref .= '</a>';
  
    return success();
}

function build_search_query ($topic, $subject, $author, $created, $limit, $body, &$query_ref) {
    if (!$topic)
        return error("'topic' undefined");
  
    $query_ref  = "SELECT ";
    $query_ref .= "id, parent, subject, ";
    $query_ref .= "author_id, ";
    $query_ref .= "created, modified, locked ";
    $query_ref .= "FROM babel ";
    $query_ref .= "WHERE ";
    $query_ref .= "topic = '$topic' ";
    if ($subject) $query_ref .= "AND subject LIKE '%$subject%' ";
    // FIXME if ($author) $query_ref .= "AND author LIKE '%$author%' ";
    if ($created) $query_ref .= "AND created > " . (time() + $created) . ' ';
    if ($body) $query_ref .= "AND body LIKE '%$body%' ";
    $query_ref .= "ORDER BY 'created' DESC ";
    if ($limit) $query_ref .= " LIMIT $limit ";
  
    return success();
}

function build_status_bar ($request_ref, &$status_ref) {
    $id = $request_ref->id;
  
    if (!($topic = $request_ref->topic))
        $topic = 'all';
  
    if (!(count_posts_in_topic($request_ref, $topic, $total)))
        return error("could not count posts");
  
    if (!(count_unread_in_topic($request_ref, $topic, $unread)))
        return error("could not count unread");
  
    if ($topic != 'all') {
        $status_ref  = "<center><font size=-1>$unread ";
        $status_ref .= '<a href="';
        $status_ref .= $GLOBALS['conf']['url'];
        $status_ref .= '/tree';
        $status_ref .= "/$request_ref->topic";
        if ($id)
            $status_ref .= "/$id";
        $status_ref .= '?unread_only=1';
        $status_ref .= '">unread</a> ';
        $status_ref .= "(of $total)</font></center>";
    } else {
        $status_ref  = "<center><font size=-1>$total ";
        $status_ref .= 'posts in all</font></center>';
    }
  
    return success();
}

function build_tree (&$request_ref, $id, &$tree_ref) {
    global $unread_only, $auth;
  
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!($url = $GLOBALS['conf']['url']))
        return error("could not find 'url' in conf");
  
    if (!(restore_post($request_ref, $id, $topic, $post)))
        return error("could not restore post '$id'");
  
    $children = array();
    if (isset($post['children'])) $children = $post['children'];
  
    $id = $post['id'];
    $subject = $post['subject'];
    $author_id = $post['author_id'];
    $author = 'nobody'; // $auth->auth_getusername($post['author_id']);
    $created = $post['created'];
    $has_children = $children;
    $is_open = folder_is_open($request_ref, $id);
  
    if (!isset($unread_only))
        $unread_only = false;
    if (!($unread_only and is_read($request_ref, $id))) {
        $tree_ref .= '<dd>';
    
        if (!$unread_only && $has_children && $is_open)
            $tree_ref .= make_close_button($request_ref, $id) . ' ';
    
        if (!$unread_only && $has_children && !$is_open)
            $tree_ref .= make_open_button($request_ref, $id) . ' ';
    
        if ($unread_only || !$has_children)
            $tree_ref .= make_bullet_button() . ' ';
    
        if ($id == $request_ref->id)
            $tree_ref .= make_current_button() . ' ';
    
        $tree_ref .= "<a href=\"$url/show/$topic/$id\">";
    
        $tree_ref .= "$subject</a> by ";
    
        $tree_ref .= "<a href=\"$url/profile/$topic/$id?userid=$author_id\">";
    
        $tree_ref .= "<i>$author</i></a> ";
    
        if (is_new($request_ref, $created))
            $tree_ref .= make_new_button();
    
        $tree_ref .= '(' . format_child_count(count($children)) . ')';
    
        if (!(is_read($request_ref, $id)))
            $tree_ref .= make_unread_button();
    
        $tree_ref .= "</dd>\n";
    }
  
    if ($is_open or $unread_only) {
    
        $tree_ref .= "<dl>\n";
    
        if (is_array($children)) {
            while (list($key, $id) = each($children)) {
                if (!(build_tree($request_ref, $id, $tree_ref)))
                    return error("could not build tree for id '$id'");
            }
        }
    
        $tree_ref .= "</dl>\n";
    }
  
    return success();
}

function build_tree_button (&$request_ref, &$button_ref) {
    if ($request_ref->topic) {
        $button_ref  = '<a href="';
        $button_ref .= $GLOBALS['conf']['url'];
        if ($request_ref->link == 'tree') {
            $button_ref .= '/show';
        } else {
            $button_ref .= '/tree';
        }
        $button_ref .= "/$request_ref->topic";
        if (is_int($request_ref->post['id']))
            $button_ref .= '/' . $request_ref->post['id'];
        if ($request_ref->link == 'tree') {
            $button_ref .= '">';
            $button_ref .= $GLOBALS['conf']['buttons']['show'];
            $button_ref .= '</a>';
        } else {
            $button_ref .= '">';
            $button_ref .= $GLOBALS['conf']['buttons']['tree'];
            $button_ref .= '</a>';
        }
    } else {
        $button_ref = $GLOBALS['conf']['buttons']['tree_grey'];
    }
  
    return success();
}

function build_up_button (&$request_ref, &$button_ref) {
    $id = $request_ref->id;
  
    $siblings = array();
    if (isset($request_ref->post['siblings']))
        $siblings = $request_ref->post['siblings'];
  
    if (get_prev_in_list($prev, $id, $siblings)) {
        $button_ref  = '<a href="';
        $button_ref .= $GLOBALS['conf']['url'];
        $button_ref .= "/$request_ref->link";
        $button_ref .= "/$request_ref->topic";
        $button_ref .= "/$prev";
        $button_ref .= '">';
        $button_ref .= $GLOBALS['conf']['buttons']['up'];
        $button_ref .= '</a>';
    } else {
        $button_ref  = $GLOBALS['conf']['buttons']['up_grey'];
    }
  
    return success();
}

function can_edit (&$request_ref) {
    global $conf;
  
    if (!($author_id = $request_ref->post['author_id']))
        return error("'author_id' not found in post");
  
    if (!($user_id = $request_ref->user_id))
        return error("'user_id' not found in request");
  
    if (!($username = $request_ref->username))
        return error("'username' not found in request");
  
    if (!($administrator = $conf['admin']['user']))
        return error("'administrator' not found in conf");
  
    if (!($editors = $request_ref->editors))
        return error("editors not found in conf");
  
    if (!($anonymous = $conf['anonymous']['login']))
        return error("'anonymous_login' not found in conf");
  
    if ($username == $anonymous) {
        if (!$conf['anonymous']['can_edit'])
            return FAILURE;
        elseif ($author_id == $anonymous)
            return success();
    }
    if ($user_id == $administrator) return success();
    if ($user_id == $author_id)     return success();
    if (member($user_id, $editors)) return success();
  
    return FAILURE;
}

function can_erase (&$request_ref) {
    global $conf;
  
    if (!($author_id = $request_ref->post['author_id']))
        return error("'author_id' not found in post");
  
    if (!($user_id = $request_ref->user_id))
        return error("'user_id' not found in request");
  
    if (!($administrator = $conf['admin']['user']))
        return error("'administrator' not found in conf");
  
    if (!($editors = $request_ref->editors))
        return error("editors not found in conf");
  
    if (!($anonymous = $conf['anonymous']['login']))
        return error("'anonymous_login' not found in conf");
  
    if ($user_id == $administrator)     return success();
    if ($request_ref->post['children']) return FAILURE;
    if ($user_id == $anonymous)         return FAILURE;
    if ($user_id == $author_id)         return success();
    if (member($user_id, $editors))     return success();
    return FAILURE;
}

function can_lock (&$request_ref) {
    global $conf;
  
    if (!($username = $request_ref->username))
        return error("'username' not found in request");
  
    if (!($administrator = $conf['admin']['user']))
        return error("'administrator' not found in conf");
  
    if (!($editors = $request_ref->editors))
        return error("editors not found in conf");
  
    if ($username == $administrator)
        return success();
    if (member($username, $editors))
        return success();
  
    return FAILURE;
}

function can_read (&$request_ref) {
    global $conf;
  
    if (!($request_ref->topic))
        return success();
  
    if (!($username = $request_ref->username))
        return error("'username' not found in request");
  
    if (!($administrator = $conf['admin']['user']))
        return error("'administrator' not found in conf");
  
    if (!($editors = $request_ref->editors))
        return error("editors not found in conf");
  
    if (!($users = $request_ref->users))
        return error("users not found in conf");
  
    if (!($anonymous = $conf['anonymous']['login']))
        return error("'anonymous_login' not found in conf");
  
    if (($username == $anonymous) && !$conf['anonymous']['can_read'])
        return FAILURE;
  
    if (preg_match("/^.*$/", implode("\n", $users))) return success();
    if ($username == $administrator)         return success();
    if (member($username, $editors))         return success();
    if (member($username, $users))           return success();
  
    return FAILURE;
}

function can_reply (&$request_ref) {
    global $conf;
  
    if (!($username = $request_ref->username))
        return error("'username' not found in request");
  
    if (!($administrator = $conf['admin']['user']))
        return error("'administrator' not found in conf");
  
    if (!($editors = $request_ref->editors))
        return error("editors not found in conf");
  
    $locked = $request_ref->post['locked'];
  
    if (!($anonymous = $conf['anonymous']['login']))
        return error("'anonymous_login' not found in conf");
  
    if (($username == $anonymous) && !$conf['anonymous']['can_reply'])
        return FAILURE;
    if (!$locked)                    return success();
    if ($username == $administrator) return success();
    if (member($username, $editors)) return success();
  
    return FAILURE;
}

function close_all (&$request_ref) {
    global $babel;
  
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    $babel['open_posts'][$topic] = array();
    $request_ref->open_posts = array();
    $request_ref->id = $request_ref->topic_root;
  
    return success();
}

function count_posts_in_topic ($request_ref, $topic, &$total_ref) {
    global $dbh;
  
    if ($topic == '') $topic = 'all';
  
    if (isset($request_ref->total_posts[$topic])) {
        $total_ref = $request_ref->total_posts[$topic];
        return success();
    }
  
    if ($topic != 'all') {
        $query  = "SELECT count(id) FROM babel WHERE topic = '$topic'";
    } else {
        $query  = "SELECT count(id) FROM babel";
    }
    
    if (DB::isError($result = $dbh->query($query)))
        return error($result->toString());
    
    if (DB::isError($row = $result->fetchRow())) {
        return error($row->toString());
    }
    
    $total_ref = $row[0];
    $result->free();
    $request_ref->total_posts[$topic] = $total_ref;
    
    return success();
}

function count_unread_in_topic ($request_ref, $topic, &$unread_ref) {
    if (!$topic) $topic = 'all';
  
    if (!(count_posts_in_topic($request_ref, $topic, $total)))
        return error("could not count posts in topic '$topic'");
  
    if (isset($request_ref->unread_posts)) {
        $unread_ref = $request_ref->unread_posts;
        return success();
    }
  
    $unread_ref = $total - count($request_ref->read_posts);
  
    $request_ref->unread_posts = $unread_ref;
  
    return success();
}

function erase_post (&$request_ref) {
    global $babel, $dbh;
  
    $id = $request_ref->id;
  
    if ($id == 1)
        return error("can not delete post 1");
  
    if (!$request_ref->post['parent'])
        return error("parent not found");
  
    if (!(can_erase($request_ref)))
        return error("can not erase post");
  
    if (!($topic = $request_ref->topic))
        return error("'topic' undefined in request");
  
    $parent = $request_ref->post['parent'];
  
    $query  = "DELETE FROM babel WHERE id = $id";
    if (!$dbh->query($query))
        return error("could not run query: $query : " . $dbh->Error);
  
    $query  = "UPDATE posts SET parent = $parent WHERE parent = $id";
    if (!$dbh->query($query))
        return error("could not run query: $query : " . $dbh->Error);
  
    $dbh->free();
  
    unset($babel['read_posts'][$topic][$id]);
    unset($babel['open_posts'][$topic][$id]);
    unset($request_ref->read_posts[$id]);
    unset($request_ref->open_posts[$id]);
  
    return success();
}

function error ($messages) {
    global $global_error_stack;
    if (is_array($messages))
        while (list($key, $val) = each($messages)) {
            $global_error_stack[] = "ERROR: $val";
        }
    else
        $global_error_stack[] = "ERROR: $messages";
  
    return FAILURE;
}

function execute_module (&$request_ref) {
    if (!($action = $request_ref->action))
        return error("action not set in request");
  
    $module = 'run_' . $action;
    if (!function_exists($module))
        return error("module '$module' not present");
  
    if (!$module($request_ref))
        return error("could not run module '$module'");
  
    return success();
}

function export_state (&$request_ref, &$hash_ref) {
    global $conf;
  
    if (isset($request_ref->post['subject']))
        $hash_ref['subject'] = $request_ref->post['subject'];
    else
        $hash_ref['subject'] = '';
  
    if (isset($request_ref->post['author_id']))
        $hash_ref['author_id'] = $request_ref->post['author_id'];
    else
        $hash_ref['author_id'] = '';
  
    // global $auth;
    $hash_ref['author'] = 'nobody'; // $auth->auth_getusername($hash_ref['author_id']);
  
    if (isset($request_ref->post['created']))
        $hash_ref['created'] = date('D M dS h:ia Y', $request_ref->post['created']);
    else
        $hash_ref['created'] = '';
  
    if (isset($request_ref->post['modified']))
        $hash_ref['modified'] = date('D M dS h:ia Y', $request_ref->post['modified']);
    else
        $hash_ref['modified'] = '';
  
    if (isset($request_ref->post['body']))
        $hash_ref['body'] = $request_ref->post['body'];
    else
        $hash_ref['body'] = '';
  
    $hash_ref['url'] = $conf['url'];
    $hash_ref['topic'] = $request_ref->topic;
    $hash_ref['id'] = $request_ref->id;
  
    return success();
}

function find_rightmost_descendent (&$request_ref, $id, &$prev_ref) {
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    $rightmost = $id;
  
    $done = false;
    while (!$done) {
        $child_ids = array();
    
        $prev_ref = $rightmost;
    
        if (!(restore_child_ids($request_ref, $rightmost, $topic, $child_ids)))
            return error("could not restore children of id '$rightmost'");
    
        if (!$child_ids)
            $done = true;
    
        $rightmost = pop($child_ids);
    }
  
    return success();
}

function folder_is_open (&$request_ref, $id) {
    if (isset($request_ref->open_posts[$id]) && $request_ref->open_posts[$id])
        return success();
    return FAILURE;
}

function format_child_count ($count) {
    if ($count == 0)
        return 'no replies';
    if ($count == 1)
        return '1 reply';
    return "$count replies";
}

function get_next (&$request_ref, &$next_ref) {
    if (!($id = $request_ref->id))
        return error("id undefined");
  
    $children = array();
    $siblings = array();
  
    if (isset($request_ref->post['children']))
        $children = $request_ref->post['children'];
  
    if (isset($request_ref->post['siblings']))
        $siblings = $request_ref->post['siblings'];
  
    $parent = $request_ref->post['parent'];
  
    if ($children) {
        $next_ref = $children[0];
    } else if (get_next_in_list($next, $id, $siblings)) {
        $next_ref = $next;
    } else if (get_next_upwards($request_ref, $parent, $next)) {
        $next_ref = $next;
    } else {
        return FAILURE;
    }
  
    return success();
}

function get_next_in_list (&$next_ref, $element, $list) {
    $i = 0;
  
    while (isset($list[$i+1]) && $next_ref = $list[$i+1]) {
        if ($list[$i] == $element)
            return success();
        $i++;
    }
  
    return FAILURE;
}

function get_next_unread (&$request_ref, $id, &$next_ref) {
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!(count_unread_in_topic($request_ref, $topic, $unread)))
        return error("could not could unread in '$topic'");
  
    if (!$unread)
        return FAILURE;
  
    if (!$id)
        return error("couldn't get next unread");
  
    if (!(restore_post($request_ref, $id, $request_ref->topic, $post)))
        return error("could not restore post '$id'");
  
    $children = $post['children'];
  
    $siblings = isset($post['siblings']) ? $post['siblings'] : '';
  
    $parent = $post['parent'];
  
    if ($children) {
        $next_ref = $children[0];
    } else if (get_next_in_list($next, $id, $siblings)) {
        $next_ref = $next;
    } else if (get_next_upwards($request_ref, $parent, $next)) {
        $next_ref = $next;
    } else {
        return FAILURE;
    }
  
    if (is_read($request_ref, $next_ref)) {
        if (!isset($$next_ref))
            $$next_ref = '';
        return get_next_unread($request_ref, $$next_ref, $next_ref);
    }
  
    return success();
}

function get_next_upwards (&$request_ref, $id, &$next_ref) {
    if (!$id) return FAILURE;
  
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!(restore_post($request_ref, $id, $topic, $post)))
        return error("could not restore post '$id'");
  
    if (!$post['parent'])
        return FAILURE;
  
    if (!(restore_post($request_ref, $post['parent'], $topic, $parent)))
        return error("could not restore post '$post[parent]'");
  
    if (get_next_in_list($next_ref, $id, $parent['children']))
        return success();
  
    if (!(get_next_upwards($request_ref, $post['parent'], $next_ref)))
        return FAILURE;
  
    return success();
}

function get_prev (&$request_ref, &$prev_ref) {
    if (!($id = $request_ref->id))
        return error("id undefined");
  
    $siblings = array();
    if (isset($request_ref->post['siblings']))
        $siblings = $request_ref->post['siblings'];
  
    $parent = $request_ref->post['parent'];
  
    if (get_prev_in_list($prev, $id, $siblings)) {
        if (!(find_rightmost_descendent($request_ref, $prev, $prev_ref)))
            return error("could not find rightmost descendent of '$prev'");
    } else if ($parent) {
        $prev_ref = $parent;
    } else {
        return FAILURE;
    }
  
    return success();
}

function get_prev_in_list (&$prev_ref, $element, $list) {
    if (isset($list))
        $list = reverse($list);
  
    $i = 0;
  
    while (isset($list[$i+1]) && $prev_ref = $list[$i+1]) {
        if ($list[$i] == $element)
            return success();
        $i++;
    }
  
    return FAILURE;
}

function handleRequest (&$request_ref) {
    if (!(init_time($request_ref)))
        return error("could not init time");
    
    if (!(init_username($request_ref)))
        return error("could not init username");
  
    if (!(init_user_id($request_ref)))
        return error("could not init user id");
  
    if (!(init_action($request_ref)))
        return error("could not init action");
  
    if (!(init_topic($request_ref)))
        return error("could not init topic");
  
    if (!(init_topic_root($request_ref)))
        return error("could not init topic root");
  
    if (!(init_id($request_ref)))
        return error("could not init id");
  
    if (!(init_topic_conf($request_ref)))
        return error("could not init topic conf");
  
    if (!(init_editors_list($request_ref)))
        return error("could not init editors list");
  
    if (!(init_users_list($request_ref)))
        return error("could not init users list");
  
    if (!(init_url($request_ref)))
        return error("could not init url");
  
    if (!(init_read_posts($request_ref)))
        return error("could not init read posts");
  
    if (!(init_open_posts($request_ref)))
        return error("could not init open posts");
  
    if (!(can_read($request_ref)))
        return error("username '$request_ref->username' not allowed");
    
    if (!(run_command($request_ref)))
        return error("could not run command");
  
    if (!(execute_module($request_ref)))
        return error("could not execute");
  
    return success();
}

function is_anonymous (&$request_ref) {
    global $conf;
  
    $username = $request_ref->username;
    $anonymous_login = $conf['anonymous']['login'];
  
    if ($username == $anonymous_login)
        return success();
  
    return FAILURE;
}

function is_new (&$request_ref, $modified) {
    global $conf;
  
    if (!($time = $request_ref->time))
        $time = time();
  
    if (!($timeout = $conf['messages']['new_timeout']))
        $timeout = 86400;
  
    if ($time < ($modified + $timeout))
        return success();
    return FAILURE;
}

function is_read (&$request_ref, $id) {
    if (isset($request_ref->read_posts[$id]) && $request_ref->read_posts[$id])
        return success();
    return FAILURE;
}

function make_back_button (&$request_ref) {
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!($id = $request_ref->id))
        return error("id undefined");
  
    $but  = '<a href="' . $GLOBALS['conf']['url'] . "/show/$topic/$id\">";
    $but .= $GLOBALS['conf']['buttons']['back'];
    $but .= '</a>';
  
    return $but;
}

function make_back_link (&$request_ref) {
    global $conf;
  
    if (!($url = $conf['url']))
        return error("url not set in conf");
  
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!($id = $request_ref->id))
        return error("id undefined");
  
    $link  = "<a href=\"$url/show/$topic/$id\">";
    $link .= 'return to the previous page';
    $link .= '</a>';
  
    return $link;
}

function make_body_tags () {
    return $GLOBALS['conf']['buttons']['body_tags'];
}

function make_bullet_button () {
    return $GLOBALS['conf']['buttons']['bullet'];
}

function make_close_all_button (&$request_ref) {
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!($id = $request_ref->id))
        return error("id undefined");
  
    $but  = '<a href="' . $GLOBALS['conf']['url'] . "/tree/$topic/$id?cmd=close_all\">";
    $but .= $GLOBALS['conf']['buttons']['close_all'];
    $but .= '</a>';
  
    return $but;
}

function make_close_button (&$request_ref, $id) {
    if (!($current = $request_ref->id))
        return error("no current post");

    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    $but  = '<a href="' . $GLOBALS['conf']['url'] . "/tree/$topic/$current?cmd=close&arg=$id\">";
    $but .= $GLOBALS['conf']['buttons']['close'];
    $but .= '</a>';
  
    return $but;
}

function make_current_button () {
    return $GLOBALS['conf']['buttons']['current'];
}

function make_edit_button (&$request_ref) {
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!($id = $request_ref->id))
        return error("id undefined");
  
    $but  = '<a href="' . $GLOBALS['conf']['url'] . "/edit/$topic/$id\">";
    $but .= $GLOBALS['conf']['buttons']['edit'];
    $but .= '</a>';
  
    return $but;
}

function make_erase_button (&$request_ref) {
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!($id = $request_ref->id))
        return error("id undefined");
  
    $but  = '<a href="' . $GLOBALS['conf']['url'] . "/erase/$topic/$id\">";
    $but .= $GLOBALS['conf']['buttons']['erase'];
    $but .= '</a>';
  
    return $but;
}

function make_is_locked_button (&$request_ref) {
    if ($request_ref->post['locked'])
        return 'locked';
    else
        return 'unlocked';
}

function make_lock_button (&$request_ref) {
    $but = 'Locked: ';
  
    if ($request_ref->post['locked']) {
        $but .= '<input type="radio" name="locked" value="1" checked> yes ';
        $but .= '<input type="radio" name="locked" value="0"> no' . "\n";
    } else {
        $but .= '<input type="radio" name="locked" value="1"> yes ';
        $but .= '<input type="radio" name="locked" value="0" checked> no' . "\n";
    }
  
    $but .= "<br>\n";

    return $but;
}

function make_new_button () {
    return $GLOBALS['conf']['buttons']['new'];
}

function make_open_all_button (&$request_ref) {
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!($id = $request_ref->id))
        return error("id undefined");
  
    $but  = '<a href="' . $GLOBALS['conf']['url'] . "/tree/$topic/$id?cmd=open_all\">";
    $but .= $GLOBALS['conf']['buttons']['open_all'];
    $but .= '</a>';
  
    return $but;
}

function make_open_button (&$request_ref, $id) {
    if (!($current = $request_ref->id))
        return error("no current post");
  
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    $but  = '<a href="' . $GLOBALS['conf']['url'] . "/tree/$topic/$current?cmd=open&arg=$id\">";
    $but .= $GLOBALS['conf']['buttons']['open'];
    $but .= '</a>';
  
    return $but;
}

function make_quote_button (&$request_ref) {
    global $quote;
  
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!($url = $GLOBALS['conf']['url']))
        return error("could not find 'url' in conf");
  
    if (!($id = $request_ref->id))
        return error("id undefined");
  
    if ($quote) {
        $but  = "<a href=\"$url/new/$topic/$id\">";
        $but .= $GLOBALS['conf']['buttons']['do_not_quote'];
        $but .= "</a>\n";
    } else {
        $but  = "<a href=\"$url/new/$topic/$id?quote=1\">";
        $but .= $GLOBALS['conf']['buttons']['quote'];
        $but .= "</a>\n";
    }
  
    return $but;
}

function make_reply_button (&$request_ref) {
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!($id = $request_ref->id))
        return error("id undefined");
  
    $but  = '<a href="' . $GLOBALS['conf']['url'] . "/new/$topic/$id\">";
    $but .= $GLOBALS['conf']['buttons']['reply'];
    $but .= '</a>';
  
    return $but;
}

function make_reply_subject ($subject) {
    $subject = preg_replace("/^\\s*re:\\s*/i", '', $subject);
    $subject = "Re: $subject";
    
    return $subject;
}

function make_search_button (&$request_ref) {
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
    
    $but  = '<a href="' . $GLOBALS['conf']['url'] . "/search/$topic\">";
    $but .= $GLOBALS['conf']['buttons']['search'];
    $but .= '</a>';
    
    return $but;
}

function make_submit_button () {
    return $GLOBALS['conf']['buttons']['submit'];
}

function make_unread_button () {
    return $GLOBALS['conf']['buttons']['unread'];
}

function mark_as_closed (&$request_ref, $post_id) {
    global $babel;
  
    if (!$post_id)
        return error("'post_id' not set");
  
    if (!(folder_is_open($request_ref, $post_id)))
        return success();
  
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    unset($babel['open_posts'][$topic][$post_id]);
    unset($request_ref->open_posts[$post_id]);
  
    return success();
}

function mark_as_open (&$request_ref, $post_id) {
    global $babel;
  
    if (!$post_id)
        return success();
  
    if (folder_is_open($request_ref, $post_id))
        return success();
  
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    $babel['open_posts'][$topic][$post_id] = 1;
    $request_ref->open_posts[$post_id] = 1;
  
    return success();
}

function mark_as_read (&$request_ref) {
    global $babel;
  
    if (!($post_id = $request_ref->id))
        return FAILURE;
  
    if (is_read($request_ref, $post_id))
        return success();
  
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    $babel['read_posts'][$topic][$post_id] = 1;
    $request_ref->read_posts[$post_id] = 1;
  
    return success();
}

function open_all (&$request_ref) {
    global $dbh;

    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!($user_id = $request_ref->user_id))
        return error("'user_id' not specified");
  
    $query  = "SELECT id FROM babel ";
    $query .= "WHERE topic = '$topic'";
  
    if (DB::isError($result = $dbh->query($query)))
        return error($result->toString());
    
    while ($row = $result->fetchRow()) {
        if (!(mark_as_open($request_ref, $row[0])))
            return error("could not mark '$row[0]' as open");
    }
    
    $result->free();
    return success();
}

function perform_search (&$request_ref) {
    global $subject, $author, $created, $limit, $body, $hide_read, $auth, $conf;
    if (!isset($subject))   $subject = '';
    if (!isset($author))    $author = '';
    if (!isset($created))   $created = '';
    if (!isset($limit))     $limit = 0;
    if (!isset($body))      $body = 0;
    if (!isset($hide_read)) $hide_read = false;
  
    if (!($dbh = $request_ref->dbh))
        return error("database undefined");
  
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!($url = $conf['url']))
        return error("url not set in conf");
  
    if (!(build_search_query($topic, $subject, $author, $created, $limit, $body, $query)))
        return error("could not build search query");
  
    if (!(restore_multiple_posts($request_ref, $query, $topic, $results)))
        return error("could not restore posts with query: $query");
  
    $var_hash['results'] = '';
    reset($results);
    while (list(,$val) = each($results)) {
        if (!($hide_read && is_read($request_ref, $val['id']))) {
            $var_hash['results'] .= "<a href=\"$url/show/$topic/" . $val['id'] . '">';
            $var_hash['results'] .= $val['subject'] . '</a> '; 
            $var_hash['results'] .= 'by ' . $auth->auth_getusername($val['author_id']) . ' ';
            $var_hash['results'] .= ' on ' . date('D M dS h:ia Y', $val['created']);
            $var_hash['results'] .= ' (';
            $var_hash['results'] .= format_child_count(count($val['children']));
            $var_hash['results'] .= ")<br>\n";
        }
    }
  
    if (!$results)
        $var_hash['results'] = "No matching posts";
  
    $var_hash['url'] = $conf['url'];
    $var_hash['topic'] = $request_ref->topic;
    $var_hash['id'] = $request_ref->id;
  
    if (!(restore_state($request_ref)))
        return error("could not restore state");
  
    if (!(build_navigation_bar($request_ref, $var_hash['nav_bar'])))
        return error("could not build navigation bar");
  
    if (!(build_status_bar($request_ref, $var_hash['status'])))
        return error("could not build status bar");
  
    if (!(build_search_button($request_ref, $var_hash['search'])))
        return error("could not build search button");
  
    $var_hash['body_tags'] = make_body_tags();
  
    if (!(print_template('results', $var_hash)))
        return error("could not print results template");
  
    return success();
}

function print_edit_post_form (&$request_ref) {
    if (!(restore_state($request_ref)))
        return error("could not restore state");
  
    if (!(can_edit($request_ref)))
        return error("can not edit post id '$request_ref->id'");
  
    $request_ref->post['body'] = htmlspecialchars($request_ref->post['body']);
    
    if (can_erase($request_ref))
        $var_hash['erase'] = make_erase_button($request_ref);
    else
        $var_hash['erase'] = '';
  
    $var_hash['submit'] = make_submit_button();
  
    $var_hash['back'] = make_back_button($request_ref);
  
    $var_hash['body_tags'] = make_body_tags();
  
    if (can_lock($request_ref))
        $var_hash['locked'] = make_lock_button($request_ref);
  
    if (!(build_navigation_bar($request_ref, $var_hash['nav_bar'])))
        return error("could not build navigation bar");
  
    if (!(build_status_bar($request_ref, $var_hash['status'])))
        return error("could not build status bar");
  
    if (!(build_search_button($request_ref, $var_hash['search'])))
        return error("could not build search button");
  
    if (!(export_state($request_ref, $var_hash)))
        return error("could not export state");
  
    if (!(print_template('edit', $var_hash)))
        return error("could not print edit template");
  
    return success();
}

function print_error () {
    build_global_error_message($error_message);
    echo $error_message;
    exit;
}

function print_new_post_form (&$request_ref) {
    global $quote;
    if (!isset($quote))
        $quote = false;
  
    if (!(restore_state($request_ref)))
        return error("could not restore state");
  
    if (!(can_reply($request_ref)))
        return error("can not reply to post id '$id'");
  
    $request_ref->post['body'] = htmlspecialchars($request_ref->post['body']);
  
    $request_ref->post['body'] = $quote ? quote($request_ref->post['body']) : '';
  
    $request_ref->post['subject'] = make_reply_subject($request_ref->post['subject']);
  
    $var_hash['quote'] = make_quote_button($request_ref);
  
    $var_hash['submit'] = make_submit_button();
  
    $var_hash['back'] = make_back_button($request_ref);
  
    if (can_lock($request_ref))
        $var_hash['locked'] = make_lock_button($request_ref);
  
    $var_hash['body_tags'] = make_body_tags();
  
    if (!(build_navigation_bar($request_ref, $var_hash['nav_bar'])))
        return error("could not build navigation bar");
  
    if (!(build_status_bar($request_ref, $var_hash['status'])))
        return error("could not build status bar");
  
    if (!(build_search_button($request_ref, $var_hash['search'])))
        return error("could not build search button");
  
    if (!(export_state($request_ref, $var_hash)))
        return error("could not export state");
  
    if (!(print_template('new', $var_hash)))
        return error("could not print new template");
  
    return success();
}

function print_search_form (&$request_ref) {
    global $conf;
  
    $var_hash['url'] = $conf['url'];
    $var_hash['topic'] = $request_ref->topic;
    $var_hash['id'] = $request_ref->id;
  
    if (!(restore_state($request_ref)))
        return error("could not restore state");
  
    if (!(build_navigation_bar($request_ref, $var_hash['nav_bar'])))
        return error("could not build navigation bar");
  
    if (!(build_status_bar($request_ref, $var_hash['status'])))
        return error("could not build status bar");
  
    if (!(build_search_button($request_ref, $var_hash['search'])))
        return error("could not build search button");
  
    $var_hash['body_tags'] = make_body_tags();
  
    if (!(print_template('search', $var_hash)))
        return error("could not print search template");
  
    return success();
}

function print_template ($template, $hash_ref) {
    global $conf;
  
    if (!($data = implode('', file($conf['paths']['templates'] . '/' . $conf['templates'][$template]))))
        return error("could not open '$filename': $!");
  
    reset($hash_ref);
    while (list($key, $val) = each($hash_ref)) {
        $data = str_replace("\$$key", $val, $data);
    }
  
    echo $data;
  
    return success();
}

function quote ($string) {
    $string = "> $string";
    $string = str_replace("\n", "\n> ", $string);
  
    return $string;
}

function read_conf_file ($filename) {
    global $conf;
  
    if (!$filename)
        return error("filename undefined"); 
  
    if (!file_exists($filename))
        return error("could not open file '$filename' for reading");
  
    include $filename;
  
    return success();
}

function restore_child_ids (&$request_ref, $id, $topic, &$child_ids_ref) {
    global $dbh;
    
    if (isset($request_ref->child_ids[$id])) {
        $child_ids_ref = $request_ref->child_ids[$id];
        return success();
    }
    if (!isset($id))
        return success();
    
    $query  = "SELECT id FROM babel ";
    $query .= "WHERE topic = '$topic' AND parent = $id ";
    $query .= "ORDER BY id";
  
    if (DB::isError($result = $dbh->query($query)))
        return error($result->toString());
    
    while ($row = $result->fetchRow()) {
        $child_ids_ref[] = $row[0];
    }
    
    $result->free();
  
    if (isset($child_ids_ref) && $child_ids_ref)
        $request_ref->child_ids[$id] = $child_ids_ref;
  
    return success();
}

function restore_multiple_posts (&$request_ref, $query, $topic, &$posts_arr_ref) {
    global $dbh;
    
    if (!$dbh->query($query))
        return error("could not run query: $query : " . $dbh->Error);
    
    $posts_arr_ref = array();
    while ($dbh->next_record()) {
        $post = array();
        $children = array();
        
        $post['id'] = $dbh->f('id');
        $post['parent'] = $dbh->f('parent');
        $post['subject'] = $dbh->f('subject');
        $post['author_id'] = $dbh->f('author_id');
        $post['created'] = $dbh->f('created');
        $post['modified'] = $dbh->f('modified');
        $post['locked'] = $dbh->f('locked');
        
        $posts_arr_ref[] = $post;
    }
    $dbh->free();
    
    while (list($key,) = each($posts_arr_ref)) {
        if (!(restore_child_ids($request_ref, $posts_arr_ref[$key]['id'], $topic, $children)))
            return error("could not restore child ids for '$posts_arr_ref[$key]['id']'");
        $posts_arr_ref[$key]['children'] = $children;
    }
  
    return success();
}

function restore_post (&$request_ref, $id, $topic, &$post_ref) {
    global $dbh;
  
    if (isset($request_ref->posts[$id])) {
        $post_ref = $request_ref->posts[$id];
        return success();
    }
  
    if (!(build_restore_post_query($topic, $id, $query)))
        return error("could not build query");
  
    if (DB::isError($result = $dbh->query($query)))
        return error($result->toString());
    
    if (DB::isError($row = $result->fetchRow(DB_GETMODE_ASSOC)))
        return error($row->toString());
    
    $post_ref['id'] = $row['id'];
    $post_ref['parent'] = $row['parent'];
    $post_ref['subject'] = $row['subject'];
    $post_ref['author_id'] = $row['author_id'];
    $post_ref['created'] = $row['created'];
    $post_ref['modified'] = $row['modified'];
    $post_ref['locked'] = $row['locked'];
    $post_ref['body'] = $row['body'];
    
    $result->free();
    
    if (!(restore_child_ids($request_ref, $id, $topic, $children)))
        return error("could not restore child ids for '$id'");
    
    if (isset($children) && $children)
        $post_ref['children'] = $children;
    else
        $post_ref['children'] = '';
    
    $parent_id = $post_ref['parent'];
    
    if (!(restore_child_ids($request_ref, $parent_id, $topic, $siblings)))
        return error("could not restore child_ids for '$parent_id'");
    
    if (isset($siblings))
        $post_ref['siblings'] = $siblings;
    
    $request_ref->posts[$id] = $post_ref;
    
    return success();
}

function restore_state (&$request_ref) {
    if (!($id = $request_ref->id))
        return error("id undefined");
  
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    if (!(restore_post($request_ref, $id, $topic, $request_ref->post)))
        return error("could not restore post '$id'");
  
    return success();
}

function run_about (&$request_ref) {
    global $conf;
  
    $var_hash = $conf['buttons'];
    $var_hash['url'] = $conf['url'];
    $var_hash['topic'] = $request_ref->topic;
    $var_hash['id'] = $request_ref->id;
  
    if ($request_ref->topic) {
        if (!(restore_state($request_ref)))
            return error("could not restore state");
    }
  
    if (!(build_navigation_bar($request_ref, $var_hash['nav_bar'])))
        return error("could not build navigation bar");
  
    if (!(build_status_bar($request_ref, $var_hash['status'])))
        return error("could not build status bar");
  
    if (!(build_search_button($request_ref, $var_hash['search'])))
        return error("could not build search button");
  
    $var_hash['body_tags'] = make_body_tags();

    if (!(print_template('about', $var_hash)))
        return error("could not print about template");
  
    return success();
}

function run_bootstrap (&$request_ref) {
    global $conf;
  
    if (!($username = $request_ref->username))
        return error("'username' not specified");
  
    if (!($administrator = $conf['admin']['user']))
        return error("'administrator' not specified");
  
    $post['parent'] = 0;
    $post['author'] = $conf['admin']['user'];
    $post['subject'] = "subject";
    $post['created'] = $request_ref->time;
    $post['modified'] = $request_ref->time;
    $post['locked'] = 1;
    $post['body'] = "body";
  
    if (!(store_post($request_ref, $post)))
        return error("could not store post");
  
    $request_ref->topic_root = $post['id'];
  
    return success();
}

function run_command (&$request_ref) {
    global $cmd, $arg;
  
    if (!isset($cmd) || !$cmd)
        return success();
  
    if ($cmd == 'open') {
        if (!(mark_as_open($request_ref, $arg)))
            return error("could not mark '$arg' as open");
    } else if ($cmd == 'close') {
        if (!(mark_as_closed($request_ref, $arg)))
            return error("could not mark '$arg' as closed");
    } else if ($cmd == 'open_all') {
        if (!(open_all($request_ref)))
            return error("could not open all");
    } else if ($cmd == 'close_all') {
        if (!(close_all($request_ref)))
            return error("could not close all");
    }
  
    return success();
}

function run_edit (&$request_ref) {
    global $subject;
  
    if (isset($subject) && $subject) {
        if (!(save_edited_post($request_ref)))
            return error("could not save edited post");
    
    } else {
        if (!(print_edit_post_form($request_ref)))
            return error("could not print edit post form");
    }
  
    return success();
}

function run_erase (&$request_ref) {
    if (!(restore_state($request_ref)))
        return error("could not restore state");
  
    if (!(can_erase($request_ref)))
        return error("can not erase post id '$request_ref->id'");
  
    $id = $request_ref->id;
  
    if (!(erase_post($request_ref)))
        return error("could not erase post");
  
    $request_ref->id = $request_ref->post['parent'];
    
    if (!(run_show($request_ref)))
        return error("could not run show");
  
    return success();
}

function run_help (&$request_ref) {
    global $conf;
  
    $var_hash = $conf['buttons'];
    $var_hash['url'] = $conf['url'];
    $var_hash['topic'] = $request_ref->topic;
    $var_hash['id'] = $request_ref->id;
  
    if ($request_ref->topic) {
        if (!(restore_state($request_ref)))
            return error("could not restore state");
    }
  
    if (!(build_navigation_bar($request_ref, $var_hash['nav_bar'])))
        return error("could not build navigation bar");
  
    if (!(build_status_bar($request_ref, $var_hash['status'])))
        return error("could not build status bar");
  
    $var_hash['body_tags'] = make_body_tags();
    $var_hash['back'] = make_back_link($request_ref);
  
    if (!(print_template('help', $var_hash)))
        return error("could not print help template");
  
    return success();
}

function run_intro (&$request_ref) {
    global $conf;
  
    $var_hash['url'] = $conf['url'];
    $var_hash['topic'] = $request_ref->topic;
    $var_hash['id'] = $request_ref->id;
    $var_hash['username'] = $request_ref->username;
  
    if (!(build_navigation_bar($request_ref, $var_hash['nav_bar'])))
        return error("could not build navigation bar");
  
    if (!(build_status_bar($request_ref, $var_hash['status'])))
        return error("could not build status bar");
  
    $var_hash['body_tags'] = make_body_tags();
    $var_hash['search'] = '';
  
    if (is_anonymous($request_ref)) {
        if (!(print_template('anon', $var_hash)))
            return error("could not print template 'anon'");
    } else {
        if (!(print_template('intro', $var_hash)))
            return error("could not print intro template");
    }
  
    return success();
}

function run_new (&$request_ref) {
    global $subject;
  
    if (isset($subject) && $subject) {
        if (!(save_new_post($request_ref)))
            return error("could not save new post");
    
    } else {
        if (!(print_new_post_form($request_ref)))
            return error("could not print new post form");
    }
  
    return success();
}

function run_profile (&$request_ref) {
    global $userid, $auth;
  
    if (!(restore_state($request_ref)))
        return error("could not restore state");
  
    if (!($username = $userid))
        return error("username not specified");
  
    $var_hash['username'] = $auth->auth_getusername($username);
    $var_hash['email'] = 'need a way to store/retrieve email addys for users';
    $var_hash['institution'] = 'default institution - keep this?';
  
    $var_hash['back'] = make_back_button($request_ref);
  
    if (!(build_navigation_bar($request_ref, $var_hash['nav_bar'])))
        return error("could not build navigation bar");
  
    if (!(build_status_bar($request_ref, $var_hash['status'])))
        return error("could not build status bar");
  
    if (!(build_search_button($request_ref, $var_hash['search'])))
        return error("could not build search button");
  
    $var_hash['body_tags'] = make_body_tags();
  
    if (!(print_template('profile', $var_hash)))
        return error("could not print profile template");
  
    return success();
}

function run_search (&$request_ref) {
    global $submit, $hide_read;
  
    if ((isset($submit) && $submit) || (isset($hide_read) && $hide_read)) {
        if (!perform_search($request_ref))
            return error("could not perform search");
    
    } else {
        if (!(print_search_form($request_ref)))
            return error("could not print search form");
    }
  
    return success();
}

function run_show (&$request_ref) {
    if (!(restore_state($request_ref)))
        return error("could not restore state");
  
    $request_ref->post['body'] = htmlspecialchars($request_ref->post['body']);
  
    if (!(translate_links($request_ref->post['body'])))
        return error("could not translate links");
  
    if (can_edit($request_ref))
        $var_hash['edit'] = make_edit_button($request_ref);
    else
        $var_hash['edit'] = '';
  
    if (can_reply($request_ref))
        $var_hash['reply'] = make_reply_button($request_ref);
    else
        $var_hash['reply'] = '';
  
    if (can_lock($request_ref))
        $var_hash['locked'] = make_is_locked_button($request_ref);
    else
        $var_hash['locked'] = '';
  
    if (!(mark_as_read($request_ref)))
        return error("could not mark as read");
  
    $var_hash['body_tags'] = make_body_tags();
  
    if (!(build_navigation_bar($request_ref, $var_hash['nav_bar'])))
        return error("could not build navigation bar");
  
    if (!(build_status_bar($request_ref, $var_hash['status'])))
        return error("could not build status bar");
  
    if (!(build_search_button($request_ref, $var_hash['search'])))
        return error("could not build search button");
  
    if (!(build_next_unread_button($request_ref, $var_hash['next_unread'])))
        return error("could not build next_unread button");
  
    if (!(export_state($request_ref, $var_hash)))
        return error("could not export state");
  
    if (!(print_template('show', $var_hash)))
        return error("could not print show template");
  
    return success();
}

function run_tree (&$request_ref) {
    if (!(restore_state($request_ref)))
        return error("could not restore state");
  
    if (!(mark_as_open($request_ref, $request_ref->post['parent'])))
        return error("could not mark '$request_ref->post['parent''] open");
  
    if (!(build_navigation_bar($request_ref, $var_hash['nav_bar'])))
        return error("could not build navigation bar");
  
    if (!(build_status_bar($request_ref, $var_hash['status'])))
        return error("could not build status bar");
  
    if (!(build_search_button($request_ref, $var_hash['search'])))
        return error("could not build search button");
  
    $var_hash['tree']  = "<DL>\n";
  
    if (!(build_tree($request_ref, $request_ref->topic_root, $var_hash['tree'])))
        return error("could not build tree");
  
    $var_hash['tree'] .= "</DL>\n";
  
    $var_hash['open_all'] = make_open_all_button($request_ref);
  
    $var_hash['close_all'] = make_close_all_button($request_ref);
  
    $var_hash['body_tags'] = make_body_tags();
  
    if (!(print_template('tree', $var_hash)))
        return error("could not print tree template");
  
    return success();
}

function save_edited_post (&$request_ref) {
    global $subject, $locked, $body;
  
    if (!(restore_state($request_ref)))
        return error("could not restore state");
  
    if (!(can_edit($request_ref)))
        return error("can not edit post id '$request_ref->id'");
  
    $new_post['id'] = $request_ref->id;
  
    if (!($new_post['subject'] = $subject))
        return error("'subject' not found in cgi");
  
    $new_post['modified'] = $request_ref->time;
  
    $new_post['locked'] = (can_lock($request_ref) && $locked);
  
    $new_post['body'] = $body;
  
    if (!(update_post($request_ref->topic, $new_post)))
        return error("could not store post");
  
    if (!(run_show($request_ref)))
        return error("could not run show");
  
    return success();
}

function save_new_post (&$request_ref) {
    global $subject, $body, $locked;
  
    if (!(restore_state($request_ref)))
        return error("could not restore state");
    
    if (!(can_reply($request_ref)))
        return error("can not reply to post id '$id'");
  
    $new_post['parent'] = $request_ref->id;
  
    if (!($new_post['subject'] = $subject))
        return error("'subject' not found in cgi");
  
    if (!($new_post['author_id'] = $request_ref->username))
        return error("'username' not found in request");
  
    $new_post['created'] = $request_ref->time;
  
    $new_post['modified'] = $request_ref->time;
  
    if (!($new_post['body'] = $body))
        return error("Your post must have a body");
  
    $new_post['locked'] = (can_lock($request_ref) && $locked);
  
    if (!(store_post($request_ref, $new_post)))
        return error("could not store post");
  
    $request_ref->id = $new_post['id'];
  
    if (!(run_show($request_ref)))
        return error("could not run show");
  
    return success();
}

function store_post ($request_ref, &$post_ref) {
    global $dbh;
  
    if (!($author_id = is_anonymous($request_ref) ? $request_ref->anon_id : $request_ref->user_id))
        return error("author_id not set");
  
    $parent = $post_ref['parent'];
  
    if (!($topic = $request_ref->topic))
        return error("topic undefined");
  
    $created = $post_ref['created'];
    $modified = $post_ref['modified'];
    $subject = addslashes($post_ref['subject']);
    $locked = $post_ref['locked'] ? '1' : '0';
    $body = addslashes($post_ref['body']);
  
    $query  = 'INSERT INTO posts ';
    $query .= '(parent, topic, subject, author_id, created, ';
    $query .= 'modified, locked, body) ';
    $query .= 'VALUES (';
    $query .= "$parent, '$topic', '$subject', '$author_id', $created, ";
    $query .= "$modified, $locked, '$body'";
    $query .= ')';
  
    if (!$dbh->query($query))
        return error("could not run query: $query" . $dbh->Error);
    $dbh->free();
  
    $post_ref['id'] = mysql_insert_id($dbh->Link_ID); // FIXME
  
    return success();
}

function success ($message = '') {
    global $global_error_stack;
    $global_error_stack = array();
  
    return SUCCESS;
}

function translate_links (&$html_ref) {
    $html_ref = preg_replace("|http://(\\w_-~/.]+)|i", "<a href=\"http://\\1\">\\1</a>", $html_ref);
  
    return success();
}

function update_post ($dbh, $topic, &$post_ref) {
    global $dbh;
  
    if (!($id = $post_ref['id']))
        return error("id not set in request");
  
    $subject = addslashes($post_ref['subject']);
    $modified = $post_ref['modified'];
    $locked = $post_ref['locked'] ? '1' : '0';
    $body = addslashes($post_ref['body']);
  
    $query  = "UPDATE posts ";
    $query .= "SET ";
    $query .= "subject = '$subject', "; 
    $query .= "modified = $modified, ";
    $query .= "locked = $locked, ";
    $query .= "body = '$body' ";
    $query .= "WHERE id = $id";
  
    if (!$dbh->query($query))
        return error("could not run query: $query" . $dbh->Error);
    $dbh->free();
  
    return success();
}
