<?php
/*
 * $Horde: chain/view.php,v 1.15 2002/03/19 02:01:32 chuck Exp $
 *
 * Copyright 2001 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('CHAIN_BASE', dirname(__FILE__));
require_once CHAIN_BASE . '/lib/base.php';

/* If we aren't provided with a link, redirect to the link list. */
$link_id = Horde::getFormData('link');
if (!isset($link_id)) {
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

/* Create a Chain storage instance. */
require_once CHAIN_BASE . '/lib/Driver.php';
$storage = &Chain_Driver::factory($conf['storage']['driver'], Auth::getAuth(),
                                $conf['storage']['params']);
$storage->retrieve();

/* Get the current link list. */
$links = Chain::listLinks($storage);

/* Set the page title to the current link's name, if it exists. */
$title = (!empty($links[$link_id])) ? $links[$link_id]['name'] : _("Link Details");

$js_onLoad = null;
require CHAIN_TEMPLATES . '/common-header.inc';
require CHAIN_BASE . '/menu.php';
$notification->notify();

/* If the requested link doesn't exist, display an error message. */
if (!isset($links[$link_id])) {
    include CHAIN_TEMPLATES . '/view/no-link.inc';
} else {
    include CHAIN_TEMPLATES . '/view/headers.inc';
    include CHAIN_TEMPLATES . '/view/description.inc';
    include CHAIN_TEMPLATES . '/view/navbar.inc';
}

require CHAIN_TEMPLATES . '/common-footer.inc';

?>
