<?php
/*
 * $Horde: chain/today.php,v 1.24 2002/05/26 17:39:38 jan Exp $
 *
 * Copyright 2001 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('CHAIN_BASE', dirname(__FILE__));
require_once CHAIN_BASE . '/lib/base.php';

/* Redirect to the link list if no action has been requested. */
$actionID = Horde::getFormData('actionID', NOOP);
if ($actionID === NOOP) {
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}
$categoryID = Horde::getFormData('category');

/* Create a Chain storage instance. */
require_once CHAIN_BASE . '/lib/Driver.php';
$storage = &Chain_Driver::factory($conf['storage']['driver'], Auth::getAuth(),
                                $conf['storage']['params']);

$link_id = Horde::getFormData('link');

$type = 1;

$storage->getToday();
$today = $storage->listToday();
if ($link_id) {
    $currlink = $today[$link_id];
}

/* Run through the action handlers. */
switch($actionID) {
case CHAIN_ADD_LINK:

    /* Set up the link attributes. */
    $link_id = null;
    $link_title = '';
    $link_desc = '';
    $link_date = 0;
    $link_location = '';

    $title = _("Adding A New Link");

    break;

case CHAIN_MODIFY_LINK:

    if (isset($link_id) && isset($currlink['id'])) {
        /* Set up the link attributes. */
        $link_title = $currlink['title'];
        $link_desc = $currlink['desc'];
        $link_location = $currlink['location'];
        $link_date = date("Y-m-d H:i:s", $currlink['date']);

        $title = _("Modifying:") . ' ' . $link_title;
    } else {
        $title = _("Unknown link");
    }

    break;

case CHAIN_SAVE_LINK:

    /* Get the form values. */
    $link_id = Horde::getFormData('link');
    $link_title = Horde::getFormData('link_title');
    $link_desc = Horde::getFormData('link_desc');
    $link_location = Horde::getFormData('link_location');
    $link_date = time();

    if (isset($_FILES['link_file']['tmp_name'])) {
        if (is_uploaded_file($_FILES['link_file']['tmp_name'])) {
            $link_location = $conf['storage']['data'] . '/' . $_FILES['link_file']['name'];
            move_uploaded_file($_FILES['link_file']['tmp_name'], CHAIN_BASE . '/' . $link_location);
//            echo CHAIN_BASE . '/' . $link_location;
        }
    }

    /*
     * If $link_id is set, we're modifying an existing link.  Otherwise,
     * we're adding a new link with the provided attributes.
     */
    if ($link_id != "") {
        if (!PEAR::isError($storage->changeToday($link_id, $link_location, $link_title, $link_desc))) {
            $notification->push(_("The link was updated."), 'horde.success');
        } else {
            $notification->push(_("There was a problem updating the link."), 'horde.error');
        }
    } else {
        if (!PEAR::isError($storage->addToday($link_location, $link_title, $link_desc))) {
            $notification->push(_("The link was added."), 'horde.success');
        } else {
            $notification->push(_("There was a problem adding the link."), 'horde.error');
        }
    }

    /* Return to the link list. */
    header('Location: ' . Horde::applicationUrl("admin.php", true));
    exit;

    break;

case CHAIN_DELETE_LINK:

    /* Delete the link if we're provided with a valid link ID to delete. */
    $link_id = Horde::getFormData('link');
    if (Chain::isLocalFile($currlink['location']) && file_exists(CHAIN_BASE . "/" . $currlink['location'])) {
        unlink(CHAIN_BASE . "/" . $currlink['location']);
    }
    if (isset($link_id)) {
        if (!PEAR::isError($storage->removeToday($link_id))) {
            $notification->push(_("Deleted the link."), 'horde.success');
        } else {
            $notification->push(_("There was a problem deleting the link."), 'horde.error');
        }
    }

    /* Return to the link list. */
    header('Location: ' . Horde::applicationUrl('admin.php', true));
    exit;

    break;

default:
    header('Location: ' . Horde::applicationUrl('admin.php', true));
    exit;
}

$js_onLoad = null;
require CHAIN_TEMPLATES . '/common-header.inc';
require CHAIN_BASE . '/menu.php';
$notification->notify();
require CHAIN_TEMPLATES . '/link/begin.inc';
require CHAIN_TEMPLATES . '/link/link.inc';
require CHAIN_TEMPLATES . '/link/end.inc';
require CHAIN_TEMPLATES . '/common-footer.inc';

$prefs->store();

?>
