<?php
    $levelsLeftToParse = explode("|", $upperID);
    array_push($levelsLeftToParse, $categoryID);
    array_shift($levelsLeftToParse);  // Get rid of 0 level (Main Menu)
    $myTopLevel = array_shift($levelsLeftToParse);  // Get current top level (Main Menu subcategory)
    $levelsAboveMe = array(0, $myTopLevel);
?>

<base target="horde_main">
<style type="text/css"><!-- .mainmenuitem {font-size:15px;font-weight:bold;}--></style>
<table width="100%">
<table border="0" cellpadding="1" cellspacing="0" width="100%">
<tr><td class="header">
<?php 
    $storage->getCategory($myTopLevel);
    $topCategoryInfo = Chain::listCategory($storage);
    echo Horde::link('list.php?categoryID=' . $myTopLevel . '&upperID=1',
                $topCategoryInfo['desc'], 'header', 'horde_main');
    echo '<nobr>' . $topCategoryInfo['title'] . '</nobr></a>';
?>
</td></tr>
<tr><td class="control">
<table width="100%" border="0" cellpadding="3" cellspacing="1">
<tr class="list"><td>
<?php
    $storage->getCategories($myTopLevel);
    $levelCategories = Chain::listCategories($storage, $prefs->getValue('csortby'),
                       $prefs->getValue('csortdir'));
    $presentLevelInMenu = array_shift($levelsLeftToParse);
    $subcats = 0; // Set subcats to 0 in case there's nothing below
    $pathToTop = array(CHAIN_TOP, $myTopLevel);
    if (count($levelCategories) > 0) {
        foreach ($levelCategories as $presentLevelInArray) {
            if ($presentLevelInArray['id'] == $presentLevelInMenu) {
                containerCase($levelsLeftToParse, $presentLevelInArray['id'], $pathToTop);
            } else {
                baseCase($presentLevelInArray['id'], $pathToTop);
            }
        }
        $subcats = 1;
    }
    $storage->getLinks($myTopLevel);
    $levelLinks = Chain::listLinks($storage, $prefs->getValue('lsortby'),
                        $prefs->getValue('lsortdir'));
    foreach ($levelLinks as $levelLink) {
        if ($levelLink['subcategory']) {
            echo Horde::link('dataframe.php?categoryID=' . $presentLevelInMenu . '&upperID=' .
                        implode("|", $pathToTop)  . '&file=' . $levelLink['location'],
                        $levelLink['title'], 'mainmenuitem', 'horde_main');
            echo $levelLink['title'] . '</a><br />';
            $subcats = 1;
        }
    }
    if (!$subcats) {
        echo '<div class="mainmenuitem">(No subcategories)</div>';
    }
?>
</td></tr></table></td><td></td></tr>
</table>


<?php

function baseCase($presentLevelInMenu, $pathToTop, $bullet = 0) {
    global $categoryID, $storage;
    $inframe = Horde::getFormData('inframe');
    $storage->getCategory($presentLevelInMenu);
    $thisCategoryInfo = Chain::listCategory($storage);
    if ($bullet == 1) {
        $bulletText = "&bull; ";
    } elseif ($bullet == 2) {
        $bulletText = "&diams; ";
    } elseif ($bullet >= 3) {
        $bulletText = "&loz; ";
    } else {
        $bulletText = "";
    }
    if (($categoryID == $presentLevelInMenu) && (!$inframe)) {
        echo '<div class="mainmenuitem">' . $bulletText . $thisCategoryInfo['title'] . '</div>';
    } else {
        echo Horde::link('list.php?categoryID=' . $presentLevelInMenu . '&upperID=' .
                    implode("|", $pathToTop), $thisCategoryInfo['desc'],
                    'mainmenuitem', 'horde_main');
        echo $bulletText . $thisCategoryInfo['title'] . '</a><br />';
    }
}

// upperLevels is list of levels to go through to get to current one
function containerCase($levelsLeftToParse, $presentLevelInMenu, $pathToTop, $bullet = 0) {
    global $prefs, $storage;
    baseCase($presentLevelInMenu, $pathToTop, $bullet);
    $storage->getCategories($presentLevelInMenu);
    $levelCategories = Chain::listCategories($storage, $prefs->getValue('csortby'),
                       $prefs->getValue('csortdir'));
    $storage->getLinks($presentLevelInMenu);
    $levelLinks = Chain::listLinks($storage, $prefs->getValue('lsortby'),
                        $prefs->getValue('lsortdir'));
    $hasLinkSubCategories = 0;
    // First check whether we have any links that must be treated as subcategories
    foreach ($levelLinks as $levelLink) {
        if ($levelLink['subcategory']) {
            $hasLinkSubCategories = 1;
        }
    }
    $hasSubCategories = 0;
    // If we have subcategories (or link-subcategories) then indent the entries
    if ((count($levelCategories) > 0) || $hasLinkSubCategories) {
        $hasSubCategories = 1;
        echo '<table border=0 cellpadding=0 cellspacing=0><tr><td width=10>&nbsp;</td><td class="mainmenuitem">';
        // The links need to know their path to top -- now we must include level they are contained in
        array_push($pathToTop, $presentLevelInMenu);
        foreach ($levelCategories as $presentLevelInArray) {
        $presentLevelInMenu = array_shift($levelsLeftToParse);
            if ($presentLevelInArray['id'] == $presentLevelInMenu) {
                containerCase($levelsLeftToParse, $presentLevelInArray['id'], $pathToTop, $bullet + 1);
            } else {
                baseCase($presentLevelInArray['id'], $pathToTop, $bullet + 1);
            }
        }
    }
    $bullet++;
    if ($bullet == 1) {
        $bulletText = "&bull; ";
    } elseif ($bullet == 2) {
        $bulletText = "&diams; ";
    } elseif ($bullet >= 3) {
        $bulletText = "&loz; ";
    } else {
        $bulletText = "";
    }
    foreach ($levelLinks as $levelLink) {
        if ($levelLink['subcategory']) {
            echo Horde::link('dataframe.php?categoryID=' . $presentLevelInMenu . '&upperID=' .
                        implode("|", $pathToTop)  . '&file=' . $levelLink['location'],
                        $levelLink['title'], 'mainmenuitem', 'horde_main');
            echo $bulletText . $levelLink['title'] . '</a><br />';
        }
    }
    if ($hasSubCategories) {
        echo '</td></tr></table>';
    }

}

function printArray($array) {
    $text = 'Array: [ ';
    $first = 1;
    foreach ($array as $key => $item) {
        if (!$first) {
            $text .= ' | ';
        } else {
            $first = CHAIN_TOP;
        }
        $text .= $key . ': ' . $item;
    }
    $text .= ' ]';
    return $text;
}
