<?php
/*
 * $Horde: chain/list.php,v 1.35 2002/06/12 23:35:21 slusarz Exp $
 *
 * Copyright 2001 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('CHAIN_BASE', dirname(__FILE__));
require_once CHAIN_BASE . '/lib/base.php';
require_once CHAIN_BASE . '/config/html.php';

/* Get the current action ID. */
$actionID = Horde::getFormData('actionID');

/* Get the current category ID. Default to 0. */
$categoryID = Horde::getFormData('categoryID', CHAIN_TOP);

/* Get the upper level category ID. Default to null. */
$upperID = Horde::getFormData('upperID', null);

/* Sort out the sorting values. */
if (Horde::getFormData('lsortby', -1) >= 0) {
    $prefs->setValue('lsortby', Horde::getFormData('lsortby'));
}
if (Horde::getFormData('lsortdir', -1) >= 0) {
   $prefs->setValue('lsortdir', Horde::getFormData('lsortdir'));
}

/* Sort out the sorting values. */
if (Horde::getFormData('csortby', -1) >= 0) {
    $prefs->setValue('csortby', Horde::getFormData('csortby'));
}
if (Horde::getFormData('csortdir', -1) >= 0) {
   $prefs->setValue('csortdir', Horde::getFormData('csortdir'));
}

/* Create a Chain storage instance. */
require_once CHAIN_BASE . '/lib/Driver.php';
$storage = &Chain_Driver::factory($conf['storage']['driver'], Auth::getAuth(),
                                $conf['storage']['params']);
$storage->getLinks($categoryID);
$storage->getCategories($categoryID);
$storage->getCategory($categoryID, 1);
$storage->getAllCategories();

/* Get the full, sorted link list. */
$links = Chain::listLinks($storage, $prefs->getValue('lsortby'),
                        $prefs->getValue('lsortdir'));
$categories = Chain::listCategories($storage, $prefs->getValue('csortby'),
                        $prefs->getValue('csortdir'));
$thiscategory = Chain::listCategory($storage);
$allCategories = $storage->listAllCategories();

if ($upperID != "") {
    $mycategoryID = $upperID . "|" . $thiscategory['id'];
} else {
    $mycategoryID = $thiscategory['id'];
}

/* Page variables. */
$i = 0;
$js_onLoad = null;
$title = _("Content Listing");


require CHAIN_TEMPLATES . '/common-header.inc';
require CHAIN_BASE . '/menu.php';
$notification->notify();
//require CHAIN_TEMPLATES . '/list/javascript.inc';

echo '<table width="100%" border=0 cellpadding=0 cellspacing=0>' . "\n";
echo "<tr>\n";

if ($categoryID == 1) {
    echo "<td></td>\n";
} else {
    echo '<td width=180 valign="top">' . "\n";
    include CHAIN_TEMPLATES . '/list/navbar.inc';
    echo "</td>\n";
    echo "<td width=5></td>\n";
}
echo '<td valign="top">' . "\n";
require CHAIN_TEMPLATES . '/list/header.inc';

// echo "<br />";

if ($thiscategory['content']) {
    include CHAIN_TEMPLATES . '/content/content.inc';
echo "<br />";

}

if ((count($categories) > 0) && ($categoryID == 1)) {
    include CHAIN_TEMPLATES . '/list/category_headers.inc';

    foreach ($categories as $category_id => $category) {
        include CHAIN_TEMPLATES . '/list/category_summaries.inc';
    }

    include CHAIN_TEMPLATES . '/list/category_footers.inc';
echo "<br />";

}

if (count($links) > 0) {
    include CHAIN_TEMPLATES . '/list/link_headers.inc';

    foreach ($links as $link_id => $link) {
        include CHAIN_TEMPLATES . '/list/link_summaries.inc';
    }

    include CHAIN_TEMPLATES . '/list/link_footers.inc';
}

require CHAIN_TEMPLATES . '/list/footer.inc';

?>
</td>
</tr>
</table>
<?php
require CHAIN_TEMPLATES . '/common-footer.inc';

$prefs->store();

?>
