<?php
// $Horde: chain/lib/base.php,v 1.29 2002/06/19 02:31:22 chuck Exp $
/*
 * Chain base inclusion file.
 *
 * This file brings in all of the dependencies that every Chain
 * script will need and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Chain
@define('CHAIN_BASE', dirname(__FILE__) . '/..');

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('chain');
$conf = &$GLOBALS['conf'];
@define('CHAIN_TEMPLATES', $registry->getParam('templates'));

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Text.php';
require_once HORDE_BASE . '/lib/Help.php';

// Chain base library
require_once CHAIN_BASE . '/lib/Chain.php';

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';
$browser = new Browser();

// Notification sytem
require_once HORDE_BASE . '/lib/Notification.php';
$notification = &Notification::singleton();
$notification->attach('status');

// Redirect the user to the Horde login page if they haven't authenticated.
if (!Auth::getAuth()) {
    header('Location: ' . Horde::url($registry->getParam('webroot', 'horde') . '/login.php?url=' . urlencode(Horde::selfUrl()), true));
    exit;
}

?>
