<?php
// $Horde: chain/lib/api.php,v 1.15 2002/06/15 00:44:37 chuck Exp $
/*
 * Chain external API interface.
 *
 * This file defines Chain's external API interface.  Other applications can
 * interact with Chain through this API.
 */

// Find the base file paths for Horde and Chain
@define('CHAIN_BASE', dirname(__FILE__) . '/..');

// Include the necessary libraries.
require_once CHAIN_BASE . '/lib/base.php';

function chainListCategories($sortby = null, $sortdir = null)
{
    global $conf, $prefs;

    if (!isset($sortby)) $sortby = $prefs->getValue('csortby');
    if (!isset($sortdir)) $sortdir = $prefs->getValue('csortdir');

    /* Create a Chain storage instance. */
    require_once CHAIN_BASE . '/lib/Driver.php';
    $storage = &Chain_Driver::singleton($conf['storage']['driver'],
                                      Auth::getAuth(), $conf['storage']['params']);
    $storage->getCategories(CHAIN_TOP);

    return Chain::listCategories($storage, $sortby, $sortdir);
}

function chainListTopLinks($sortby = null, $sortdir = null)
{
    global $conf, $prefs;

    if (!isset($sortby)) $sortby = $prefs->getValue('lsortby');
    if (!isset($sortdir)) $sortdir = $prefs->getValue('lsortdir');

    /* Create a Chain storage instance. */
    require_once CHAIN_BASE . '/lib/Driver.php';
    $storage = &Chain_Driver::singleton($conf['storage']['driver'],
                                      Auth::getAuth(), $conf['storage']['params']);
    $storage->getLinks(CHAIN_TOP);

    return Chain::listLinks($storage, $sortby, $sortdir);
}

function chainListToday($sortby = null, $sortdir = null)
{
    global $conf, $prefs;

    if (!isset($sortby)) $sortby = $prefs->getValue('lsortby');
    if (!isset($sortdir)) $sortdir = $prefs->getValue('lsortdir');

    /* Create a Chain storage instance. */
    require_once CHAIN_BASE . '/lib/Driver.php';
    $storage = &Chain_Driver::singleton($conf['storage']['driver'],
                                      Auth::getAuth(), $conf['storage']['params']);
    $storage->getToday();

    return Chain::listToday($storage, $sortby, $sortdir);
}

function chainContent($header = 1, $toplinks = 1)
{
    global $registry, $prefs;

    $html  = '<table border="0" cellpadding="2" cellspacing="0" width="100%">';
    if ($header) {
        $html .= '<tr><td class="header">';
        $html .= Horde::link(Horde::url($registry->getInitialPage()), $registry->getParam('name'), 'header') . $registry->getParam('name') . '</a>';
        $html .= '</td></tr>';
    }
    $html .= '<tr><td class="text"><table border="0" cellpadding="0" cellspacing="0">';

    $categories = chainListCategories();
    $html .= '<style type="text/css"><!-- a.mainmenuitem {font-size:15px;font-weight:bold;} --></style>';
    foreach ($categories as $id => $category) {
        $html .= '  <tr><td class="text">';
        $html .= Horde::link(Horde::applicationUrl('list.php?categoryID=' . $id . '&upperID=' . CHAIN_TOP), $category['title'], 'mainmenuitem') . htmlspecialchars($category['title']) . '</a>';
        $html .= "</td></tr>\n";
    }
    $html .= '</table></td></tr></table>';

    if ($toplinks) {
        $html .= '<br />';
        $html .= '<table border="0" cellpadding="2" cellspacing="0" width="100%">';
        if ($header) {
            $html .= '<tr><td class="header">';
            $html .= Horde::link(Horde::url($registry->getInitialPage()), _("Top Links"), 'header') . _("Top Links") . '</a>';
            $html .= '</td></tr>';
        }
        $html .= '<tr><td class="text"><table border="0" cellpadding="0" cellspacing="0">';

        $links = chainListTopLinks();
        $html .= '<style type="text/css"><!-- a.mainmenuitem {font-size:17px;font-weight:bold;} --></style>';
        foreach ($links as $id => $link) {
            $html .= '  <tr><td class="text">';
            if ($prefs->getValue('ltarget') == CHAIN_TARGET_EXTERNAL_CONTENT) {
                $target = '_self';
            } elseif ($prefs->getValue('ltarget') == CHAIN_TARGET_EXTERNAL_NEW) {
                $target = '_blank';
            } else {
                $target = '_top';
            }
            $html .= Horde::link(Horde::url($link['location']), $link['title'], 'mainmenuitem', $target) . htmlspecialchars($link['title']) . '</a>';
            $html .= "</td></tr>\n";
        }
        $html .= '</table></td></tr></table>';
    }

    return $html;
}

function chainSummary()
{
    global $registry, $prefs;

        $html = "";
        $html .= '<table border="0" cellpadding="2" cellspacing="0" width="100%">';
            $html .= '<tr><td class="header">';
            $html .= Horde::link(Horde::url($registry->getInitialPage()), _("Today@Work"), 'header') . _("Today@Work") . '</a>';
            $html .= '</td>';
            $html .= '<td class="header" align="right">';
            $html .= Horde::link(Horde::url($registry->getParam('webroot', 'horde') . '/suggestion.php?return_url=' . urlencode(Horde::url($_SERVER['PHP_SELF'], true))), _("Suggestions"), 'smallheader');
            $html .= _("Suggestion Box") . '</a></td></tr>';
        $html .= '<tr><td class="text" colspan="2"><table border="0" cellpadding="0" cellspacing="0" width="100%">';

        $columns = $prefs->getValue('atwork');

        $links = chainListToday();
        
        $numberOfLinks = count($links);

        if ($numberOfLinks < $columns) {
            $columns = $numberOfLinks;
        }
        
        $width = 100 / $columns;

        if (!$columns) {
            $html .= '<tr><td class="text">There are no links today.</td></tr>';
        } else {
            $count = 0;
            foreach ($links as $id => $link) {
                if (!($count % $columns)) {
                    $html .= '<tr>';
                }
                $html .= '<td align="center" class="text" width="' . $width . '%">';
                if ($prefs->getValue('ltarget') == CHAIN_TARGET_EXTERNAL_CONTENT) {
                    $target = '_self';
                } elseif ($prefs->getValue('ltarget') == CHAIN_TARGET_EXTERNAL_NEW) {
                    $target = '_blank';
                } else {
                    $target = '_top';
                }
                if (Chain::isLocalFile($link['location'])) {
                    $html .= Horde::link(Horde::applicationUrl($link['location']), $link['title'], '', $target) . $link['title'] . '</a>';
                } else {
                    $html .= Horde::link(Horde::url($link['location']), $link['title'], '', $target) . $link['title'] . '</a>';
                }
                if ($link['desc']) {
                    $html .= ': ' . $link['desc'];
                }
                $html .= "</td>\n";
                $count++;
                if (!($count % $columns) || ($count == $columns)) {
                    $html .= "</tr>\n";
                }
            }
        }
        $html .= '</table></td></tr></table>';

    return $html;
}
?>
