<?php
// $Horde: chain/lib/Driver.php,v 1.25 2002/06/14 17:57:52 chuck Exp $

// Internal status flags (for bitwise operations)
/** @constant LINK_ANY Link has any flag set. */
define('LINK_ANY', 0);

/** @constant LINK_ADDED Link has just been added. */
define('LINK_ADDED', 1);

/** @constant LINK_MODIFIED Link has been modified. */
define('LINK_MODIFIED', 2);

/** @constant LINK_DELETED Link has been deleted. */
define('LINK_DELETED', 4);

/** @constant CATEGORY_ANY Link has any flag set. */
define('CATEGORY_ANY', 0);

/** @constant CATEGORY_ADDED Category has just been added. */
define('CATEGORY_ADDED', 1);

/** @constant CATEGORY_MODIFIED Category has been modified. */
define('CATEGORY_MODIFIED', 2);

/** @constant CATEGORY_DELETED Category has been deleted. */
define('CATEGORY_DELETED', 4);

/**
 * Chain_Driver:: defines an API for implementing storage backends for Chain.
 *
 * @author  Jon Parise <jon@horde.org>
 * @version $Revision: 1.25 $
 * @since   Chain 0.1
 * @package chain
 */
class Chain_Driver {

    /**
     * Array holding the current link information.  Each array entry is a
     * property of the link.
     * @var array $currlink
     */
    var $currlink = array();

    /**
     * Array holding the current link list.  Each array entry is a hash
     * describing a link.  The array is indexed numerically by link ID.
     * @var array $links
     */
    var $links = array();

    /**
     * Array holding today's link list.  Each array entry is a hash
     * describing a link.  The array is indexed numerically by link ID.
     * @var array $links
     */
    var $today = array();

    /**
     * Array holding the current category list.  Each array entry is a hash
     * describing a category.  The array is indexed numerically by category ID.
     * @var array $categories
     */
    var $categories = array();

    /**
     * Array holding the full category list.  Each array entry is a hash
     * describing a category.  The array is indexed numerically by category ID.
     * @var array $categories
     */
    var $allCategories = array();

    /**
     * String containing the current username.  This indicates the owner of
     * the current link list.
     * @var string $user
     */
    var $user = '';

    /**
     * Attempts to return a concrete Chain_Driver instance based on $driver.
     *
     * @param string    $driver     The type of concrete Chain_Driver subclass
     *                              to return.  The is based on the storage
     *                              driver ($driver).  The code is dynamically
     *                              included.
     *
     * @param string    $user       The name of the user who owns these links.
     *
     * @param array     $params     (optional) A hash containing any additional
     *                              configuration or connection parameters a
     *                              subclass might need.
     *
     * @return mixed    The newly created concrete Chain_Driver instance, or
     *                  false on an error.
     */
    function &factory($driver, $user, $params = array())
    {
        $driver = strtolower(basename($driver));
        include_once dirname(__FILE__) . '/Driver/' . $driver . '.php';
        $class = 'Chain_Driver_' . $driver;
        if (class_exists($class)) {
            return new $class($user, $params);
        } else {
            return false;
        }
    }

    /**
     * Attempts to return a reference to a concrete Chain_Driver instance
     * based on $driver.  It wil only create a new instance if no
     * Chain_Driver instance with the same parameters currently exists.
     *
     * This should be used if multiple storage sources are required.
     *
     * This method must be invoked as: $var = &Chain_Driver::singleton()
     *
     * @param string    $driver     The type of concrete Chain_Driver subclass
     *                              to return.  The is based on the storage
     *                              driver ($driver).  The code is dynamically
     *                              included.
     *
     * @param string    $user       The name of the user who owns these links.
     *
     * @param array     $params     (optional) A hash containing any additional
     *                              configuration or connection parameters a
     *                              subclass might need.
     *
     * @return mixed    The created concrete Chain_Driver instance, or false
     *                  on error.
     */
    function &singleton($driver, $user, $params = array())
    {
        static $instances;

        if (!isset($instances)) $instances = array();

        $signature = md5(strtolower($driver) . '][' . $user . implode('][', $params));
        if (!isset($instances[$signature])) {
            $instances[$signature] = &Chain_Driver::factory($driver, $user, $params);
        }

        return $instances[$signature];
    }

    /**
     * Lists links based on the given criteria.  All links will be returned
     * by default.
     *
     * @param optional constant $criteria  A set of flags specifying the
     *                                     set of links to return.
     *
     * @return array    Returns a list of the requested links.
     */
    function listLinks($category = CATEGORY_ANY) {
        return $this->links;
    }

    /**
     * Lists categories based on the given criteria.  All categories will be
     * returned by default.
     *
     * @return array    Returns a list of the requested categories.
     */
    function listCategories() {
        return $this->categories;
    }

    /**
     * Lists categories based on the given criteria.  All categories will be
     * returned by default.
     *
     * @return array    Returns a list of the requested categories.
     */
    function listCategory() {
        return $this->category;
    }

    /**
     * Lists information about the currently-selected link.
     *
     * @return array    Returns a list of the requested links.
     */
    function listLink() {
        return $this->currlink;
    }

    /**
     * Lists information about today's links.
     *
     * @return array    Returns a list of the requested links.
     */
    function listToday() {
        return $this->today;
    }

    /**
     * Lists information about all the categories.
     *
     * @return array    Returns a list of all categories.
     */
    function listAllCategories() {
        return $this->allCategories;
    }


}
?>
