<?php
define('CHAIN_BASE', dirname(__FILE__));
require_once CHAIN_BASE . '/lib/base.php';
require_once CHAIN_BASE . '/config/html.php';

$categoryID = Horde::getFormData('categoryID');
$upperID = Horde::getFormData('upperID');
$datafile = Horde::getFormData('file');

if (isset($language) && isset($nls['charsets'][$language])) {
    header('Content-type: text/html; charset=' . $nls['charsets'][$language]);
    header('Vary: Accept-Language');
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "DTD/xhtml1-transitional.dtd">
<?php echo !empty($language) ? '<html lang="' . strtr($language, '_', '-') . '">' : '<html>' ?>
<head>
<?php

$page_title = $registry->getParam('name');
if (!empty($title)) $page_title .= ' :: ' . $title;
if (!empty($refresh_time) && ($refresh_time > 0) && !empty($refresh_url)) {
    echo "<meta http-equiv=\"refresh\" content=\"$refresh_time;url=$refresh_url\">\n";
}

$theme = '';
if (isset($prefs)) {
    $theme = $prefs->getValue('theme');
}
if (!empty($theme)) {
    $theme = '&theme=' . $theme;
}

?>
<title><?php echo $page_title ?></title>
<link href="<?php echo $registry->getParam('webroot', 'horde') ?>/css.php?app=chain<?php echo $theme ?>" rel="stylesheet" type="text/css" />
</head>

<frameset border=0 frameborder=0 rows=129,*>
    <frame frameborder=0 name="menu" src="list.php?categoryID=<?php
        echo $categoryID ?>&upperID=<?php echo $upperID ?>&inframe=1" scrolling=no>
    <frameset border=0 frameborder=0 cols=195,*>
        <frame frameborder=0 name="navbar" src="navbar.php?categoryID=<?php
        echo $categoryID ?>&upperID=<?php echo $upperID ?>&inframe=1">
        <frame frameborder=0 name="data" src="<?php echo $datafile ?>">
    </frameset>
</frameset>

<body>

<?php

require CHAIN_TEMPLATES . '/common-footer.inc';

?>
