<?php
// $Horde: chain/config/prefs.php.dist,v 1.12.2.1 2002/04/23 06:25:17 chuck Exp $

// Make sure that constants are defined.
require_once dirname(__FILE__) . '/../lib/constants.php';

$prefGroups['language'] = array(
    'column' => _("Your Information"),
    'label' => _("Language"),
    'desc' => _("Set the your preferred display language."),
    'members' => array('language'));

$prefGroups['display'] = array(
    'column' => _("Other Options"),
    'label' => _("Display Options"),
    'desc' => _("Change your link target, sorting and display options."),
    'members' => array('atwork', 'ltarget', 'lsortby', 'csortby', 'lsortdir', 'csortdir'));


// user language
$_prefs['language'] = array(
    'value' => '',
    'locked' => false,
    'shared' => true,
    'type' => 'select',
    'desc' => _("Select your preferred language:")
);

$_prefs['atwork'] = array(
    'value' => 3,
    'locked' => false,
    'shared' => false,
    'type' => 'number',
    'desc' => _("How many columns would you like to use to show the Today@Work links?")
);

// set link target
$_prefs['ltarget'] = array(
    'value' => CHAIN_TARGET_EXTERNAL_NEW,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(CHAIN_TARGET_EXTERNAL_CONTENT => _("External links inside content pane only"),
                    CHAIN_TARGET_EXTERNAL_FULL => _("External links fill full window"),
                    CHAIN_TARGET_EXTERNAL_NEW => _("External links open new window")),
    'desc' => _("Target for external links:")
);

// user preferred sorting column
$_prefs['lsortby'] = array(
    'value' => CHAIN_SORT_TITLE,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(CHAIN_SORT_TITLE => _("Title"),
                    CHAIN_SORT_LOCATION => _("Location"),
                    CHAIN_SORT_DESCRIPTION => _("Description"),
                    CHAIN_SORT_DATE => _("Date Modified")),
    'desc' => _("Default link sorting criteria:")
);

// user preferred sorting column
$_prefs['csortby'] = array(
    'value' => CHAIN_SORT_TITLE,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(CHAIN_SORT_TITLE => _("Title"),
                    CHAIN_SORT_DESCRIPTION => _("Description")),
    'desc' => _("Default category sorting criteria:")
);

// user preferred sorting direction
$_prefs['lsortdir'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(CHAIN_SORT_ASCEND => _("Ascending"),
                    CHAIN_SORT_DESCEND => _("Descending")),
    'desc' => _("Default link sorting direction:")
);

// user preferred sorting direction
$_prefs['csortdir'] = array(
    'value' => 0,
    'locked' => false,
    'shared' => false,
    'type' => 'enum',
    'enum' => array(CHAIN_SORT_ASCEND => _("Ascending"),
                    CHAIN_SORT_DESCEND => _("Descending")),
    'desc' => _("Default category sorting direction:")
);


