<?php
/*
 * Chain Configuration File
 *
 * This file contains global configuration settings for Chain.  Values may be
 * safely edited by hand.  Use config.php.dist as a reference.
 *
 * Default user preferences are defined in 'prefs.php'.
 *
 * Strings should be enclosed in 'quotes'.
 * Integers should be given literally (without quotes).
 * Boolean values may be 'true' or 'false'.
 *
 * $Horde: chain/config/conf.php.dist,v 1.17.2.1 2002/03/12 17:07:16 jan Exp $
 */


/**
 ** Authorized administrator users
 **/

//$conf['auth']['admins'] = array();
$conf['auth']['admins'] = array_merge($conf['auth']['admins'], array());

/**
 ** Link List Settings
 **/

$conf['list']['date_format'] = '%x %X';


/**
 ** Link View Settings
 **/

$conf['view']['date_format'] = '%x';
$conf['view']['time_format'] = '%X';


/**
 ** Storage System Settings
 **/

// What is the relative path to the data directory for storing uploaded files?
$conf['storage']['data'] = 'data';

// What storage driver should we use?  Valid values are 'sql'.
$conf['storage']['driver'] = 'sql';

// Any parameters that the storage driver needs. This includes
// database or ldap server, username/password to connect with, etc.
// Below is an example configuration for an sql driver, in this case
// MySQL.
$conf['storage']['params'] = array();
$conf['storage']['params']['phptype'] = 'mysql';
$conf['storage']['params']['hostspec'] = 'localhost';
$conf['storage']['params']['username'] = 'horde';
$conf['storage']['params']['password'] = '******';
$conf['storage']['params']['database'] = 'horde';
$conf['storage']['params']['table'] = 'chain_links';
$conf['storage']['params']['table_categories'] = 'chain_categories';
//$conf['storage']['params']['table_link_listing'] = 'chain_link_listing';
//$conf['storage']['params']['table_category_listing'] = 'chain_category_listing';
$conf['storage']['params']['table_today'] = 'chain_today';


/**
 ** Menu settings
 **/

// This is an array of applications (using the names defined in
// horde/config/registry.php) to include links to in the menubar. An
// example providing a link to Turba (an addressbook program) would
// be: $conf['menu']['apps'] = array('turba');
$conf['menu']['apps'] = array();
