<?php
/*
 * $Horde: chain/category.php,v 1.24 2002/05/26 17:39:38 jan Exp $
 *
 * Copyright 2001 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('CHAIN_BASE', dirname(__FILE__));
require_once CHAIN_BASE . '/lib/base.php';

/* Redirect to the link list if no action has been requested. */
$actionID = Horde::getFormData('actionID', NOOP);
if ($actionID === NOOP) {
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

/* Create a Chain storage instance. */
require_once CHAIN_BASE . '/lib/Driver.php';
$storage = &Chain_Driver::factory($conf['storage']['driver'], Auth::getAuth(),
                                $conf['storage']['params']);

$category_id = Horde::getFormData('category');

$storage->getCategory($category_id);
$storage->getAllCategories();

/* Retrieve the link list. */
$currcategory = $storage->listCategory();
$allCategories = $storage->listAllCategories();

/* Run through the action handlers. */
switch($actionID) {
case CHAIN_ADD_CATEGORY:

    /* Set up the category attributes. */
    $category_id = null;
    $category_title = '';
    $category_desc = '';
    $category_content = '';
    $category_category = $currcategory['id'];

    $title = _("Adding A New Category");

    break;

case CHAIN_MODIFY_CATEGORY:

    if (isset($category_id) && isset($currcategory['id'])) {
        /* Set up the category attributes. */
        $category_title = $currcategory['title'];
        $category_desc = $currcategory['desc'];
        $category_content = $currcategory['content'];
        $category_category = $currcategory['category'];

        $title = _("Modifying:") . ' ' . $category_title;
    } else {
        $title = _("Unknown category");
    }

    break;

case CHAIN_SAVE_CATEGORY:

    /* Get the form values. */
    $category_id = Horde::getFormData('category');
    $category_title = Horde::getFormData('category_title');
    $category_desc = Horde::getFormData('category_desc');
    $category_content = Horde::getFormData('category_content');
    $category_category = Horde::getFormData('category_category');

    /*
     * If $category_id is set, we're modifying an existing category.  Otherwise,
     * we're adding a new category with the provided attributes.
     */
    if ($category_id != "") {
        if (!PEAR::isError($storage->changeCategory($category_id, $category_title,
                           $category_category, $category_desc, $category_content))) {
            $notification->push(_("The category was updated."), 'horde.success');
        } else {
            $notification->push(_("There was a problem updating the category."), 'horde.error');
        }
    } else {
        if (!PEAR::isError($storage->addCategory($category_title, $category_category, $category_desc, $category_content))) {
            $notification->push(_("The category was added."), 'horde.success');
        } else {
            $notification->push(_("There was a problem adding the category."), 'horde.error');
        }
    }

    /* Return to the link list. */
    header('Location: ' . Horde::applicationUrl("list.php", true));
    exit;

    break;

case CHAIN_DELETE_CATEGORY:

    /* Delete the category if we're provided with a valid category ID to delete. */
    $category_id = Horde::getFormData('category');
    if ($category_id) {
        if (!PEAR::isError($storage->removeCategory($category_id))) {
            $notification->push(_("Deleted the category."), 'horde.success');
        } else {
            $notification->push(_("There was a problem deleting the category."), 'horde.error');
        }
    }

    /* Return to the link list. */
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;

    break;

default:
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

$js_onLoad = null;
require CHAIN_TEMPLATES . '/common-header.inc';
require CHAIN_BASE . '/menu.php';
$notification->notify();
require CHAIN_TEMPLATES . '/category/begin.inc';
require CHAIN_TEMPLATES . '/category/category.inc';
require CHAIN_TEMPLATES . '/category/end.inc';
require CHAIN_TEMPLATES . '/common-footer.inc';

$prefs->store();

?>
