<?php
/*
 * $Horde: chain/admin.php,v 1.35 2002/06/12 23:35:21 slusarz Exp $
 *
 * Copyright 2001 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('CHAIN_BASE', dirname(__FILE__));
require_once CHAIN_BASE . '/lib/base.php';
require_once CHAIN_BASE . '/config/html.php';

/* Get the current action ID. Default to NOOP. */
$actionID = Horde::getFormData('actionID', NOOP);

/* Sort out the sorting values. */
if (Horde::getFormData('lsortby', -1) >= 0) {
    $prefs->setValue('lsortby', Horde::getFormData('lsortby'));
}
if (Horde::getFormData('lsortdir', -1) >= 0) {
   $prefs->setValue('lsortdir', Horde::getFormData('lsortdir'));
}

/* Sort out the sorting values. */
if (Horde::getFormData('csortby', -1) >= 0) {
    $prefs->setValue('csortby', Horde::getFormData('csortby'));
}
if (Horde::getFormData('csortdir', -1) >= 0) {
   $prefs->setValue('csortdir', Horde::getFormData('csortdir'));
}

/* Create a Chain storage instance. */
require_once CHAIN_BASE . '/lib/Driver.php';
$storage = &Chain_Driver::factory($conf['storage']['driver'], Auth::getAuth(),
                                $conf['storage']['params']);
$storage->getToday();

/* Get the full, sorted link list. */
$today = Chain::listToday($storage, $prefs->getValue('lsortby'),
                        $prefs->getValue('lsortdir'));

/* Page variables. */
$i = 0;
$js_onLoad = null;
$title = _("Content Listing");


require CHAIN_TEMPLATES . '/common-header.inc';
$notification->notify();
//require CHAIN_TEMPLATES . '/list/javascript.inc';
?>

<table border="0" cellpadding="2" cellspacing="0" width="100%">
<tr>
<td class="menu">
<table border="0">
<tr>
<?php
    require_once HORDE_BASE . '/lib/Menu.php';
    Menu::printItem(Horde::applicationUrl('today.php?actionID=' . CHAIN_ADD_LINK), _("New Link"), 'add.gif');
?>
</tr></table>
</td>
<td align="right" class="menu">
<table border="0" align="right">
<tr>
<?php

/* Horde menu items */
if ($conf['problems']['enabled']) {
    Menu::printItem(Horde::url($registry->getParam('webroot', 'horde') . '/problem.php?return_url=' . urlencode(Horde::url($_SERVER['PHP_SELF'], true))), _("Problem?"), 'problem.gif', $registry->getParam('graphics', 'horde'));
}

/* Online Help */
if ($conf['user']['online_help'] && $browser->hasFeature('javascript')) {
    Menu::printItem(Help::listLink('chain'), _("Help"), 'manual.gif', $registry->getParam('graphics', 'horde'));
}

?>

</tr></table></td></tr></table>

<br />

<table border="0" align="center" width="100%" cellpadding="0" cellspacing="0">
<tr><td class="headersmall" align="center">
<table border="0" width="100%" cellpadding="0" cellspacing="0">
<tr>
    <td align="left" width="5%" class="header">
        <nobr><b>Today@Work</b></nobr>
    </td>
    <td align="right" width="70%" class="smallheader">
        <b><?php echo count($today) == 1 ? _("1 link") : sprintf(_("%d links"), count($today)) ?></b>
    </td>
</tr>
</table>
</td></tr>
</table>
<?php

// echo "<br />";

if (count($today) > 0) {
    echo '<table width="100%" cellspacing=0 cellpadding=0>';
    echo '<tr><td class="control">';
    echo '<table width="100%">';

    foreach ($today as $link_id => $link) {


        echo '<tr class="list">';
        echo '<td>';
        echo Horde::link($link['location'], $link['title'] . ' (' . $link['location'] .
                         '), since ' . date("Y-m-d", $link['date']), '', '_blank');
        echo $link['title'];
        echo '</a>';
        if ($link['desc']) {
            echo ': ' . $link['desc'];
        }
        echo '</td>';
        if (in_array(Auth::getAuth(), $conf['auth']['admins'])) {
            echo '<td width="30" nowrap="nowrap">';
            echo Horde::link(Horde::applicationUrl("today.php?link=$link_id" . "&actionID=" . CHAIN_MODIFY_LINK),
                             _("Edit Link Details"), '', '', '', $link['desc']);
            echo Horde::img('note.gif', _("Edit Link")) . '</a></td>';
        }
        echo '</tr>';

    }

    include CHAIN_TEMPLATES . '/list/link_footers.inc';
}

require CHAIN_TEMPLATES . '/list/footer.inc';

?>

<?php
require CHAIN_TEMPLATES . '/common-footer.inc';

$prefs->store();

?>