# TODO: - linguist in bindir

# David - 3.0.0-0.11mdk - These macros allow to enable some options specific
#                         to a Mandrake Linux distribution
%{expand:%%define buildfor8_0 %(A=$(awk '{print $4}' /etc/mandrake-release); if [ "$A" = 8.0 ]; then echo 1; else echo 0; fi)}
%{expand:%%define buildfor8_1 %(A=$(awk '{print $4}' /etc/mandrake-release); if [ "$A" = 8.1 ]; then echo 1; else echo 0; fi)}
%{expand:%%define buildfor8_2 %(A=$(awk '{print $4}' /etc/mandrake-release); if [ "$A" = 8.2 ]; then echo 1; else echo 0; fi)}
%{expand:%%define buildfor9_0 %(A=$(awk '{print $4}' /etc/mandrake-release); if [ "$A" = 9.0 ]; then echo 1; else echo 0; fi)}
%{expand:%%define buildfor9_1 %(A=$(awk '{print $4}' /etc/mandrake-release); if [ "$A" = 9.1 ]; then echo 1; else echo 0; fi)}
%{expand:%%define buildfor9_2 %(A=$(awk '{print $4}' /etc/mandrake-release); if [ "$A" = 9.2 ]; then echo 1; else echo 0; fi)}
%{expand:%%define buildfor10_0 %(A=$(awk '{print $4}' /etc/mandrake-release); if [ "$A" = 10.0 ]; then echo 1; else echo 0; fi)}

# QTDIR is always /usr/lib/qt3, whether that's a lib64 architecture or
# not (sublibdirs are correctly qualified in the latter case however).
%define qtdir	%{_prefix}/lib/qt3
%if %buildfor9_1 || %buildfor9_2 || %buildfor10_0
%define libname	%mklibname qt 3
%else
%define libname libqt3
%endif

%define useqtcopy 0

%if %useqtcopy
%define nameqt	qt-copy
%else
%define nameqt	qt-x11-free
%endif

# Olivier Thauvin, switch
%define buildSQL 1
%{?_without_SQL: %{expand: %%global buildSQL 0}}

Summary:	Qt3 - Sources
Name: 		qt3
Version:	3.2.3
Release: 	16mdk.Firefly
License:	GPL and QPL
Group:		System/Libraries
URL:		http://www.troll.no/
Packager:	Mandrake Linux KDE Team <kde@mandrakesoft.com>

# David - 3.0.0-0.11mdk - This Qt's version comes from KDE's CVS
Source: 	%nameqt-%version.tar.bz2

# David - 3.0.0-0.11mdk - Set QTDIR
Source1:	qt3-set-QTDIR-environment-csh
Source2:	qt3-set-QTDIR-environment-sh

# David - 3.0.0-0.11mdk - These two files allow users to launch designer and
#                         linguist from orginals KDE and Gnome menus.
#                         They come from debian/ directory in qt-copy (from
#                         KDE's CVS)
Source3:	qt3-designer.desktop
Source4:	qt3-linguist.desktop

# David - 3.0.0-0.11mdk - Properly set designer environment
Source5:	qt3-designer-sh

# David - 3.0.0-0.11mdk - Properly set assistant environment
Source6:	qt3-assistant-sh

# David - 3.0.0-0.11mdk - Properly set uic environment
Source7:	qt3-uic-sh

# David - 3.0.0-0.11mdk - Explain some things to users
Source8:	qt3-README-Mandrake-Linux

# David - 3.0.0-0.11mdk - Set QT_XFT
Source9:	qt3-set-QT_XFT-environment-csh
Source10:	qt3-set-QT_XFT-environment-sh
# Laurent 3.0.2 fix compile
Patch1:		qt-3.0.2-fix-compile.patch.bz2	

# Laurent - 3.0.2-2mdk - fix compile
Patch2:		qt3-3.0.2-fix-compile.patch.bz2

# Laurent - 3.0.3-3mdk fix ksplash crash
Patch3:		qt3-fix-crash-ksplash2.patch.bz2

# Laurent -3.0.5-1mdk fix pyqt compile
Patch4:		qt-3.0.5-fix-pyqt-config.patch.bz2

# Laurent -3.0.5-1mdk fix strip package
Patch5:		qt-3.0.5-fix-strip.patch.bz2	

# Laurent - 3.0.5-3mdk add pablo fix 
Patch6:		qt-3.0.5-fix-lv.patch.bz2

# Laurent - 3.0.5-6mdk - pablo patch fix euro.
Patch7:		qt-3.0.5-fix-euro.patch.bz2

# Laurent - 3.1-7mdk - fix compile with xft2
Patch8:		qt-3.1.1-fix-xft2-compile.patch.bz2


# Laurent -3.1-10mdk fix bidi code patch from lars knoll
Patch10:	qt-3.1-fix-bidi-bug.patch.bz2

# Laurent - 3.1.1-3mdk add redhat patch to see xft font
Patch11:	qt-x11-free-3.1.0-fontdatabase.patch.bz2
Patch12:	qt-x11-free-3.1.1-monospace.patch.bz2

# Laurent - 3.1.1-8mdk - fix dnd flicking when starting a drag
# Remove it after, patch from qt-copy
Patch13:	qt-3.1.1-fix-dnd-flicking.patch.bz2

# Laurent - 3.1.1-11mdk - fix iconview bugs
Patch14:	qt-3.1.1-fix-qiconview-takeitem-bug.patch.bz2

# Laurent - 3.1.1-12mdk - fix xim problem patch from http://www.kde.gr.jp/patch/
Patch15:	qt-x11-free-3.1.1-fix-callPosition-XFilterEvent.diff.bz2

# Laurent - 3.1.1-13mdk - default aa
Patch16:	qt-3.2-use-aa.patch.bz2

Patch17:	qt-3.1.2-fix-undo-redo-signal-in-qmultilineedit.patch.bz2

Patch18:	qt-3.1.2-fix-qsetting-sysconfig.patch.bz2

Patch19:	qt-3.1.2-fix-sysconfig-dir.patch.bz2


Patch21:	qt3-3.1.3-fix-qpsprinter-ttf-font.patch.bz2

############################# qt 3.2.1
Patch30:	qt-3.2.1-fix-kdesktop-crash.patch.bz2


# BIG TEST TO DO ON THIS PATCH 
Patch32:	qt-3.2.1-fix-qiconview-drag-a-little-move.patch.bz2

Patch33:	qt-3.2.1-fix-font-crash.patch.bz2

Patch34:	0031-fix_word_wrapping.diff.bz2

Patch35:	qt-3.2.3-fix-qcanvas-crash.patch.bz2

Patch36:	qt3-break-url-fix.diff.bz2

Patch37:	qt-3.2.3-use-alias-font.patch.bz2

Patch38:	qt-3.2.3-qclipboard_recursion_fix.patch.bz2

Patch39:	qt-3.2.3-dnd-leak.patch.bz2

Patch40:	qt3.2.3-fix_enter_leave_notify.patch.bz2

Patch41:	qt3-qtabwidget-less_flicker.patch.bz2

Patch42:	qt-3.2.3-use-rtl-extension-by-default.patch.bz2

Patch43:	qt-3.2.3-fix-dnd-between-mozilla-and-kde-apps.patch.bz2

Patch44:	qt-x11-free-3.2.1-boldFontList-20030926.patch

Patch45:	qt-x11-free-3.2.2-qfontdatabase-i18n-20031024.patch

Patch46:	qt-x11-free-3.2.3-qpsprinter-useFreeType2-20031128.patch

Patch47:	qt-x11-free-3.2.3-scriptForChar-20031128.patch

Patch48:	qt-3.2.2-fakebold-20031112.patch

Buildroot: 	%_tmppath/%name-%version-%release-root

%if %buildfor8_0
BuildRequires:	db1 db3 freetype2-devel gawk libbzip2_1-devel

%if %buildSQL
BuildRequires:	libunixODBC2-devel MySQL-devel
BuildRequires:	postgresql-devel 
%endif

BuildRequires:	XFree86-devel Mesa-common-devel 
BuildRequires:	XFree86-static-libs zlib1-devel 
%endif

%if %buildfor8_1
BuildRequires:	gcc-c++
BuildRequires:	Mesa-common-devel libmng1-devel libpng2-devel

%if %buildSQL
BuildRequires:  MySQL-devel libunixODBC2-devel postgresql-devel
%endif

BuildRequires:  XFree86-static-libs gawk 
%endif

%if %buildfor8_2

%if %buildSQL
BuildRequires:  MySQL-devel libunixODBC2-devel postgresql-devel
%endif
BuildRequires: XFree86-devel XFree86-libs

BuildRequires:	MySQL-devel XFree86-devel XFree86-libs
BuildRequires:	XFree86-static-libs freetype2-devel gawk libMesaGL1
BuildRequires:	libMesaGLU1-devel libbinutils2 libbzip2_1-devel
BuildRequires: libjpeg-devel liblcms1 libmng1-devel libpng-devel
BuildRequires: libtermcap2 zlib1
%endif

%if %buildfor9_0
%if %buildSQL
BuildRequires:  MySQL-devel libunixODBC2-devel postgresql-devel
%endif
BuildRequires:  freetype2-devel gawk libMesaGL1 XFree86-devel
BuildRequires:  libMesaGLU1-devel libbinutils2 libbzip2_1-devel
BuildRequires:  libjpeg62-devel liblcms1 libmng1-devel libpng3-devel
BuildRequires:  libtermcap2 zlib1 
%endif

%if %buildfor9_1 
%if %buildSQL
BuildRequires:  MySQL-devel libunixODBC2-devel postgresql-devel
%endif
BuildRequires:  freetype2-devel gawk libMesaGL1
BuildRequires:  libMesaGLU1-devel libbinutils libbzip2_1-devel
BuildRequires:  libjpeg-devel liblcms1 libmng1-devel libpng-devel
BuildRequires:  libtermcap2 XFree86-devel
BuildRequires:  zlib1 libXft2-devel libnas2-devel
%endif

%if %buildfor9_2 || %buildfor10_0
%if %buildSQL
BuildRequires:  MySQL-devel unixODBC-devel postgresql-devel
%endif
BuildRequires:  freetype2-devel
BuildRequires:  libMesaGLU-devel bzip2-devel
BuildRequires:  libjpeg-devel libmng-devel libpng-devel
BuildRequires:  XFree86-devel
BuildRequires:  zlib1-devel Xft-devel nas-devel
%endif

%description
Qt is a complete and well-designed multi-platform object-oriented framework for
developing graphical user interface (GUI) applications using C++. Qt has
seamless integration with OpenGL/Mesa 3D libraries.

Qt is free for development of free software on the X Window System. It includes
the complete source code for the X version and makefiles for Linux, Solaris,
SunOS, FreeBSD, OSF/1, Irix, BSD/OS, NetBSD, SCO, HP-UX and AIX. This edition
of Qt may be modified and distributed under the terms found in the LICENSE.QPL
file.

Qt also supports Windows 95 and NT, with native look and feel. Code developed
for the X version of Qt can be recompiled and run using the Windows 95/NT
version of Qt, and vice versa.

Qt is currently used in hundreds of software development projects world wide,
including the K Desktop Environment (see http://www.kde.org). For more
examples, see http://www.trolltech.com/qtprogs.html.

Qt has excellent documentation: around 750 pages of postscript and fully
cross-referenced online html documentation. It is available on the web:
http://doc.trolltech.com/

Qt is easy to learn, with consistent naming across all the classes and a
14-chapter on-line tutorial with links into the rest of the documentation.
A number of 3rd-party books are also available.

Qt dramatically cuts down on development time and complexity in writing
user interface software for the X Window System. It allows the programmer
to focus directly on the programming task, and not mess around with
low-level Motif/X11 code.

Qt is fully object-oriented. All widgets and dialogs are C++ objects,
and, using inheritance, creation of new widgets is easy and natural.

Qt's revolutionary signal/slot mechanism provides true component
programming. Reusable components can work together without any knowledge
of each other, and in a type-safe way.

Qt has a very fast paint engine, in some cases ten times faster than other
toolkits. The X version is based directly on Xlib and uses neither
Motif nor X Intrinsics.

Qt is available under two different licenses:
  - The Qt Professional Edition License, for developing fully commercial
    software: see http://www.trolltech.com/pricing.html
  - The Q Public License (QPL), for developing free software (X Window System
    only).


%package -n %libname
Summary:        Qt3 - Shared libraries
Group:          System/Libraries
Requires:	%{name}-common = %version-%release

%description -n %libname
Qt is a complete and well-designed multi-platform object-oriented framework for
developing graphical user interface (GUI) applications using C++. Qt has
seamless integration with OpenGL/Mesa 3D libraries.

Qt is free for development of free software on the X Window System. It includes
the complete source code for the X version and makefiles for Linux, Solaris,
SunOS, FreeBSD, OSF/1, Irix, BSD/OS, NetBSD, SCO, HP-UX and AIX. This edition
of Qt may be modified and distributed under the terms found in the LICENSE.QPL
file.

Qt also supports Windows 95 and NT, with native look and feel. Code developed
for the X version of Qt can be recompiled and run using the Windows 95/NT
version of Qt, and vice versa.

Qt is currently used in hundreds of software development projects world wide,
including the K Desktop Environment (see http://www.kde.org). For more
examples, see http://www.trolltech.com/qtprogs.html.

Qt has excellent documentation: around 750 pages of postscript and fully
cross-referenced online html documentation. It is available on the web:
http://doc.trolltech.com/

Qt is easy to learn, with consistent naming across all the classes and a
14-chapter on-line tutorial with links into the rest of the documentation.
A number of 3rd-party books are also available.

Qt dramatically cuts down on development time and complexity in writing
user interface software for the X Window System. It allows the programmer
to focus directly on the programming task, and not mess around with
low-level Motif/X11 code.

Qt is fully object-oriented. All widgets and dialogs are C++ objects,
and, using inheritance, creation of new widgets is easy and natural.

Qt's revolutionary signal/slot mechanism provides true component
programming. Reusable components can work together without any knowledge
of each other, and in a type-safe way.

Qt has a very fast paint engine, in some cases ten times faster than other
toolkits. The X version is based directly on Xlib and uses neither
Motif nor X Intrinsics.

Qt is available under two different licenses:
  - The Qt Professional Edition License, for developing fully commercial
    software: see http://www.trolltech.com/pricing.html
  - The Q Public License (QPL), for developing free software (X Window System
    only).

This package contains shared libraries. 


%package -n %libname-devel
Summary: 	Qt3 - Documentation and files needed to build Qt3 based applications
Group: 		Development/KDE and Qt
Requires:	%libname = %version-%release
Requires:	XFree86-devel
Provides:	libqt-devel = %{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}


# David - 3.0.0-0.11-mdk - Rpmlint want a 'Provides: libqt-devel' here. We don't
#                          provide it because there is a high risk to confuse
#                          some old packages

%description -n %libname-devel
Qt is a complete and well-designed multi-platform object-oriented framework for
developing graphical user interface (GUI) applications using C++. Qt has
seamless integration with OpenGL/Mesa 3D libraries.

Qt is free for development of free software on the X Window System. It includes
the complete source code for the X version and makefiles for Linux, Solaris,
SunOS, FreeBSD, OSF/1, Irix, BSD/OS, NetBSD, SCO, HP-UX and AIX. This edition
of Qt may be modified and distributed under the terms found in the LICENSE.QPL
file.

Qt also supports Windows 95 and NT, with native look and feel. Code developed
for the X version of Qt can be recompiled and run using the Windows 95/NT
version of Qt, and vice versa.

Qt is currently used in hundreds of software development projects world wide,
including the K Desktop Environment (see http://www.kde.org). For more
examples, see http://www.trolltech.com/qtprogs.html.

Qt has excellent documentation: around 750 pages of postscript and fully
cross-referenced online html documentation. It is available on the web:
http://doc.trolltech.com/

Qt is easy to learn, with consistent naming across all the classes and a
14-chapter on-line tutorial with links into the rest of the documentation.
A number of 3rd-party books are also available.

Qt dramatically cuts down on development time and complexity in writing
user interface software for the X Window System. It allows the programmer
to focus directly on the programming task, and not mess around with
low-level Motif/X11 code.

Qt is fully object-oriented. All widgets and dialogs are C++ objects,
and, using inheritance, creation of new widgets is easy and natural.

Qt's revolutionary signal/slot mechanism provides true component
programming. Reusable components can work together without any knowledge
of each other, and in a type-safe way.

Qt has a very fast paint engine, in some cases ten times faster than other
toolkits. The X version is based directly on Xlib and uses neither
Motif nor X Intrinsics.

Qt is available under two different licenses:
  - The Qt Professional Edition License, for developing fully commercial
    software: see http://www.trolltech.com/pricing.html
  - The Q Public License (QPL), for developing free software (X Window System
    only).

This package contains:
  - files needed to build Qt based applications
  - designer, assistant and linguist applications
  - documentation, examples and tutorials

%package common
Summary:	config, language file for Qt
Group:      Development/KDE and Qt
Requires:   %libname = %version
Obsoletes:	libqt3-common
Provides:	libqt3-common = %{version}-%{release}

%description common
This package contains all config file and language file

%if %buildSQL
%package -n %libname-mysql
Summary: 	MySQL plugin for Qt
Group: 		Development/KDE and Qt
Requires:	%libname = %version-%release
Provides:	%{name}-MySQL = %{version}-%{release}


%description -n %libname-mysql
This package contain the MySQL plugin for Qt.

%package -n %libname-psql
Summary: 	PostgresSQL plugin for Qt
Group: 		Development/KDE and Qt
Requires:	%libname = %version-%release
Provides:	%{name}-PostgreSQL = %{version}-%{release}


%description -n %libname-psql
This package contain the PostgresSQL plugin for Qt.

%package -n %libname-odbc
Summary: 	ODBC plugin for Qt
Group: 		Development/KDE and Qt
Requires:	%libname = %version-%release
Provides:	%{name}-ODBC = %{version}-%{release}

%description -n %libname-odbc
This package contain the ODBC plugin for Qt.

%endif


%package example
Summary:    Qt examples.
Group:      Development/KDE and Qt
Requires:   %libname = %version-%release
Obsoletes:  libqt3-example
Provides:   libqt3-example

%description example
This package contain Qt example.

%prep


%setup -q -n %nameqt-%version
#patch2 -p1
#%patch3 -p1
#%patch4 -p1
#%patch5 -p1
%patch7 -p1
%if %buildfor9_1 || %buildfor9_2 || %buildfor10_0
%patch8 -p1
#REapply 11 -12
#%patch11 -p1
#%patch12 -p1
%endif

# reapply
%patch16 -p1 -b .use_aa_by_default


#%patch18 -p1
#%patch19 -p1

############################"FIXME
#%patch21 -p1 -b .fix_qpsprinter_ttf

################################FIXME
#%patch30 -p1 -b .fix_kdesktop_crash


%patch32 -p1 -b .fix_dnd_qiconview_little
##################"FIXME
#%patch33 -p1 -b .fix_font_crash_bug

#%patch34 -p1 -b .dont_wrap_url

%patch35 -p1 -b .fix_crash_in_qcanvas

%patch36 -p1 -b .fix_url_wrap_in_ktextview

%patch37 -p1 -b .alias_font

%patch38 -p1 -b .fix_clipboard_recursion

%patch39 -p1 -b .fix_dnd_mem_leak

%patch40 -p1 -b .fix_mouse_policy_with_kwin3

%patch41 -p1 -b .less_flicking_when_change_tab

%patch42 -p1 -b .use_rtl_extension_by_default

%patch43 -p1 -b .fix_dnd_between_mozilla_and_kde

%patch44 -p1 -b .Akito01

%patch45 -p1 -b .Akito02

%patch46 -p1 -b .Akito03

%patch47 -p1 -b .Akito04

%patch48 -p1 -b .Firefly

%build

export QTDIR=$(/bin/pwd)
export PATH=$QTDIR/bin:$PATH
export MANPATH=$QTDIR/doc/man:$MANPATH
export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH

%if %useqtcopy
make -f Makefile.cvs
%endif

# David - 3.0.0-0.11mdk - Use optimizations.
perl -pi -e "s|^QMAKE_CFLAGS_RELEASE	= -O2|QMAKE_CFLAGS_RELEASE	= %optflags|" mkspecs/linux-g++/qmake.conf

# David - 3.0.0-0.11mdk - Remove rpath.
perl -pi -e "s|^QMAKE_RPATH		= -Wl,-rpath,|QMAKE_RPATH		= |" mkspecs/linux-g++/qmake.conf

# Gwenole - 3.0.5-2mdk - lib64 fixes
perl -pi -e "s@^(QMAKE_LIBDIR_(X11|QT|OPENGL)\s+=\s+.*)/lib@\1/%_lib@" mkspecs/linux-g++/qmake.conf

# David - 3.0.0-0.11mdk - We only need shared/threaded libraries on a Mandrake
#                         Linux system
./configure -I/usr/include/pgsql/ -I/usr/include/pgsql/server/ -I/usr/include/fontconfig -I/usr/include/Xft2 -I/usr/include/Xft2/X11/Xft -I/usr/include/mysql/ \
            -prefix %qtdir/ \
            -libdir %qtdir/%_lib \
			-sysconfdir %_sysconfdir \
	    -docdir %_docdir/qt-%version/doc/ \
	    -release \
            -shared \
	    -qt-gif \
	    -system-zlib \
	    -system-nas-sound \
            -no-g++-exceptions \
	    -platform linux-g++ \
            -enable-tools \
            -enable-kernel \
            -enable-widgets \
            -enable-dialogs \
            -enable-iconview \
            -enable-workspace \
            -enable-network \
            -enable-canvas \
            -enable-table \
            -enable-xml \
	    -enable-opengl \
%if %buildSQL		
            -enable-sql \
            -plugin-sql-mysql \
            -plugin-sql-odbc \
            -plugin-sql-psql \
%endif			
	    -plugin-style-cde \
	    -plugin-style-compact \
	    -plugin-style-motif \
	    -plugin-style-sgi \
		-plugin-style-platinum \
		-plugin-style-motifplus \
	    -thread \
            -stl \
	    -qt-imgfmt-png \
	    -qt-imgfmt-jpeg \
	    -qt-imgfmt-mng  \
	    -system-libpng \
	    -system-libjpeg \
	    -system-libmng \
	    -sm \
	    -xinerama \
	    -xrender \
		-xrandr \
		-xcursor \
	    -xft \
		-nis \
	    -no-tablet \
		-v \
	    -xkb <<EOF
yes
EOF

# David - 3.0.0-0.11mdk - We only provide tutorials and example for as
#                         documentation, so spend time to build them means
#                         lost time
%make 


%install
export QTDIR=$(/bin/pwd)
export PATH=$QTDIR/bin:$PATH
export MANPATH=$QTDIR/doc/man:$MANPATH
export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
rm -fr %buildroot

# David - 3.0.0-0.11mdk - Work around for a broken make install
install -d -m 0755 %buildroot/%qtdir/


make install INSTALL_ROOT=%buildroot/


# David - 3.0.0-0.11mdk - Add SQL plugins (broken make install...)
install -d -m 0755 %buildroot/%qtdir/plugins/sqldrivers/
#install -m 0755 $RPM_BUILD_DIR/qt-x11-free-3.1.0/plugins/sqldrivers/*.so %buildroot/%qtdir/plugins/sqldrivers/


# David - 3.0.0-0.11mdk - Fix some bad symlinks
cd %buildroot/%qtdir/%_lib/
#ln -sf libeditor.so.1.0.0 libeditor.so
#ln -sf libeditor.so.1.0.0 libeditor.so.1.0
ln -sf libqt-mt.so.%version  libqt-mt.so
ln -sf libqt-mt.so.%version  libqt-mt.so.3.2
ln -sf libqui.so.1.0.0    libqui.so
ln -sf libqui.so.1.0.0    libqui.so.1.0
cd -


# David - 3.0.0-0.11mdk - Install missing documentation
install -d -m 0755 %buildroot/%_docdir/qt-%version/
#install -m 0644 $RPM_BUILD_DIR/qt-x11-free-%version/ANNOUNCE  %buildroot/%_docdir/qt-%version/
install -m 0644 $RPM_BUILD_DIR/%nameqt-%version/FAQ       %buildroot/%_docdir/qt-%version/
install -m 0644 $RPM_BUILD_DIR/%nameqt-%version/LICENSE*  %buildroot/%_docdir/qt-%version/
install -m 0644 $RPM_BUILD_DIR/%nameqt-%version/README    %buildroot/%_docdir/qt-%version/
install -m 0644 $RPM_BUILD_DIR/%nameqt-%version/README-QT.TXT %buildroot/%_docdir/qt-%version/
#install -m 0644 $RPM_BUILD_DIR/qt-%version/changes*  %buildroot/%_docdir/qt-%version/


# David - 3.0.0-0.11mdk - Install a README for Mandrake Linux
install -m 0644 %SOURCE8 %buildroot/%_docdir/qt-%version/README.Mandrake_Linux
perl -pi -e "s|QtVersion|%version|" %buildroot/%_docdir/qt-%version/README.Mandrake_Linux
perl -pi -e "s|QtVersion|%version|" %buildroot/%_docdir/qt-%version/README.Mandrake_Linux
perl -pi -e "s|PackageVersion|%version-%release|" %buildroot/%_docdir/qt-%version/README.Mandrake_Linux
perl -pi -e "s|PackageVersion|%version-%release|" %buildroot/%_docdir/qt-%version/README.Mandrake_Linux


# David - 3.0.0-0.11mdk - Install man pages
install -d -m 0755 %buildroot/%_mandir/man1/
for i in $RPM_BUILD_DIR/%nameqt-%version/doc/man/man1/* ; do
		if [ ! -d $i ] ; then
		   install -m 0644 $i %buildroot/%_mandir/man1/
		fi
done
#
install -d -m 0755 %buildroot/%_mandir/man3/
for i in $RPM_BUILD_DIR/%nameqt-%version/doc/man/man3/* ; do
	    if [ ! -d $i ] ; then
   			install -m 0644 $i %buildroot/%_mandir/man3/
	    fi
done

install -d -m 0755 %buildroot/%_bindir/
install -m 0755 $RPM_BUILD_DIR/%nameqt-%version/bin/moc %buildroot/%qtdir/bin/moc

# David - 3.0.1-2mdk - Install .pri files needed to build examples and tutorials
install -d -m 0755 %buildroot/%qtdir/src/
for i in $RPM_BUILD_DIR/%nameqt-%version/src/*.pri; do
   install -m 0644 $i %buildroot/%qtdir/src/
done


## David - 3.0.0-0.11mdk - Examples and tutorial
# David - 3.0.0-0.11mdk - Provide a qmake.cache for examples
cp -ar $RPM_BUILD_DIR/%nameqt-%version/examples/ %buildroot/%_docdir/qt-%version
cp -p $RPM_BUILD_DIR/%nameqt-%version/.qmake.cache %buildroot/%_docdir/qt-%version/examples/
perl -pi -e "s|^QT_SOURCE_TREE.*|QT_SOURCE_TREE = %qtdir|" %buildroot/%_docdir/qt-%version/examples/.qmake.cache
perl -pi -e "s|^QT_BUILD_TREE.*|QT_BUILD_TREE = %qtdir|" %buildroot/%_docdir/qt-%version/examples/.qmake.cache
perl -pi -e "s|^QT_PREFIX=.*|QT_PREFIX=%qtdir|" %buildroot/%_docdir/qt-%version/examples/.qmake.cache
perl -pi -e "s|^docs.path=.*|docs.path=%_docdir/qt-%version/doc/html|" %buildroot/%_docdir/qt-%version/examples/.qmake.cache
perl -pi -e "s|^headers.path=.*|headers.path=%_includedir/qt3|" %buildroot/%_docdir/qt-%version/examples/.qmake.cache
perl -pi -e "s|^QT_INSTALL_LIBPATH=.*|QT_INSTALL_LIBPATH=%_libdir|" %buildroot/%_docdir/qt-%version/examples/.qmake.cache
perl -pi -e "s|^QT_INSTALL_BINPATH=.*|QT_INSTALL_BINPATH=%_bindir|" %buildroot/%_docdir/qt-%version/examples/.qmake.cache

# David - 3.0.0-0.11mdk - Provide a qmake.cache for tutorial
cp -ar $RPM_BUILD_DIR/%nameqt-%version/tutorial/ %buildroot/%_docdir/qt-%version
cp -p %buildroot/%_docdir/qt-%version/examples/.qmake.cache %buildroot/%_docdir/qt-%version/tutorial/.qmake.cache

# David - 3.0.0-0.11mdk - Set qmake.cache to right directory
find %buildroot/%_docdir/qt-%version/{examples,tutorial} -name Makefile | xargs perl -pi -e "s|../.qmake.cache|.qmake.cache|"
#find %buildroot/%_docdir/qt-%version/{examples,tutorial} -name Makefile | xargs perl -pi -e "s|../../.qmake.cache|../.qmake.cache|"

# David - 3.0.0-0.11mdk - Fix include directory for examples
find %buildroot/%_docdir/qt-%version/examples -name Makefile | xargs perl -pi -e "s|../../../include|%qtdir/include|"

# David - 3.0.0-0.11mdk - Fix include directory for examples
find %buildroot/%_docdir/qt-%version/examples -name Makefile | xargs perl -pi -e "s|../../include|%qtdir/include|"

# David - 3.0.1-2mdk - Fix lib directory for examples
find %buildroot/%_docdir/qt-%version/{examples,tutorial} -name Makefile | xargs perl -pi -e "s|../../../../lib/libqt-mt.prl|%qtdir/%_lib/libqt-mt.prl|"
find %buildroot/%_docdir/qt-%version/{examples,tutorial} -name Makefile | xargs perl -pi -e "s|../../../lib/libqt-mt.prl|%qtdir/%_lib/libqt-mt.prl|"
find %buildroot/%_docdir/qt-%version/{examples,tutorial} -name Makefile | xargs perl -pi -e "s|../../lib/libqt-mt.prl|%qtdir/%_lib/libqt-mt.prl|"

find %buildroot/%_docdir/qt-%version/{examples,tutorial} -name Makefile | xargs perl -pi -e "s|../../src/qt_professional.pri|%qtdir/src/qt_professional.pri|"

# David - 3.0.0-0.11mdk - Set RPM_BUILD_DIR to QTDIR
find %buildroot/%_docdir/qt-%version/{examples,tutorial} -name Makefile | xargs perl -pi -e "s|$RPM_BUILD_DIR/qt-%version|%qtdir|"

# David - 3.0.1-2mdk - Explain in examples README that QTDIR need to be set
#                      before try to build one of them
cd %buildroot/%_docdir/qt-%version/examples/
cat README > README.tmp
echo "Before try to build one of these examples, you need to:" > README
echo "" >> README
echo "export QTDIR=\"/usr/lib/qt3/\"" >> README
echo "" >> README
echo "" >> README
cat README.tmp >> README
rm -f README.tmp
cd -

# David - 3.0.1-2mdk - Fix PATH to tutorial.html in tutorials README
perl -pi -e "s|../doc/html/tutorial.html|%_docdir/qt-%version/doc/html/tutorial.html|" %buildroot/%_docdir/tutorial/README

# David - 3.0.1-2mdk - Explain in tutorials README that QTDIR need to be set
#                      before try to build one of them
cd %buildroot/%_docdir/qt-%version/tutorial/
cat README > README.tmp
echo "Before try to build one of these examples, you need to:" > README
echo "" >> README
echo "export QTDIR=\"/usr/lib/qt3/\"" >> README
echo "" >> README
echo "" >> README
cat README.tmp >> README
rm -f README.tmp
cd -

# David - 3.0.0-0.11mdk - Install examples. They are usefull only for people who
#                         want learn to use Qt. We assume they are rarely used
#                         So, we can compress them to save space.
cd %buildroot/%_docdir/qt-%version/
tar jcf %buildroot/%_docdir/qt-%version/examples.tar.bz2 examples/
rm -fr examples/
cd -

# David - 3.0.0-0.11mdk - Install tutorial. It is usefull only for people who
#                         want learn to use Qt. We assume it is rarely used.
#                         So, we can compress it to save space.
cd %buildroot/%_docdir/qt-%version/
tar jcf %buildroot/%_docdir/qt-%version/tutorial.tar.bz2 tutorial/
rm -fr tutorial/
cd -

cd %buildroot/usr/bin
ln -s ../../%qtdir/bin/qtconfig qtconfig
cd -

# David - 3.0.0-0.11mdk - Create a fake QTDIR (because Qt doesn't care of FHS
#                         and want all its directories in its own directory...)
cd %buildroot/%qtdir/
install -d -m 0755 doc
ln -s ../../../share/doc/qt-%version/doc/html/ doc/html
cd -


# David - 3.0.0-0.11mdk - Install needed files to automatically set QTDIR
#                         (because Qt doesn't care of FHS and want all its
#                         directories in its own directory...)
install -d -m 0755 %buildroot/%_sysconfdir/profile.d/
install -m 0755 %SOURCE1 %buildroot/%_sysconfdir/profile.d/qtdir3.csh
install -m 0755 %SOURCE2 %buildroot/%_sysconfdir/profile.d/qtdir3.sh


# David - 3.0.0-0.11mdk - Automatically set QT_XFT
#install -m 0755 %SOURCE9 %buildroot/%_sysconfdir/profile.d/qtxft3.csh
#install -m 0755 %SOURCE10 %buildroot/%_sysconfdir/profile.d/qtxft3.sh


# David - 3.0.0-0.11mdk - Be sure designer is launched using the right environment
mv %buildroot/%qtdir/bin/designer %buildroot/%qtdir/bin/designer-real
install -m 0755 %SOURCE5 %buildroot/%qtdir/bin/designer

# David - 3.0.1-2mdk - To allow designer to be lauched from PATH
install -d -m 0755 %buildroot/%_bindir/
cd %buildroot/%_bindir/
ln -s ../lib/qt3/bin/designer designer-qt3
cd -


# David - 3.0.0-0.11mdk - Be sure qmake is launched using the right environment
install -m 0755 %SOURCE6 %buildroot/%_bindir/assistant


# David - 3.0.1-6mdk - Be sure /usr/lib/qt3/mkspecs/default point on right
#                      directory
cd %buildroot/%qtdir/mkspecs/
rm -rf default
ln -sf linux-g++ default
cd -

# David - 3.0.0-0.11mdk - Install designer and linguist .desktop files for Gnome
install -d -m 0755 %buildroot/%_datadir/gnome/apps/Development/
install -m 0644 %SOURCE3 %buildroot/%_datadir/gnome/apps/Development/designer.desktop
install -m 0644 %SOURCE4 %buildroot/%_datadir/gnome/apps/Development/linguist.desktop


# David - 3.0.0-0.11mdk - Install designer and linguist .desktop files for KDE
install -d -m 0755 %buildroot/%_datadir/applnk/Development/
install -m 0644 %SOURCE3 %buildroot/%_datadir/applnk/Development/designer.desktop
install -m 0644 %SOURCE4 %buildroot/%_datadir/applnk/Development/linguist.desktop


## David - 3.0.0-0.11mdk - Install menu entries
install -d -m 0755 %buildroot/%_menudir/

# David - 3.0.0-0.11mdk - Install assistant menu entry
cat <<EOF > %buildroot/%_menudir/libqt3-devel-assistant
?package(libqt3-devel): needs=X11 \
                         section="Documentation" \
			 title="Qt3 Assistant" \
			 longtitle="A manual browser for Qt3 documentation" \
			 command="%_bindir/assistant" \
			 icon="documentation_section.png"
EOF

# David - 3.0.0-0.11mdk - Install designer menu entry
cat <<EOF > %buildroot/%_menudir/libqt3-devel-designer
?package(libqt3-devel): needs=X11 \
                        section="Applications/Development/Development environments" \
			title="Qt3 Designer" \
			longtitle="A graphical designer/dialog builder for Qt3" \
			command="/usr/bin/designer-qt3" \
			icon="development_environment_section.png"
EOF

# David - 3.0.0-0.11mdk - Install linguist menu entry
cat <<EOF > %buildroot/%_menudir/libqt3-devel-linguist
?package(libqt3-devel): needs=X11 \
                        section="Applications/Development/Development environments" \
			title="Qt Linguist" \
			longtitle="A translation tool for Qt3" \
			command="%qtdir/bin/linguist" \
			icon="development_environment_section.png"
EOF



%clean
rm -fr %buildroot



%post -n %libname
grep -q "^%qtdir/%_lib$" /etc/ld.so.conf || echo "%qtdir/%_lib" >> /etc/ld.so.conf
/sbin/ldconfig

%postun -n %libname
if [ "$1" = "0" ]; then
   rm -f /etc/ld.so.conf.new
   grep -v -e "%qtdir/%_lib" /etc/ld.so.conf > /etc/ld.so.conf.new
   mv -f /etc/ld.so.conf.new /etc/ld.so.conf
fi
/sbin/ldconfig

%post -n %libname-devel
/sbin/ldconfig
%update_menus

%postun -n %libname-devel
/sbin/ldconfig
%clean_menus



%files -n %libname
%defattr(-,root,root,-)
#
#
#
%dir %qtdir/
%dir %qtdir/%_lib/
%qtdir/%_lib/libqt-mt.so.3
%qtdir/%_lib/libqt-mt.so.3.2
%qtdir/%_lib/libqt-mt.so.%version
%qtdir/%_lib/libqt-mt.la
%qtdir/%_lib/libqui.so.1
%qtdir/%_lib/libqui.so.1.0
%qtdir/%_lib/libqui.so.1.0.0
%qtdir/%_lib/*.prl


%qtdir/%_lib/libdesignercore.a
%qtdir/%_lib/libeditor.a
%qtdir/%_lib/libqassistantclient.a

%dir %qtdir/plugins/styles/
%qtdir/plugins/styles/*style.so


%files common
%defattr(-,root,root,-)
%dir %qtdir/plugins

%if %buildSQL
%dir %qtdir/plugins/sqldrivers
%endif

%dir %qtdir/phrasebooks/
%qtdir/phrasebooks/*.qph

%dir %qtdir/
%dir %qtdir/bin
%qtdir/bin/qtconfig

%_sysconfdir/profile.d/*.csh
%_sysconfdir/profile.d/*.sh
	  
%dir %qtdir/translations/
%qtdir/translations/*.qm

				  

%files -n %libname-devel
%defattr(-,root,root,-)
%dir %_docdir/qt-%version/
%doc %_docdir/qt-%version/FAQ
%doc %_docdir/qt-%version/LICENSE*
%doc %_docdir/qt-%version/README*
#
#
%dir %_docdir/qt-%version/doc/
%dir %_docdir/qt-%version/doc/html/
%doc %_docdir/qt-%version/doc/html/*
#
#
#
%doc %_mandir/man1/*
#
#
%doc %_mandir/man3/*
#
#
#
%_bindir/*
#

%qtdir/%_lib/libqui.so
%qtdir/%_lib/libqt-mt.so
#
%_menudir/*
#
%dir %qtdir/%_lib/pkgconfig/
%qtdir/%_lib/pkgconfig/*.pc
#
%dir %_datadir/applnk/
%dir %_datadir/applnk/Development/
%_datadir/applnk/Development/*.desktop
#
#
#
%dir %_datadir/gnome/
%dir %_datadir/gnome/apps/
%dir %_datadir/gnome/apps/Development/
%_datadir/gnome/apps/Development/*.desktop
#
#
#
%dir %qtdir/
%dir %qtdir/bin
%qtdir/bin/assistant  
%qtdir/bin/designer-real  
%qtdir/bin/lrelease  
%qtdir/bin/moc    
%qtdir/bin/qmake     
%qtdir/bin/uic
%qtdir/bin/designer   
%qtdir/bin/linguist       
%qtdir/bin/lupdate   
%qtdir/bin/qm2ts  
#%qtdir/bin/qtconfig


%dir %qtdir/include
%qtdir/include/*
#
#
%dir %qtdir/doc/
%qtdir/doc/html
#
#
%dir %qtdir/mkspecs/
%qtdir/mkspecs/*
#
#
%dir %qtdir/src/
%qtdir/src/*
#
#
%dir %qtdir/templates/
%qtdir/templates/*.ui
#
#
%dir %qtdir/plugins/designer
%qtdir/plugins/designer/*


%if %buildSQL
%files -n %libname-mysql
%defattr(-,root,root)
%qtdir/plugins/sqldrivers/libqsqlmysql.so

%files -n %libname-psql
%defattr(-,root,root)
%qtdir/plugins/sqldrivers/libqsqlpsql.so

%files -n %libname-odbc
%defattr(-,root,root)
%qtdir/plugins/sqldrivers/libqsqlodbc.so

%endif

%files example
%defattr(-,root,root)
%doc %_docdir/qt-%version/*.bz2

%changelog
* Thu Mar 04 2004 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-16mdk
- Add patch43: fix dnd between mozilla and kde application

* Mon Mar 01 2004 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-15mdk
- fix link

* Mon Mar 01 2004 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-14mdk
- create link for qtconfig to /usr/bin
- Add patch42: use rtl extension by default

* Tue Feb 10 2004 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-13mdk
- Fix sync into cooker

* Mon Feb 02 2004 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-12mdk
- Rebuild

* Fri Jan 23 2004 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-11mdk
- Remove windows plugins

* Fri Jan 23 2004 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-10mdk
- Add patch41: less flicker into tabwidget

* Thu Jan 22 2004 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-9mdk
- Add patch38: fix clipboard recursion crash
- Add patch39: fix dnd mem leak
- Add patch40: fix mouse policy (fix for kwin3)

* Wed Jan 14 2004 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-8mdk
- Add patch37: readd alias font for monospace/Sans/

* Thu Jan 08 2004 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-7mdk
- Rebuild with new kdelibs

* Thu Dec 04 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-6mdk
- Rebuild

* Wed Nov 26 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-5mdk
- Add patch37: fix qscrollview in bidi mode

* Mon Nov 24 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-4mdk
- add patch36: fix url wrap in ktextview

* Thu Nov 20 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-3mdk
- Add patch35 : fix crash into qcanvas

* Fri Nov 14 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-2mdk
- USe official qt-3.2-3 release

* Wed Nov 12 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.3-1mdk
- Use qt-copy, sync with qt-3.2.3 snapshot

* Fri Nov 07 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.2-5mdk
- Fix compile

* Tue Nov 04 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.2-4mdk
- Add patch33: don't wrap url into textview

* Tue Nov 04 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.2-3mdk
- Fix conflict with cooker

* Fri Oct 24 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.2-2mdk
- Fix soname

* Thu Oct 16 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.2-1mdk
- 3.2.2

* Tue Oct 14 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.1-7mdk
- Fix crash

* Fri Oct 10 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.1-6mdk
- Fix some configure parameter

* Mon Sep 29 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.2.1-5mdk
- Add patch32 : fix qiconviewitem make a little drag
- Fix xft
- Add debug
- Fix crash in kdesktop
- qt-3.2.1

* Fri Sep 26 2003 Pablo Saratxaga <pablo@@mandrakesoft.com> 3.1.2-15mdk
- changed default XIM mode to "Over the Spot"; it is a much safer default

* Sat Aug 30 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-14mdk
- Fix print document with TTF with space into font name

* Tue Aug 19 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-13mdk
- Rebuild with kde widget support


* Tue Aug 05 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-12mdk
- Further fixes to BuildRequires (Gwenole Beauchesne)
- Provides: qt3-{MySQL,ODBC,PostgreSQL} (Gwenole Beauchesne)
- Package qt3-{common,examples} (Gwenole Beauchesne)

* Thu Jul 31 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-11mdk
- Fix requires for 9.2

* Tue Jul 08 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-10mdk
- Rebuild
- Fix depend

* Wed Jul 02 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-9mdk
- Add nas support

* Tue Jul 01 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-8mdk
- Split package move  example.tar.bz2 to qt-example

* Thu Jun 12 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-7mdk
- Add patch20: fix qlistview "drop and drag multiple files in detailed text mode view when using the konqueror file manager." patch found in kde-devel by Texstar <texstar@houston.rr.com> approved by TT.
- Add patch from Olivier Thauvin, add switch --without SQL

* Mon Jun 02 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-6mdk
- Patch qt to support -sysconfigdir parameter

* Mon Jun 02 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-5mdk
- Remove Source9-Source10 (bug reported by David Faure) not used by qt

* Mon May 26 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-4mdk
- Rebuidl

* Wed Apr 30 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-3mdk
- Fix requires

* Wed Apr 16 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-2mdk
- Add patch17: fix undo/redo in qtextedit => fix undo/redo in knode editor

* Tue Mar 18 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.2-1mdk
- 3.1.2

* Mon Feb 24 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.1-13mdk
- Add patch13: AA by default

* Tue Feb 18 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.1-12mdk
- Add patch12: fix xim problem

* Mon Feb 17 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.1-11mdk
- Add patch11 : fix iconview bug when we use takeitem function

* Sun Feb 16 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.1-10mdk
- Move qtconfig to libqt3-common

* Fri Feb 07 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.1-9mdk
- Rebuild

* Thu Jan 30 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.1-8mdk
- Add patch13 : Reduces flicker when starting a drag.

* Tue Jan 28 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.1-7mdk
- Fix compile under MDK9.0/8.2
- Fix group bug reported by Titi

* Thu Jan 23 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.1-6mdk
- Fix : remove link to libeditor.so

* Fri Jan 17 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.1-5mdk
- change libqt3-datafiles -> libqt3-common

* Thu Jan 16 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.1-4mdk
- Use %%mklibname make happy gb
- Spit again qt to make happy gb

* Thu Jan 16 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.1-3mdk
- Add patch11-12 from redhat

* Tue Jan 14 2003 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.1-2mdk
- Rebuild.

* Tue Dec 17 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.1-1mdk
- qt 3.1.1

* Tue Nov 26 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.0-7mdk
- Add patch 10 patch from Lars Knoll bug reported by Diego Iastrubni <iastrubn@actcom.co.il>

* Tue Nov 26 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.0-6mdk
- Apply patch from Guillaume Rousse <g.rousse@linux-mandrake.com>
	- %libname-mysql, %libname-psql and %libname-odbc subpackage to reduce dependencies
	- more macros
	- using both a PreReq and Requires for the same package is redundant
	- removed redundant libs packages in buildrequires
	- buildrequires libXft2-devel ( just for MDK9.1 )

* Sat Nov 23 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.0-5mdk
- Fix doc

* Mon Nov 18 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.0-4mdk
- Fix compile with xft2

* Sun Nov 17 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.0-3mdk
- Fix compile under MDK9.0-8.2

* Wed Nov 13 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.0-2mdk
- Add patch9 : Fix qwidget bug : "It fixes child windows being hidden randomly."

* Wed Nov 13 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.0-1mdk
- final

* Wed Nov 06 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.0-0.beta2.4mdk
- Add patch8 : fix compile with xft2

* Tue Nov 05 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.0-0.beta2.3mdk
- Update code from qt-copy for kde3.1-rc2

* Mon Nov 04 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.1.0-0.beta2.2mdk
- Fix moc location

* Fri Sep 13 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.5-7mdk
- Fix patch7 : patch from Pablo

* Fri Aug 30 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.5-6mdk
- Add patch7 : fix euro (patch from Pablo)

* Tue Aug 27 2002 David BAUDENS <baudens@mandrakesoft.com> 3.0.5-5mdk
- Fix icon (menu)

* Tue Aug 13 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 3.0.5-4mdk
- Automated rebuild with gcc 3.2-0.3mdk

* Mon Aug 12 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.5-3mdk
- Add patch6 : Add pablo patch fix Latvian language

* Thu Jul 25 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.5-2mdk
- Change mandrake_release (8.3 -> 9.0 )
- lib64 fixes (fixes from Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> )
- Remove BuildRequires: XFree86-static-devel for 9.0 (fixes from Gwenole Beauchesne <gbeauchesne@mandrakesoft.com>)

* Mon Jul 22 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.5-1mdk
- 3.0.5
- Add patch4 : fix PyQt compile
- Add patch5 : fix qt3.0.5 compile

* Sun Jul 14 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.4-5mdk
- Add *.so (missing )

* Sat Jul 13 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.4-4mdk
- Fix conflict

* Wed May 22 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.4-3mdk
- Rebuild with gcc-3.1

* Wed May 08 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.4-2mdk
- Rebuild against gcc-3.1

* Sat May 04 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.4-1mdk
- qt-3.0.4

* Thu Apr 18 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.3-4mdk
- Rebuild against new kdelibs

* Sun Apr 07 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.3-3mdk
- Add patch3 fix crash in ksplash
- Fix spec file

* Mon Mar 25 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.3-2mdk
- Fix buildrequires for 8.1

* Wed Mar 20 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.3-1mdk
- qt3-3.0.3 

* Sat Mar 02 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.2-2mdk
- Use official qt3-3.0.2

* Sat Feb 02 2002 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.2-1mdk
- Used qt-rsync

* Tue Jan 15 2002 David BAUDENS <baudens@mandrakesoft.com> 3.0.1-6mdk
- Fix bad /usr/lib/qt3/mkspecs/default link - Thanks to Alexander Skwar

* Thu Jan 10 2002 David BAUDENS <baudens@mandrakesoft.com> 3.0.1-5mdk
- Rebuild to replace lost src.rpm

* Wed Jan 09 2002 David BAUDENS <baudens@mandrakesoft.com> 3.0.1-4mdk
- Fix menu entries (png icons)

* Wed Jan 09 2002 David BAUDENS <baudens@mandrakesoft.com> 3.0.1-3mdk
- Fix %_libdir/qt3/doc/html link

* Sun Dec 30 2001 David BAUDENS <baudens@mandrakesoft.com> 3.0.1-2mdk
- Allow Qt2 and Qt3 to be installed in same time (see CVS for details)
- Remove support for 7.2

* Wed Dec 12 2001 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.1-1mdk
- Change release number ( 3.0.1-0.1mdk -> 3.0.1-1mdk)

* Wed Dec 12 2001 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.1-0.1mdk
- update code (3.0.1)

* Sat Dec 08 2001 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.0-0.13mdk
- Use %%version for lib name

* Mon Dec 03 2001 David BAUDENS <baudens@mandrakesoft.com> 3.0.0-0.12mdk
- Fix /etc/profile.d/qtdir3.csh - Thanks to Alexander Schmolck
- Fix PATH in /usr/share/doc/libqt3-devel-3.0.0/README.Mandrake_Linux - Thanks
  to Alexander Schmolck

* Fri Nov 23 2001 David BAUDENS <baudens@mandrakesoft.com> 3.0.0-0.11mdk
- Rewrite spec (there are a lot of modifications, see CVS for full informations)

* Thu Nov 22 2001 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.0-0.10mdk
- Fix

* Wed Nov 21 2001 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.0-0.9mdk
- Add new entry menu for (assistant, linguist programm)

* Thu Nov 20 2001 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.0-0.8mdk
- Fix doc

* Mon Nov 19 2001 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.0-0.7mdk
- Use qt-copy

* Mon Nov 19 2001 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.0-0.6mdk
- %%update_menu %%clean_menu 
- Add requires

* Mon Nov 19 2001 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.0-0.5mdk
- Add man file
- Add missing file (images pluggins)

* Sun Nov 18 2001 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.0-0.4mdk
- Add menu entry
- Some Clean

* Sat Nov 17 2001 Laurent MONTEL <lmontel@mandrakesoft.com> 3.0.0-0.3mdk
- Some clean

* Tue Nov 06 2001 Lenny Cartier <lenny@mandrakesoft.com> 3.0.0-0.2mdk
- change designer package name
- if (stable) provides in libqt3-devel

* Thu Oct 18 2001 Lenny Cartier <lenny@mandrakesoft.com> 3.0.0-0.1mdk
- new
