%define name	OpenOffice.org
%define version	1.1
%define release	11mdk.Firefly

%define subver	645
%define tarver	1.1.0
%define cvsdate	20030519
%define stlver	4.5.3

# Only IA-32 and PPC for now
ExclusiveArch: %{ix86} ppc

# Define Mandrake Linux version we are building for
%define mdkversion %(perl -pe '/(\\d+)\\.(\\d)\\.?(\\d)?/; $_="$1$2".($3||0)' /etc/mandrake-release)

# Find a free display (resources generation requires X) and sets XDISPLAY
%define init_xdisplay XDISPLAY=2; while /bin/true; do if [ ! -f /tmp/.X$XDISPLAY-lock ]; then sleep 2s; ( /usr/X11R6/bin/Xvfb -ac :$XDISPLAY >& /dev/null & ); sleep 15s; if [ -f /tmp/.X$XDISPLAY-lock ]; then break; fi; fi; XDISPLAY=$(($XDISPLAY+1)); done

# The virtual X server PID
%define kill_xdisplay kill $(cat /tmp/.X$XDISPLAY-lock)

# Languages (English and German are always built)
# FIXME: split generation of language subpackages, otherwise rpm makes
# a broken pipe
%define languages1 "ENUS,FREN,GERM,SPAN,ITAL,DTCH,PORT,SWED,POL,RUSS"
%define languages2 "DAN,GREEK,TURK,CHINSIM,CHINTRAD,JAPN,KOREAN,CZECH,CAT,FINN"
%define languages3 "ARAB,SLOVAK,PORTBR,BASQ"
%define languages  "%{languages1},%{languages2},%{languages3}"

# Supported languages for localized help files (others are not
# complete/advanced enough)
%define helplangs1 "ENUS,FREN,GERM,ITAL,SWED,SPAN,JAPN,FINN,DTCH"
%define helplangs2 "KOREAN,CHINSIM,CHINTRAD,CZECH,SLOVAK,BASQ"
%define helplangs  "%{helplangs1},%{helplangs2}"

# JDK
%define use_sunjdk 1
%{?_with_jdk: %global use_sunjdk 1}
%{?_without_jdk: %global use_sunjdk 0}

Summary:	Open source office suite
Name:		%{name}
Version:	%{version}
Release:	%{release}
Epoch:		1
URL:		http://www.openoffice.org/
License:	LGPL
Group:		Office
BuildRoot:	%{_tmppath}/%{name}-%{version}-root

Obsoletes:	openoffice
Provides:	openoffice = %{version}-%{release}
Requires:	libunixODBC2, libsane1, Xaw3d
Requires:	OpenOffice.org-libs = %{epoch}:%{version}-%{release}

# For PDF output driver
Requires:	ghostscript

# Requires a language package and some MySpell dictionary
Requires:	OpenOffice.org-l10n = %{version}

# Don't provide nor require Mozilla libraries
%define __find_provides %{_builddir}/oo_%{version}_src/find_provides.sh
%define __find_requires %{_builddir}/oo_%{version}_src/find_requires.sh

PreReq:		/usr/sbin/chkfontpath

####################################################################
#
# Compilers: only support builds with gcc >= 3.2
#
####################################################################

Requires:		libgcc >= 3.2-0.3mdk, libstdc++ >= 3.2-0.3mdk
BuildRequires:		gcc >= 3.2-0.3mdk, gcc-c++ >= 3.2-0.3mdk

%if !%use_sunjdk
BuildRequires:		gcc-java >= 3.2-0.3mdk, gcj-tools >= 3.2-0.3mdk
%else
BuildConflicts:		gcc-java
BuildConflicts:		gcj-tools
%endif

%define GCC		gcc
%define CXX		g++
%define GCJ		gcj

%ifarch %{ix86}
%define build_env	LinuxIntelEnv.Set
%define build_out_path	unxlngi4.pro
%endif
%ifarch ppc
%define build_env	LinuxPPCEnv.Set
%define build_out_path	unxlngppc4.pro
%endif
%ifarch x86_64
%define build_env	LinuxAMDEnv.Set
%define build_out_path	unxlngx4.pro
%endif

####################################################################
#
# BuildRequires
#
####################################################################

BuildRequires:	pam-devel, perl, zip, autoconf, flex, unzip
BuildRequires:	XFree86, XFree86-Xvfb, xpm-devel
BuildRequires:	perl-MDK-Common
BuildRequires:	freetype2-devel
BuildRequires:	zlib-devel
BuildRequires:	cups-devel

# Make sure we have a working tcsh first
%if %{mdkversion} >= 900
BuildRequires:	tcsh >= 6.12-2mdk
%else
BuildRequires:	tcsh
%endif

# Source12 (xmlparse) needs xsltproc
BuildRequires:	libxslt-proc >= 1.0.19
BuildRequires:	libxml2 >= 2.4.23

# We need a bison which can handle former bison 1.28 "-d -o <file>" args
BuildRequires:	bison >= 1.32-2mdk

# Use system DB library
%if %{mdkversion} >= 920
%define libdb_major 4
%define libdb_minor 1
BuildRequires:	libdb-devel >= 4.1.25-3mdk
BuildRequires:	libdbjava >= 4.1.25-3mdk
BuildRequires:	libdbcxx >= 4.1.25-3mdk
%else
%if %{mdkversion} >= 910
%define libdb_major 4
%define libdb_minor 0
BuildRequires:	libdb4.0-devel >= 4.0.14-5mdk
BuildRequires:	libdbjava4.0 >= 4.0.14-5mdk
BuildRequires:	libdbcxx4.0 >= 4.0.14-5mdk
%else
%if %{mdkversion} >= 900
%define libdb_major 3
%define libdb_minor 3
BuildRequires:	libdb3.3-devel >= 3.3.11-9mdk
BuildRequires:	libdbjava3.3 >= 3.3.11-9mdk
BuildRequires:	libdbcxx3.3 >= 3.3.11-9mdk
%endif
%endif
%endif

# We need "convert" program for XPM -> PNG icon conversion
BuildRequires:	ImageMagick

# Needed for Source14 (help/<lang>/err.html modifier)
BuildRequires:	perl-XML-Twig, perl-HTML-Parser

# We want Freetype 2.1.3 with light hint for MDK 9.1
%define build_ft_lighthint 0
%if %{mdkversion} >= 910
%define build_ft_lighthint 1
Requires:	freetype2 >= 2.1.3-3mdk
BuildRequires:	freetype2-devel >= 2.1.3-3mdk
%endif

# Needed for GNOME integration 
BuildRequires:	libgtk+2-devel

# Needed for building with JDK
# Use jdk 1.4.1, because 1.4.2 has some API changed and requires patches
%if %use_sunjdk
#BuildRequires:	jdk = 1.4.1_01
#BuildRequires:	/usr/lib/jdk-1.4.1_01/bin/javac
%endif

####################################################################
#
# Sources
#
####################################################################

Source0:	OOo_%{tarver}_source.tar.bz2
Source1:	STLport-%{stlver}.tar.bz2
Source2:	gpc231.tar.bz2
Source3:	openoffice-rsfile-global.bz2
Source4:	openoffice-rsfile-local.bz2
Source5:	openoffice-wrapper.pl
Source6:	openoffice-xlate-lang.pl
Source7:	openoffice-dpack-lang.pl
Source8:	openoffice-licenses.tar.bz2
Source9:	openoffice-png48x48.tar.bz2
# <http://whiteboard.openoffice.org/doc/Samples/User/template/index.html>
Source10:	openoffice-template-extra.tar.bz2
# <http://whiteboard.openoffice.org/doc/Samples/User/gallery/index.html>
Source11:	openoffice-gallery-extra.tar.bz2
Source12:	openoffice-1.0.1-xmlparse.sh
Source13:	openoffice-gen-langpack.sh
Source14:	openoffice-transmute-help-errfile.pl
Source15:	openoffice.conf
Source16:	openoffice-create-instdb.pl
Source20:	openoffice-1.1-basque-archive.tar.bz2

# Localized helpcontent
# <ftp://ftp.services.openoffice.org/pub/OpenOffice.org/contrib/helpcontent/>
Source100:	helpcontent_33_unix.tgz
Source101:	helpcontent_34_unix.tgz
Source102:	helpcontent_39_unix.tgz
Source103:	helpcontent_46_unix.tgz
Source104:	helpcontent_49_unix.tgz
Source105:	helpcontent_07_unix.tgz
Source106:	helpcontent_35_unix.tgz
Source107:	helpcontent_42_unix.tgz
Source108:	helpcontent_81_unix.tgz
Source109:	helpcontent_82_unix.tgz
Source110:	helpcontent_86_unix.tgz
Source111:	helpcontent_88_unix.tgz
Source112:	helpcontent_43_unix.tgz
# (Source113 re-archived from http://borft.student.utwente.nl/openoffice/contrib/help_files/)
Source113:	helpcontent_31_unix.tgz
Source114:	helpcontent_54_unix.tgz

####################################################################
#
# Patches
#
####################################################################

##
## Fixes from CVS (1.1-branch)
##

##
## General patches
##

# MDK config (CFLAGS et al.)
Patch10:	openoffice-1.1-mdkconfig.patch.bz2

# Don't install python-2.2 stuff for now
Patch11:	openoffice-1.1-disable-python.patch.bz2

# Make sure we are using Java includes from fakejdk
Patch12:	openoffice-1.1-config-fakejdk-includes.patch.bz2

# Don't uglify HTML for iso 8859-2
Patch13:	openoffice-iso8859-2-html.patch.bz2

# Don't catch SIGSEGV and SIGILL
Patch14:	openoffice-1.0.2-sal-sigsegv.patch.bz2

# Rename "sversionrc" to "OOoversionrc", "user60.rdb" to "userOOo10.rdb"
# so that both OpenOffice.org and StarOffice 6.0 can coexist
Patch15:	openoffice-1.0.1-so-ooo-coexist.patch.bz2

# Check that we have the necessary help files. The rationale is if
# help/<lang>/err.html exists then, we have localized help data,
# possibly not installed. Otherwise, we won't have localized help and
# we try to fallback to English.
Patch16:	openoffice-1.0.1-help-fallback-en.patch.bz2

# Add POSTAPP<N>TARGET to be executed after APP targets are built
Patch17:	openoffice-1.1-postapp-target.patch.bz2

# Make setup look for a "localized" instdb.ins script specified by a
# new -LANG: option. Hackaround until I find a way to do that in scp
# or autoresponse files.
Patch18:	openoffice-1.0.3-setup-localized-instdb.patch.bz2

# Get command line arguments, the regular way and not from
# /proc/<pid>/cmdline [msec 4 fix]
#
# FIXME: fallback to the previous scheme during the build as I don't
# expect people building in msec 4, and not all *main.cxx are aware of
# that change (say idlc et al.)
Patch19:	openoffice-1.1-sal-main-cmdline.patch.bz2

# Add PDF converters both suitable for either view or press purposes
# as printer option to global psprint.conf
Patch20:	openoffice-1.1-psprint-pdf-drivers.patch.bz2

# Stop forwarding to stderr things we don't actually care of while
# testing for spooler availability
Patch21:	openoffice-1.1-psprint-nullify-stderr.patch.bz2

# Don't copy nor install at setup time standard libraries (libgcc_s, libstdc++)
Patch22:	openoffice-1.1-no-stdlibs.patch.bz2

# Hack up scpzip so that it doesn't duplicate everything 17 or more
# times than necessary
Patch23:	openoffice-1.0.2-scpzip.patch.bz2

# Use MDK colors
Patch24:	openoffice-1.1-mdkcolors.patch.bz2

# Use light hinting for freetype2 >= 2.1.3-3mdk
Patch25:	openoffice-ft-set-hint.patch.bz2

# Use CUPS to grab the corresponding PPD file
Patch26:	openoffice-1.1-psprint-cups-PPD.patch.bz2

# Handle SAL_DEBUGGER in soffice script
Patch27:	openoffice-1.1-SAL_DEBUGGER.patch.bz2

# Add debug for setup so that the /tmp directory is not removed
Patch28:	openoffice-debug-keepsetup.patch.bz2

# Fix broken inline assembly
Patch29:	openoffice-1.1-broken-asm.patch.bz2

# Fix broken inclusions of STL headers
Patch30:	openoffice-1.1-stl-fixes.patch.bz2

# Make $HOME/Documents the work directory
Patch31:	openoffice-1.1-path-home-documents.patch.bz2

# Look for additional templates in <ooo>share/templates/extra/
Patch32:	openoffice-1.1-path-extra-templates.patch.bz2

# Don't export crazy symbols from svunzip (IZ #17841)
Patch33:	openoffice-1.1-unzip-export-symbols.patch.bz2

# MySpell dictionaries are shared in /usr/share/dict/ooo
Patch35:	openoffice-1.1-path-myspell-dictionaries.patch.bz2

# Enable automatic spellchecking by default
Patch36:	openoffice-1.1-auto-spellchecking.patch.bz2

# Use default fonts available in the distribution
Patch37:	openoffice-1.1-mdkfonts.patch.bz2

# Fix crash in ExtendedFontStruct::HasUnicodeChar()
Patch38:	openoffice-1.1-vcl-fix-HasUnicodeChar.patch.bz2

# Disable KDE screensaver during presentations
Patch39:	openoffice-1.1-impress-no-kde-screensaver.patch.bz2

# Make font substitution algorithm match documentation (IZ #19591)
Patch40:	openoffice-1.1-vcl-font-subst.patch.bz2

##
## Ximian patches
##

# Add word count feature under Tools/Hyphenation item
Patch100:	openoffice-1.1-sw-word-count.patch.bz2

# Default to .doc/.xls/.ppt documents
Patch101:	openoffice-1.1-ooo-ms-defaults.patch.bz2

# Add support for 32-bit bitmaps and icons
Patch102:	openoffice-1.1-bmp32.patch.bz2

# Correct typo in Options->HTML compatibility for sv (IZ #16437)
Patch103:	openoffice-1.1-typos.patch.bz2

# Export 'no color' background to doc (IZ #18671)
Patch104:	openoffice-1.1-sw-export-bg-style.patch.bz2

# Don't continually beep annoyingly (IZ #18440)
Patch105:	openoffice-1.1-gui-beep-less.patch.bz2

# Startup notification fixes (IZ #18970)
Patch106:	openoffice-1.1-startup-fix.patch.bz2

##
## STLport 4.5.3 patches
##

# Exception patch for STLport 4.5.3 and gcc3
Patch300:	STLport-4.5.3-gcc3stdexcept.patch.bz2

# Nuke STLport badlink
Patch301:	STLport-4.5.3-nobadlink.patch.bz2

# Add support for MDK gcc-3.1.0 to STLport-4.5.3
# (aka. gxx_includedir is /usr/include/g++-v31/)
Patch302:	STLport-4.5.3-gcc31includes.patch.bz2

# Add support for gcc >= 3.1.1 includes
# (aka. gxx_includedir is /usr/include/c++/<gxx_version>/)
Patch303:	STLport-4.5.3-gcc3Xincludes.patch.bz2

# Add EXTRA_CXXFLAGS for RPM_OPT_FLAGS, some fixlets
Patch304:	STLport-4.5.3-extra-cxxflags.patch.bz2

##
## Enable system libraries & fonts
##

# Use system DB library
Patch400:       openoffice-1.1-system-db.patch.bz2

# Use system FreeType 2 library
Patch401:	openoffice-1.1-system-freetype.patch.bz2

# Use system getopt library
Patch402:       openoffice-1.1-system-getopt.patch.bz2

# Use system zlib
Patch403:	openoffice-1.1-system-zlib.patch.bz2

# Use system Xrender library
Patch404:	openoffice-1.1-system-xrender.patch.bz2

# Use system Vera fonts
Patch405:	openoffice-1.1-system-vera-fonts.patch.bz2

##
## 64-bit ports
##

Patch500:       openoffice-1.0.2-64bit-fixes-idlc.patch.bz2
Patch501:       openoffice-1.0.2-64bit-fixes-dmake.patch.bz2
Patch502:       openoffice-1.0.2-64bit-fixes-odbc.patch.bz2
# TODO: split as it grows and stabilizes
Patch503:       openoffice-1.0.2-64bit-fixes.patch.bz2

Patch540:       openoffice-1.0.2-x86_64-config.patch.bz2
Patch541:       openoffice-1.0.2-x86_64-solenv.patch.bz2
Patch542:       openoffice-1.0.2-x86_64-sal.patch.bz2
Patch543:       openoffice-1.0.2-x86_64-cppu.patch.bz2
Patch544:       openoffice-1.0.2-x86_64-bridges.patch.bz2
Patch545:       openoffice-1.0.2-x86_64-psprint.patch.bz2
Patch546:       openoffice-1.0.2-x86_64-nas-fixes.patch.bz2

# FIXME: Colateral, induced by previous patch on 32-bit platform
Patch599:	openoffice-1.0.2-64bit-fixes-colateral.patch.bz2

# (gg) CWS vcl7pp1r2 patches
Patch999:	openoffice-1.1-vcl7pp1r2.patch.bz2
# (gg) Patch for getting OOo compiling with freetype2 2.1.7
Patch1000:	openoffice-1.1-ft217.patch.bz2
# (gg) Patch for basque localization (rebuilt from dooteo's basque archive)
Patch1010:	openoffice-1.1-basque.patch.bz2
Patch1011:	openoffice-1.1-external-localize-eu.patch.bz2
# (gg) Patch for ISSUE #18588 (officecfg and extracting schema)
Patch1012:	openoffice-1.1-remove-cfg-schema-18588.patch.bz2
# (gg) Patch for removing gtk from crashrep (merged from Janik's CZ OOo archives)
Patch1013:	openoffice-1.1-remove-gtk-from-crashrep.patch.bz2
# (gg) Patch for fixing incorrect Input field newlines code when saved as MS Word (merged from Janik's CZ OOo archives)
Patch1014:	openoffice-1.1-newline-in-word-fields.patch.bz2
# (gg) Patch for fixing not translatable string in Tools/Options/External applications
Patch1015:	openoffice-1.1-remove-word-option-15640.patch.bz2
# (gg) Patch for word6 & 95 filters (merged from Janik's CZ OOo archives)
Patch1016:	openoffice-1.1-word6_95.patch.bz2
# (gg) Patch for disabling default OpenGL 3D acceleration
Patch1017:	openoffice-1.1-disabledefaultopengl.patch.bz2
# (gg) Patch for excel5 & 95 filters (merged from Janik's CZ OOo archives)
Patch1018:	openoffice-1.1-excel5_95.patch.bz2
# (gg) Patch fir ISSUE #15909 (merged from Janik's CZ OOo archives)
Patch1019:	openoffice-1.1-caption-15909.patch.bz2
# (gg) Patch for building under kernel 2.6 (from Gentoo/JJ)
Patch1020:	openoffice-1.1-linux26-nptl.patch.bz2
# (gg) Patch for adding zoom combobox (from Ximian OOo_1_1/zoom-combobox.diff)
Patch1021:      openoffice-1.1-zoom-combobox.patch.bz2
# Firefly's patches for better use CJK characters
Patch1100:	openoffice-1.1rc4-psprint-fontmanager-20030910.patch
Patch1101:	openoffice-1.1rc3-psprint-addfakerc-20030828.patch
Patch1102:	openoffice-1.1rc2-padmin-nofakefont-20030730.patch
Patch1103:	openoffice-1.1rc2-vcl-xlfd_attr-20030806.patch
Patch1104:	openoffice-1.1rc3-freetype-20030819.patch
Patch1105:	openoffice-1.1rc3-psprint-usefreetype-20030819.patch
Patch1106:	openoffice-1.1rc3-psprint-fontsubset-ft2-20030827.patch
Patch1107:	openoffice-1.1rc3-psprint-printergfx-20030818.patch
Patch1108:	openoffice-1.1rc3-vcl-simulat3style-20030829.patch
Patch1109:	openoffice-1.1rc3-vcl-defaultfontsize-20030819.patch
Patch1110:	openoffice-1.1rc4-vcl-defaultInterfaceFont-20030909.patch
# Patch for Patch1106
Patch1111:	printergfx-makefile.patch

%description
OpenOffice.org is an Open Source, community-developed, multi-platform
office productivity suite. It includes the key desktop applications,
such as a word processor, spreadsheet, presentation manager, forumula
editing and drawing program, with a user interface and feature set
similar to other office suites. Sophisticated and flexible,
OpenOffice.org also works transparently with a variety of file
formats, including Microsoft Office.

Languages available in OpenOffice.org-l10n-* packages include: English,
French, German, Spanish, Italian, Dutch, Swedish, Finnish, Polish,
Russian, Chinese, Japanese, Korean, Danish, Greek, Turkish, Czech,
Catalan, Arab, Slovak, Basque.

Localized help files available in OpenOffice.org-help-* packages
include: English, French, German, Spanish, Italian, Swedish, Russian,
Finnish, Czech, Japanese, Korean, Chinese, Slovak, Basque.

Spell-checking and hyphenation dictionaries are available in myspell-*
and myspell-hyph-* packages, respectively. Please install the ones
that better suit your language needs.

Usage: Simply type "ooffice" to run OpenOffice.org or select the
requested component (Writer, Calc, Draw, Impress, etc.) from your
desktop menu. The ooffice wrapper script will install a few files in
the user's home, if necessary.

   * oocalc: OpenOffice.org Calc
   * oodraw: OpenOffice.org Draw
   * ooimpress: OpenOffice.org Impress
   * oomath: OpenOffice.org Math
   * oowriter: OpenOffice.org Writer

####################################################################
#
# Extra subpackages
#
####################################################################

%package libs
Summary: OpenOffice.org shared libraries
Group: Office

%description libs
OpenOffice.org is an Open Source, community-developed, multi-platform
office productivity suite.  This package includes its shared
libraries.  You need to install this to use OpenOffice.org.

####################################################################
#
# Language subpackages
#
# Syntax: gen-langpack.sh (DESC|FILES) (L10N|HELP) <languages> <language xlator>
#
# NOTES:
# 1. Make sure arguments are correct first!
# 2. DESC generate the %package and %description sections
# 3. FILES generate the package %files section,
#    >> Assume we correctly generate filelist.<isocode> lists
#
####################################################################
%{expand:%(/bin/sh %{SOURCE13} DESC HELP %{helplangs1} %{SOURCE6})}
%{expand:%(/bin/sh %{SOURCE13} DESC HELP %{helplangs2} %{SOURCE6})}
%{expand:%(/bin/sh %{SOURCE13} DESC L10N %{languages1} %{SOURCE6})}
%{expand:%(/bin/sh %{SOURCE13} DESC L10N %{languages2} %{SOURCE6})}
%{expand:%(/bin/sh %{SOURCE13} DESC L10N %{languages3} %{SOURCE6})}

%prep
%setup0 -q -n oo_%{version}_src -a 1 -a 8 -a 20

%patch10 -p1 -b .mdkconfig
%patch11 -p1 -b .disable-python

%if !%use_sunjdk
if [[ -z "$OVERRIDE_JAVA_HOME" ]]; then
%patch12 -p1 -b .config-fakejdk-includes
fi
%endif

%patch13 -p1 -b .iso8859-2-html
%patch14 -p1 -b .sal-sigsegv
#%patch15 -p1 -b .so-ooo-coexist
%patch16 -p1 -b .help-fallback-en
%patch17 -p1 -b .postapp-target
%patch18 -p1 -b .setup-localized-instdb
%patch19 -p1 -b .sal-main-cmdline
%patch20 -p1 -b .psprint-pdf-drivers
%patch21 -p1 -b .psprint-nullify-stderr
%patch22 -p1 -b .no-stdlibs
%patch23 -p1 -b .scpzip
perl -pi -e 'BEGIN{ $H = join " || ", map { "nLang == " . int $_ }
                    (split / /, `perl %{SOURCE6} -p %{helplangs}`); }
             s/\@HELP\@/$H/' scptools/source/linker/scpzip.cxx
%patch24 -p1 -b .mdkcolors
%if %{build_ft_lighthint}
%patch25 -p1 -b .ft-set-lighthint
%endif
%patch26 -p1 -b .psprint-cups-PPD
%patch27 -p1 -b .SAL_DEBUGGER
%patch28 -p0 -b .debug-keepsetup
%patch29 -p1 -b .asmfixes
%patch30 -p1 -b .stlfixes
%patch31 -p1 -b .path-home-documents
%patch32 -p1 -b .path-extra-templates
%patch33 -p1 -b .unzip-export-symbols
%patch35 -p1 -b .path-myspell-dictionaries
%patch36 -p1 -b .auto-spellchecking
%patch37 -p1 -b .mdkfonts
%patch38 -p1 -b .vcl-fix-HasUnicodeChar
%patch39 -p1 -b .impress-no-kde-screensaver
%patch40 -p1 -b .vcl-font-subst

%patch100 -p1 -b .sw-word-count
%patch101 -p1 -b .ooo-ms-defaults
%patch102 -p1 -b .bmp32
%patch103 -p1 -b .typos
%patch104 -p1 -b .sw-export-bg-style
%patch105 -p1 -b .gui-beep-less
%patch106 -p1 -b .startup-fix

cd STLport-%{stlver}
%patch300 -p1 -b .gcc3stdexcept
%patch301 -p1 -b .nobadlink
%patch302 -p1 -b .gcc31includes
%patch303 -p1 -b .gcc3Xincludes
%patch304 -p1 -b .extra-cxxflags
cd ..

%patch400 -p1 -b .system-db
perl -pi -e "s/^(BERKELEYLIBMAJOR)=.+/\1=%{libdb_major}/;" \
         -e "s/^(BERKELEYLIBMINOR)=.+/\1=%{libdb_minor}/;" \
         solenv/inc/libs.mk
%if %{libdb_major}%{libdb_minor} >= 41
DB_TXNID="null,"
%endif
perl -pi -e "s/DB_TXNID/$DB_TXNID/" \
xmlhelp/source/com/sun/star/help/{HelpDatabases,HelpIndexer,CreateDb}.java
%patch401 -p1 -b .system-freetype
%patch402 -p1 -b .system-getopt
%patch403 -p1 -b .system-zlib
%patch404 -p1 -b .system-xrender
%patch405 -p1 -b .system-vera-fonts

%if 0
%patch500 -p1 -b .64bit-fixes-idlc
%patch501 -p1 -b .64bit-fixes-dmake
%patch502 -p1 -b .64bit-fixes-odbc
%patch503 -p1 -b .64bit-fixes
%patch540 -p1 -b .x86_64-config
%patch541 -p1 -b .x86_64-solenv
%patch542 -p1 -b .x86-64-sal
%patch543 -p1 -b .x86_64-cppu
%patch544 -p1 -b .x86_64-bridges
%patch545 -p1 -b .x86_64-psprint
%patch546 -p1 -b .x86_64-nas-fixes
%patch599 -p1 -b .64bit-fixes-colateral
%endif

%patch999 -p1 -b .vcl7pp1r2
%patch1000 -p1 -b .ft217

%patch1010 -p1 -b .basque
%patch1011 -p1 -b .basque-ext
%patch1012 -p1 -b .18588
%patch1013 -p1 -b .crashrep_gtk
%patch1014 -p1 -b .newline_word
%patch1015 -p1 -b .remword
%patch1016 -p1 -b .word6_95
%patch1017 -p1 -b .opengl
%patch1018 -p1 -b .excel5_95
%patch1019 -p1 -b .15909
%patch1020 -p1 -b .linux26
%patch1021 -p1 -b .zoom_combobox

%patch1100 -p1 -b .Firefly00
%patch1101 -p1 -b .Firefly01
%patch1102 -p1 -b .Firefly02
%patch1103 -p1 -b .Firefly03
%patch1104 -p1 -b .Firefly04
%patch1105 -p1 -b .Firefly05
%patch1106 -p1 -b .Firefly06
%patch1107 -p1 -b .Firefly07
%patch1108 -p1 -b .Firefly08
%patch1109 -p1 -b .Firefly09
#%patch1110 -p1 -b .Firefly10
%patch1111 -p1 -b .Firefly11

# External packages
%setup2 -q -T -D -a 2 -n oo_%{version}_src
(cd gpc231; mv gpc.{c,h} ../external/gpc)

# Install localized helpcontent
cd helpcontent/unx
# don't care about main_transform.xsl, it looks safe to overwrite
for file in %{SOURCE100} %{SOURCE101} %{SOURCE102} %{SOURCE103} \
            %{SOURCE104} %{SOURCE107} %{SOURCE108} %{SOURCE109} \
            %{SOURCE110} %{SOURCE111} %{SOURCE112} %{SOURCE113} \
	    %{SOURCE114}
do
  tar zxf $file
done
for file in s*.zip; do
  dir=`echo $file | sed -e "s/\(s[a-z]*\)[0-9]*.zip/\1/"`
  [[ "$dir" = "shared" ]] && dir="common"
  prefix=`echo $file | sed -e "s/s[a-z]*\([0-9]*\).zip/\1/"`
  langname=`perl %{SOURCE6} -l $prefix | tr '[A-Z ]' '[a-z_]'`
  mkdir -p $dir/$langname
  unzip -d $dir/$langname -o $file
done
rm -f *.zip
cd ../..

# Some translators translated %%PRODUCTNAME %%PRODUCTVERSION - undo this
find scp/source -name "*.lng" | \
  xargs perl -pi -e "s/(StarOffice|StarSuite) 6.0/%%PRODUCTNAME %%PRODUCTVERSION/"

%if %use_sunjdk
export OVERRIDE_JAVA_HOME=y
%else
# Build fake JDK
if [[ -z "$OVERRIDE_JAVA_HOME" ]]; then
mkdir -p fakejdk/bin fakejdk/include
cp -a %{SOURCE12} fakejdk/bin/xmlparse
sed "s~@@~`pwd`~" > fakejdk/bin/java <<"EOF"
#!/bin/sh
if [ "$1" = "-version" ]; then
  echo 'java version "1.3.1_03"' 1>&2
  exit 0
fi
if [ "$4" = org.openoffice.configuration.XMLDefaultGenerator ]; then
  exec @@/fakejdk/bin/xmlparse ${1+"$@"}
fi
echo "FIXME: Emulate java runtime with gij here"
exit 1
EOF
chmod +x fakejdk/bin/java fakejdk/bin/xmlparse
sed "s~@@~%{GCJ}~" > fakejdk/bin/javac <<"EOF"
#!/bin/sh
if [ "$1" = "-J-version" ]; then
  echo 'java version "1.3.1_03"' 1>&2
  exit 0
fi
TEMP=`mktemp -d fakejavac.XXXXXX` || exit 1
DEST=.
ANY=""
while [ $# != 0 ]; do
  if [ "$1" = "-classpath" ]; then
    shift
  elif [ "$1" = "-g" ]; then
    : # skip
  elif [ "$1" = "-d" ]; then
    DEST=$2
    shift
  else
    case "$1" in
      *.java) C=`basename "$1" .java`
	      grep '^[ 	]*package[ 	]*[^ 	]*[ 	]*;[ 	]*$' $1 > $TEMP/$C.java
	      echo "public class $C { }" >> $TEMP/$C.java
	      ANY=1
	 ;;
      *) echo "unknown option passed to javac!" 1>&2
	 exit 1;;
    esac
  fi
  shift
done
if [ -n "$ANY" ]; then
  @@ -C -d $DEST $TEMP/*.java
fi
rm -rf $TEMP
exit 0
EOF
chmod +x fakejdk/bin/javac
GCJVERS="`%{GCJ} -dumpversion`"
GCJINCS="/usr/include/libgcj-$GCJVERS"
ln -sf $GCJINCS/j* $GCJINCS/gcj fakejdk/include/
rm -f fakejdk/include/jni.h
cat > fakejdk/include/jni.h <<EOF
#ifndef FAKEJDK_JNI_H
#define FAKEJDK_JNI_H 1
#include_next <libgcj-$GCJVERS/jni.h>
#include <stdio.h>
#include <stdarg.h>

#define JNIEXPORT
#define JNICALL

typedef struct JDK1_1InitArgs
{
  jint version;
  char ** properties;
  jint checkSource, nativeStackSize, javaStackSize, minHeapSize, maxHeapSize, verifyMode;
  char *classpath;
  jint (*vfprintf) (FILE *, const char *, va_list);
  void (*exit) (jint);
  void (*abort) (void);
  jint enableClassGC, enableVerboseGC, disableAsyncGC, verbose;
  jboolean debugging;
  jint debugPort;
} JDK1_1InitArgs;

#define JavaVM_ JavaVM
#endif
EOF
fi
%endif

%build
%if %use_sunjdk
export OVERRIDE_JAVA_HOME=y
export JAVA_HOME=/usr/lib/jdk-1.4.1_01
export LD_ASSUME_KERNEL=2.4.1
%endif

# Checking whether Java is accessible (use JAVA_HOME to give JDK location location)
if [[ -z "$OVERRIDE_JAVA_HOME" ]]; then
  JAVA_HOME=$PWD/fakejdk
fi
if [[ -z "$JAVA_HOME" ]]; then
  export JAVA_HOME=/usr/lib/jdk-1.4.1_01
fi
$JAVA_HOME/bin/java -version >& /dev/null

# Build STLport 4.5.3 everywhere
cd STLport-%{stlver}/src
%make -f gcc-linux.mak release_dynamic release_static \
  CC="%{GCC}" CXX="%{CXX}" EXTRA_CXXFLAGS="$RPM_OPT_FLAGS"
ln -sf libstlport_gcc.so.4.5 ../lib/libstlport_gcc.so
cd ..
WITH_STLPORT4_HOME="--with-stlport4-home=$PWD"
[[ "%{_lib}" != "lib" ]] && ln -s lib %{_lib}
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$PWD/%{_lib}
cd ..

# Configure OpenOffice.org build
cd config_office
export  CC=%{GCC}
export CXX=%{CXX}
./configure --with-jdk-home=$JAVA_HOME --with-lang="%{languages}" $WITH_STLPORT4_HOME
cd ..

# Build bootstrap stuff
./bootstrap

# if RPM_BUILD_NCPUS unset, set it
if [ -z "$RPM_BUILD_NCPUS" ] ; then
  if [ -x /usr/bin/getconf ] ; then
    RPM_BUILD_NCPUS=$(/usr/bin/getconf _NPROCESSORS_ONLN)
    if [ $RPM_BUILD_NCPUS -eq 0 ]; then
      RPM_BUILD_NCPUS=1
    fi
  else
    RPM_BUILD_NCPUS=1
  fi
fi

# FIXME: it doesn't work yet
RPM_BUILD_NCPUS=1

# Do parallel build if PARALLELMFLAGS contains correct -PPn definition
if [ $RPM_BUILD_NCPUS -gt 1 ]; then
  # TODO: Some makefiles are not dmake -P ready
  for i in io/source/stm dtrans/source/X11 idlc/source nas zlib toolkit/util \
           comphelper/util padmin/source svtools/util bridges/source/prot_uno \
           ucb/source/ucp/ftpproxy framework/util framework/source/unotypes; do
    perl -pi -e "s/^(PRJNAME)/MAXPROCESS=1\n\1/" $i/makefile.mk
  done
  perl -pi -e "s/(product=full)/\1 \\\$(PARALLELMFLAGS)/" makefile.mk
fi

%{init_xdisplay}
export DISPLAY=:$XDISPLAY
. %{build_env}.sh
dmake #PARALLELMFLAGS=-P$RPM_BUILD_NCPUS
%{kill_xdisplay}

%install
rm -rf $RPM_BUILD_ROOT
%if %use_sunjdk
export LD_ASSUME_KERNEL=2.4.1
%endif

# Launch a virtual framebuffer X server on a free display
%{init_xdisplay}

# Remove stale entries and remake zipfiles
#rm -rf ./instsetoo/%{build_out_path}/
#(. %{build_env}.sh; dmake install)

# Do a system-wide install (/net) from an auto-response file
mkdir -p $RPM_BUILD_ROOT%{_libdir}/openoffice
RESPONSE_FILE=$PWD/rsfile.ins
(cd ./instsetoo/%{build_out_path}/01/normal/;
  bzcat %{SOURCE3} | sed -e "s|<DESTDIR>|$RPM_BUILD_ROOT%{_libdir}/openoffice|" > $RESPONSE_FILE

  # Localize New and Wizard menus and OfficeObjects
  [[ ! -f setup.ins.localized ]] && {
  cp -p setup.ins setup.ins.localized
  (
  for i in `( cd ../../; echo [0-9][0-9] ) | sed 's/01 //'`; do
    if [ -f ../../$i/normal/setup.ins ]; then
      CONV=cat
      case "$i" in
      03|3[134579]|4[5689]|55)
        # pt, nl, fr, es, fi, ca, it, da, sv, pl, de, pt-BR are latin1 encoded
	CONV="iconv -f ISO-8859-1// -t UTF-8//";;
      4[23])
        # cs, sk are latin2 encoded
        CONV="iconv -f ISO-8859-2// -t UTF-8//";;
      07)
        # ru is iso8859-5 encoded
	CONV="iconv -f ISO-8859-5// -t UTF-8//";;
      30)
        # el is iso8859-7 encoded
        CONV="iconv -f ISO-8859-7// -t UTF-8//";;
      90)
        # tr is latin5 encoded
	CONV="iconv -f ISO-8859-9// -t UTF-8//";;
      96)
        # ar is cp1256 encoded
	CONV="iconv -f CP1256// -t UTF-8//";;
      8[1268])
        # ja, ko, zh-CN, zh-TW are already UTF-8 encoded
        ;;
      esac
      grep -A6 'gid_Configurationitem_Common_\(Objectnames.*_Name\|Menus_.*Titel\)' \
	../../$i/normal/setup.ins | $CONV \
	| sed "s/^--//;/^ConfigurationItem/s/\(Name\|Titel\)/$i&/"
      echo
    fi
  done
  ) | awk ' $1 ~ /Value/ { l=$0; sub(/^.*= "/,"",l); sub(/";.*$/,"",l); sub(/%PRODUCTNAME/,"OpenOffice.org",l); sub(/%PRODUCTVERSION/,"%{version}",l); n=n+1; str="@@REPLACEME" n "@@"; s="\"" str "\""; sub(/".*"/,s); printf "s|%s|%s|\n", str, l > "Common.xcu.sed" } { print } ' \
    >> setup.ins
  }

  DISPLAY=:$XDISPLAY ./setup -R:$RESPONSE_FILE
  rm -f $RESPONSE_FILE
)
%{kill_xdisplay}

# Now fixup Common.xcu
COMMON_XML_SED=$PWD/instsetoo/%{build_out_path}/01/normal/Common.xcu.sed
(cd $RPM_BUILD_ROOT%{_libdir}/openoffice/share/registry/data/org/openoffice/Office/;
  sed -e "s|<cfg:string cfg:type=\"string\" cfg:name=\"\([^\"]*\)\"\(>@@REPLACEME.*@@</cfg:\)string>|<cfg:value xml:lang=\"\1\"\2value>|" Common.xcu > Common.xcu.tmp
  sed -f $COMMON_XML_SED Common.xcu.tmp > Common.xcu
  rm -f Common.xcu.tmp
)

# Fixup instdb.ins to get rid of $RPM_BUILD_ROOT
perl -pi -e "s|$RPM_BUILD_ROOT||g" \
  $RPM_BUILD_ROOT%{_libdir}/openoffice/program/instdb.ins
perl -pi -e "/^Installation gid_Installation/ .. /^End/ and s|(SourcePath.*)=.*|\1= \"%{_libdir}/openoffice/program\";|" \
  $RPM_BUILD_ROOT%{_libdir}/openoffice/program/instdb.ins

# Fix setup and spadmin symlinks set by OO.org setup program
# (must have absolute symlinks)
ln -sf %{_libdir}/openoffice/program/setup $RPM_BUILD_ROOT%{_libdir}/openoffice/setup
ln -sf %{_libdir}/openoffice/program/soffice $RPM_BUILD_ROOT%{_libdir}/openoffice/spadmin
ln -sf %{_libdir}/openoffice/program/soffice $RPM_BUILD_ROOT%{_libdir}/openoffice/program/spadmin

# FIXME: I don't care about -devel things for now
rm -rf $RPM_BUILD_ROOT%{_libdir}/openoffice/program/addin

# Move KDE and CDE integration upwards in %{_datadir}. Likewise for icons
# NOTE: doing this here prevents from automatically adding those files
# to the filelist, operation carried out below.
mkdir -p $RPM_BUILD_ROOT%{_datadir}
for desktop in kde cde gnome icons; do
  mv $RPM_BUILD_ROOT%{_libdir}/openoffice/share/$desktop $RPM_BUILD_ROOT%{_datadir}/
done

# Remove setup log and useless sopatchlevel script
rm -f %{buildroot}%{_libdir}/openoffice/program/setup.log
rm -f %{buildroot}%{_libdir}/openoffice/program/sopatchlevel.sh

# Remove stuff that should come from system libraries
rm -f %{buildroot}%{_libdir}/openoffice/program/libdb{,_cxx,_java}-?.?.so

# Install new template and gallery content
mkdir -p %{buildroot}%{_libdir}/openoffice/share/template
mkdir -p %{buildroot}%{_libdir}/openoffice/share/gallery
(cd %{buildroot}%{_libdir}/openoffice/share;
  tar fxvj %{SOURCE10}
  tar fxvj %{SOURCE11}
)

# Really make dictionaries stuff go to /usr/share/dict/ooo/
mkdir -p $RPM_BUILD_ROOT%{_datadir}/dict/ooo
mv -f  $RPM_BUILD_ROOT%{_libdir}/openoffice/share/dict/ooo/* $RPM_BUILD_ROOT%{_datadir}/dict/ooo/
chmod 644 $RPM_BUILD_ROOT%{_datadir}/dict/ooo/th_en_US.*
rm -rf $RPM_BUILD_ROOT%{_libdir}/openoffice/share/dict

# File lists are necessary for language packs
FILELIST=$PWD/filelist
find $RPM_BUILD_ROOT%{_libdir}/openoffice "(" -type f -or -type l ")" -print | \
  sed -e "s|^$RPM_BUILD_ROOT||g" > $FILELIST
find $RPM_BUILD_ROOT%{_libdir}/openoffice -type d -print | \
  sed -e "s|^$RPM_BUILD_ROOT|%dir |g" >> $FILELIST

# Extract language packs
(cd ./instsetoo/%{build_out_path}/;
  install -m 755 %{SOURCE6} oo_xlate_lang
  install -m 755 %{SOURCE7} oo_dpack_lang
  install -m 755 %{SOURCE14} oo_fixup_help
  install -m 755 %{SOURCE16} oo_gen_instdb
  for res in `echo "%{languages}" | sed -e "s/,/ /g"`; do
    isocode=`./oo_xlate_lang -i $res`
    prefix=`./oo_xlate_lang -p $res`
    tempdir=$RPM_BUILD_ROOT%{_libdir}/openoffice-$isocode
    mkdir -p $tempdir
    # may extract help files, if known to be localized enough
    case ",%{helplangs}," in
    *,$res,*)
      ./oo_dpack_lang -d=$tempdir -i=$prefix/normal/setup.ins -h
      # fix permissions
      find $tempdir/help/$isocode -type d | xargs chmod 755
      find $tempdir/help/$isocode -type f | xargs chmod 644
      # transmute error file to suggest installation of
      # OpenOffice.org-help-* package
      cp -f $tempdir/help/$isocode/err.html orig.err.html
      # nuke broken <meta http-equiv="..."/> tag and entities in
      # Finnish err.htmm
      [[ "$isocode" = "fi" ]] && {
        perl -pi -MEncode -MHTML::Entities -pi \
             -e 's/<meta\s+http-equiv=[^>]+>//i;' \
             -e '$_=Encode::encode_utf8 decode_entities $_' orig.err.html
      }
      [[ "$isocode" != "sk" ]] && \
      ./oo_fixup_help $isocode orig.err.html >$tempdir/help/$isocode/err.html
      rm -f orig.err.html
      find $tempdir/help/$isocode "(" -type f -or -type l ")" -print | \
        sed -e "s|$RPM_BUILD_ROOT%{_libdir}/openoffice-$isocode|%{_libdir}/openoffice|g" > $FILELIST.help.$isocode.in
      find $tempdir/help/$isocode -type d -print | \
        sed -e "s|$RPM_BUILD_ROOT%{_libdir}/openoffice-$isocode|%dir %{_libdir}/openoffice|g" | sort -u >> $FILELIST.help.$isocode.in
      # keep err.html and custom.css in main l10n package
      grep -v "help/$isocode\(\|/\(err.html\|custom.css\)\)$" $FILELIST.help.$isocode.in > $FILELIST.help.$isocode
      rm -f $FILELIST.help.$isocode.in
      ;;
    *)
      # default, create empty help directory
      # NOTE: with Patch16 (help-fallback-en) we fallback to English help files
      ./oo_dpack_lang -d=$tempdir -i=$prefix/normal/setup.ins
      mkdir -p $tempdir/help/$isocode
      ;;
    esac
    # link ooo resource files to iso files
    (cd $tempdir/program/resource;
      file=`echo ooo*.res`
      ln -sf $file ${file/ooo/iso}
    )
    # generate localized instdb.ins files, aka let the right files to
    # be installed for a user installation
    [[ "$isocode" != "en" ]] && {
      ./oo_gen_instdb -d $tempdir \
        -i $prefix/normal/setup.ins \
        -o $tempdir/program/instdb.ins.$isocode \
        -pn "%{name}" -pv "%{version}"
      perl -pi -e "s|$tempdir|%{_libdir}/openoffice|g" \
        $tempdir/program/instdb.ins.$isocode
    }
    # build file list
    find $tempdir "(" -type f -or -type l ")" -print | \
      sed -e "s|$tempdir|%{_libdir}/openoffice|g" > $FILELIST.$isocode
    find $tempdir -type d -print | \
      sed -e "s|$tempdir|%dir %{_libdir}/openoffice|g" | sort -u >> $FILELIST.$isocode
    # remove duplicates from l10n-en package
    [[ "$isocode" != "en" ]] && {
      mv $FILELIST.$isocode $FILELIST.$isocode.in
      perl -MMDK::Common -e "print difference2([ cat_(\"$FILELIST.$isocode.in\") ], [ cat_(\"$FILELIST.en\") ])" \
        > $FILELIST.$isocode
      rm -f $FILELIST.$isocode.in
    }
    # move files here and there
    cp -af $tempdir/* $RPM_BUILD_ROOT%{_libdir}/openoffice/
    rm -rf $tempdir
  done
)

# Remove duplicates from help vs. l10n packages
for filelist in $FILELIST.help.*; do
  raw_filelist=${filelist/.help/}
  mv $raw_filelist $raw_filelist.in
  perl -MMDK::Common -e "print difference2([ cat_(\"$raw_filelist.in\") ], [ cat_(\"$filelist\") ])" \
    > $raw_filelist
  rm -f $raw_filelist.in
done

# List of files that have to be in main package
# NOTE: we assume they always reside in the English localization
cat > $FILELIST.force << EOF
%{_libdir}/openoffice/user/config/arrowhd.soe
%{_libdir}/openoffice/user/config/classic.sog
%{_libdir}/openoffice/user/config/hatching.soh
%{_libdir}/openoffice/user/config/modern.sog
%{_libdir}/openoffice/user/config/palette.soc
%{_libdir}/openoffice/user/config/styles.sod
%{_libdir}/openoffice/help/en/err.html
EOF

# Remove those exceptions from the -l10n-en package
mv $FILELIST.en $FILELIST.in
perl -MMDK::Common -e "print difference2([ cat_(\"$FILELIST.in\") ], [ cat_(\"$FILELIST.force\") ])" \
  > $FILELIST.en
rm -f $FILELIST.in

# Remove duplicates from OpenOffice.org-l10n-en package
mv $FILELIST $FILELIST.in
perl -MMDK::Common -e "print difference2([ cat_(\"$FILELIST.in\") ], [ cat_(\"$FILELIST.en\"), cat_(\"$FILELIST.help.en\") ])" \
  > $FILELIST
rm -f $FILELIST.in

# Now split the package up into OpenOffice.org, OpenOffice.org-libs
grep "%{_libdir}/openoffice/program/lib.*so.*" $FILELIST > $FILELIST.libs
mv -f $FILELIST $FILELIST.tmp
grep -v "%{_libdir}/openoffice/program/lib.*so.*" $FILELIST.tmp > $FILELIST
rm -f $FILELIST.tmp

# Install autoresponse file for user installation
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/openoffice
bzcat %{SOURCE4} > $RPM_BUILD_ROOT%{_sysconfdir}/openoffice/autoresponse.conf
chmod 644 $RPM_BUILD_ROOT%{_sysconfdir}/openoffice/autoresponse.conf

# Install global openoffice.conf
install -m 644 %{SOURCE15} $RPM_BUILD_ROOT%{_sysconfdir}/openoffice/openoffice.conf

# Install OpenOffice.org wrapper script
mkdir -p $RPM_BUILD_ROOT%{_bindir}
sed -e "s|<OOVERSION>|%{version}|"    \
    -e "s|<OOTREEVERSION>|%{subver}|" \
    -e "s|<LIBDIR>|%{_libdir}|"       \
    %{SOURCE5} > $RPM_BUILD_ROOT%{_bindir}/ooffice
chmod 755 $RPM_BUILD_ROOT%{_bindir}/ooffice

# Create links from oo<compoent> to actual ooffice wrapper script
for app in calc draw impress math writer; do
  ln -s ooffice $RPM_BUILD_ROOT%{_bindir}/oo$app
done

# Install regcomp tool
install -m 755 solver/%{subver}/%{build_out_path}/bin/regcomp \
  $RPM_BUILD_ROOT%{_libdir}/openoffice/program/
cat > $RPM_BUILD_ROOT%{_bindir}/ooregcomp << EOF
#!/bin/sh
export LD_LIBRARY_PATH=%{_libdir}/openoffice/program:\$LD_LIBRARY_PATH
exec %{_libdir}/openoffice/program/regcomp \${1+"\$@"}
EOF
chmod +x $RPM_BUILD_ROOT%{_bindir}/ooregcomp

# Install configimport tool
install -m 755 solver/%{subver}/%{build_out_path}/bin/configimport.bin \
  $RPM_BUILD_ROOT%{_libdir}/openoffice/program/
cat > $RPM_BUILD_ROOT%{_bindir}/ooconfigimport << EOF
#!/bin/sh
export LD_LIBRARY_PATH=%{_libdir}/openoffice/program:\$LD_LIBRARY_PATH
exec %{_libdir}/openoffice/program/configimport.bin \${1+"\$@"}
EOF
chmod +x $RPM_BUILD_ROOT%{_bindir}/ooconfigimport

# Install language mapper
install -m 755 %{SOURCE6} $RPM_BUILD_ROOT%{_libdir}/openoffice/program/oo_xlate_lang

# We only take care of main OOo applications, that are
# Writer, Calc, Draw, Impress, Math Editor
DESKTOP_FILES="calc draw impress math writer"

# Dipatch GNOME .desktop files
mkdir -p $RPM_BUILD_ROOT%{_datadir}/gnome/apps/OpenOffice.org
(cd $RPM_BUILD_ROOT%{_datadir}/gnome/apps/OpenOffice.org;
  mv $RPM_BUILD_ROOT%{_datadir}/gnome/net/.directory .
  touch .order
  for file in $DESKTOP_FILES; do
    mv $RPM_BUILD_ROOT%{_datadir}/gnome/net/$file.desktop .
    mv $RPM_BUILD_ROOT%{_datadir}/gnome/net/ooo%{subver}$file.desktop .
    echo "ooo%{subver}$file.desktop" >> .order
    echo "$file.desktop" >> .order
  done
)

# Dispatch KDE .desktop files
mkdir -p $RPM_BUILD_ROOT%{_datadir}/applnk/OpenOffice.org
(cd $RPM_BUILD_ROOT%{_datadir}/applnk/OpenOffice.org;
  mv $RPM_BUILD_ROOT%{_datadir}/kde/net/.directory .
  touch .order
  for file in $DESKTOP_FILES; do
    mv $RPM_BUILD_ROOT%{_datadir}/kde/net/$file.desktop .
    echo "$file.desktop" >> .order
  done
)

# Fix references to wrapper programs
find $RPM_BUILD_ROOT%{_datadir} -name "*.desktop" -print | sed -e "s/ /\\\\ /g" | \
  xargs perl -pi -e "s|$RPM_BUILD_ROOT%{_libdir}/openoffice/program/s|%{_bindir}/oo|"

# Dispatch KDE icons
mkdir -p $RPM_BUILD_ROOT%{_iconsdir}
mv $RPM_BUILD_ROOT%{_datadir}/kde/net/share/icons/* $RPM_BUILD_ROOT%{_iconsdir}/

# Dispatch KDE mime associations
mkdir -p $RPM_BUILD_ROOT%{_datadir}/mimelnk/application
mv $RPM_BUILD_ROOT%{_datadir}/kde/net/share/mimelnk/application/*.desktop $RPM_BUILD_ROOT%{_datadir}/mimelnk/application/

# Convert KDE icons (XPM) to MDK menu icons (PNG)
mkdir -p $RPM_BUILD_ROOT%{_miconsdir}
for icon in $RPM_BUILD_ROOT%{_iconsdir}/locolor/16x16/apps/ooo_*.xpm; do
  icon_base=${icon##*/}
  convert $icon $RPM_BUILD_ROOT%{_miconsdir}/${icon_base/xpm/png}
done
mkdir -p $RPM_BUILD_ROOT%{_liconsdir}
for icon in $RPM_BUILD_ROOT%{_iconsdir}/hicolor/48x48/apps/ooo_*.xpm; do
  icon_base=${icon##*/}
  convert $icon $RPM_BUILD_ROOT%{_liconsdir}/${icon_base/xpm/png}
done

# Disable desktop (KDE, GNOME, CDE) integration for user installs
for module in gid_Module_Optional_Gnome gid_Module_Optional_Kde gid_Module_Optional_Cde; do
  perl -pi -e "/^Module $module/ .. /^End/ and s|(Installed.*)=.*|\1= NO;|" \
    $RPM_BUILD_ROOT%{_libdir}/openoffice/program/instdb.ins*
done
perl -pi -e "/^Module gid_Module_Root/ .. /^End/ and s/gid_Procedure_(Kde_Inst|Copy_Readme_File),//g" \
  $RPM_BUILD_ROOT%{_libdir}/openoffice/program/instdb.ins*
perl -ni -e "/^Procedure gid_Procedure_Copy_Readme_File/ .. /^End/ or print" \
  $RPM_BUILD_ROOT%{_libdir}/openoffice/program/instdb.ins*

# Nuke unpackaged files (CDE, MySpell from dedicated package ...)
rm -rf $RPM_BUILD_ROOT%{_datadir}/{cde,gnome/net,kde/net}
rm  -f $RPM_BUILD_ROOT%{_datadir}/dict/ooo/*.{lst,aff,dic,txt}
rm  -f $RPM_BUILD_ROOT%{_iconsdir}/[0-9][0-9][0-9]_*.png
rm -rf $RPM_BUILD_ROOT%{_iconsdir}/document-icons/
rm -rf $RPM_BUILD_ROOT%{_iconsdir}/hicolor/16x16/
rm -rf $RPM_BUILD_ROOT%{_iconsdir}/hicolor/22x22/
rm -rf $RPM_BUILD_ROOT%{_iconsdir}/locolor/22x22/

# FIXME: permissions hack
for ext in bau dat dic sdw stw stc sxw soc sod soe sog soh htm xpm vor sti; do
  find $RPM_BUILD_ROOT -type f -name "*.${ext}" | xargs chmod 644
done

# Generate menus
mkdir -p $RPM_BUILD_ROOT%{_menudir}

GenerateMenu() {
[ -f "$RPM_BUILD_ROOT%{_menudir}/%{name}" ] || touch $RPM_BUILD_ROOT%{_menudir}/%{name}
mimetypes_item=
[ "$6" != "" ] && mimetypes_item="mimetypes=\"$6\""
cat >> $RPM_BUILD_ROOT%{_menudir}/%{name} << EOF
?package(%{name}): needs=x11 section="$2" icon="$3" title="$4" longtitle="$5" command="oo$1" \
$mimetypes_item kde_opt="InitialPreference=100"
EOF
}

GenerateMenu calc \
  "Office/Spreadsheets" \
  "ooo_calc.png" \
  "OpenOffice.org Calc" \
  "OpenOffice.org Spreadsheet" \
  "application/vnd.sun.xml.calc,application/vnd.stardivision.calc,application/vnd.stardivision.chart,application/msexcel,application/vnd.ms-excel"

GenerateMenu draw \
  "Office/Drawing" \
  "ooo_draw.png" \
  "OpenOffice.org Draw" \
  "OpenOffice.org Drawing" \
  "application/vnd.sun.xml.draw,application/vnd.stardivision.draw"

GenerateMenu impress \
  "Office/Presentations" \
  "ooo_impress.png" \
  "OpenOffice.org Impress" \
  "OpenOffice.org Presentation" \
  "application/vnd.sun.xml.impress,application/vnd.stardivision.impress,application/mspowerpoint"

GenerateMenu writer \
  "Office/Wordprocessors" \
  "ooo_writer.png" \
  "OpenOffice.org Writer" \
  "OpenOffice.org Word Processing Component" \
  "application/vnd.sun.xml.writer,application/vnd.stardivision.writer,application/msword,application/vnd.ms-word,application/x-doc,text/rtf"

GenerateMenu math \
  "Office/Wordprocessors" \
  "ooo_math.png" \
  "OpenOffice.org Math" \
  "OpenOffice.org Formula Editor" \
  "application/vnd.stardivision.math,application/vnd.sun.xml.writer.math"

# Don't provide nor require Mozilla libraries
mozlibs_patt=
for lib in `unzip -l solver/%{subver}/%{build_out_path}/bin/mozruntime.zip | perl -ne '/[0-9]+.+(lib[a-z0-9]*\.so)/ and print "$1 "'`; do
  [[ -n "$mozlibs_patt" ]] && mozlibs_patt="$mozlibs_patt\|"
  mozlibs_patt="$mozlibs_patt$lib"
done

ooolibs_patt=
for lib in `find $RPM_BUILD_ROOT%{_libdir}/openoffice/program -name "*.so*"`; do
  [[ -n "$ooolibs_patt" ]] && ooolibs_patt="$ooolibs_patt\|"
  ooolibs_patt="$ooolibs_patt${lib##*/}"
done

# Don't provide nor require JDK-built libraries
ooolibs_patt="$ooolibs_patt\|libjawt.so"

alllibs_patt="$ooolibs_patt"
[[ -n "$mozlibs_patt" ]] && alllibs_patt="$alllibs_patt\|$mozlibs_patt"
provreq_filter="| grep -v \"\($alllibs_patt\)\""

for i in provides requires; do
  [[ "$i" = "requires" ]] && args="%{buildroot} %{_target_cpu}"
  cat > find_$i.sh <<EOF
#!/bin/sh
%{_prefix}/lib/rpm/find-$i $args $provreq_filter || :
EOF
  chmod +x find_$i.sh
done

%post
%update_menus

%postun
%clean_menus

%clean
#rm -rf $RPM_BUILD_ROOT

%files -f filelist
%defattr(-,root,root)
%doc readlicense/source/license/unx/LICENSE
%doc licenses/README.gpc licenses/COPYING licenses/COPYING.LIB
#
%{_bindir}/ooregcomp
%{_bindir}/ooconfigimport
%{_libdir}/openoffice/program/regcomp
%{_libdir}/openoffice/program/configimport.bin
%{_libdir}/openoffice/program/oo_xlate_lang
#
%{_bindir}/ooffice
%{_bindir}/oocalc
%{_bindir}/oodraw
%{_bindir}/ooimpress
%{_bindir}/oomath
%{_bindir}/oowriter
#
%dir %{_sysconfdir}/openoffice/
%config %{_sysconfdir}/openoffice/autoresponse.conf
%config %{_sysconfdir}/openoffice/openoffice.conf
# Menu entry and icons
%{_menudir}/%{name}
%{_iconsdir}/ooo_*.png
%{_miconsdir}/ooo_*.png
%{_liconsdir}/ooo_*.png
# GNOME Integration (menus)
%dir %{_datadir}/gnome/apps/
%dir %{_datadir}/gnome/apps/OpenOffice.org/
%{_datadir}/gnome/apps/OpenOffice.org/.directory
%{_datadir}/gnome/apps/OpenOffice.org/.order
%{_datadir}/gnome/apps/OpenOffice.org/calc.desktop
%{_datadir}/gnome/apps/OpenOffice.org/draw.desktop
%{_datadir}/gnome/apps/OpenOffice.org/impress.desktop
%{_datadir}/gnome/apps/OpenOffice.org/math.desktop
%{_datadir}/gnome/apps/OpenOffice.org/writer.desktop
%{_datadir}/gnome/apps/OpenOffice.org/ooo%{subver}calc.desktop
%{_datadir}/gnome/apps/OpenOffice.org/ooo%{subver}draw.desktop
%{_datadir}/gnome/apps/OpenOffice.org/ooo%{subver}impress.desktop
%{_datadir}/gnome/apps/OpenOffice.org/ooo%{subver}math.desktop
%{_datadir}/gnome/apps/OpenOffice.org/ooo%{subver}writer.desktop
# KDE Integration (menus)
%dir %{_datadir}/applnk/
%dir %{_datadir}/applnk/OpenOffice.org/
%{_datadir}/applnk/OpenOffice.org/.directory
%{_datadir}/applnk/OpenOffice.org/.order
%{_datadir}/applnk/OpenOffice.org/calc.desktop
%{_datadir}/applnk/OpenOffice.org/draw.desktop
%{_datadir}/applnk/OpenOffice.org/impress.desktop
%{_datadir}/applnk/OpenOffice.org/math.desktop
%{_datadir}/applnk/OpenOffice.org/writer.desktop
# KDE Integration (mime associations)
%dir %{_datadir}/mimelnk/
%dir %{_datadir}/mimelnk/application/
%{_datadir}/mimelnk/application/*.desktop
# KDE Integration (icons)
%dir %{_iconsdir}/locolor/
%dir %{_iconsdir}/locolor/16x16/
%dir %{_iconsdir}/locolor/16x16/apps/
%{_iconsdir}/locolor/16x16/apps/*.xpm
%dir %{_iconsdir}/locolor/32x32/
%dir %{_iconsdir}/locolor/32x32/apps/
%{_iconsdir}/locolor/32x32/apps/*.xpm
%dir %{_iconsdir}/hicolor/
%dir %{_iconsdir}/hicolor/32x32/
%dir %{_iconsdir}/hicolor/32x32/apps/
%{_iconsdir}/hicolor/32x32/apps/*.xpm
%dir %{_iconsdir}/hicolor/48x48/
%dir %{_iconsdir}/hicolor/48x48/apps/
%{_iconsdir}/hicolor/48x48/apps/*.xpm
# MySpell (dictionaries + hyphenation) stuff
%dir %{_datadir}/dict/ooo
%{_datadir}/dict/ooo/th_en_US.dat
%{_datadir}/dict/ooo/th_en_US.idx

%files libs -f filelist.libs
%defattr(-,root,root)
%dir %{_libdir}/openoffice
%dir %{_libdir}/openoffice/program

# Sub language packages
%{expand:%(/bin/sh %{SOURCE13} FILES HELP %{helplangs1} %{SOURCE6})}
%{expand:%(/bin/sh %{SOURCE13} FILES HELP %{helplangs2} %{SOURCE6})}
%{expand:%(/bin/sh %{SOURCE13} FILES L10N %{languages1} %{SOURCE6})}
%{expand:%(/bin/sh %{SOURCE13} FILES L10N %{languages2} %{SOURCE6})}
%{expand:%(/bin/sh %{SOURCE13} FILES L10N %{languages3} %{SOURCE6})}

%changelog
* Wed Mar 31 2004 Alex Wan <alexwan@icare.com.hk> 1.1-11mdk.Firefly
- Added patches from Firefly to enhance the output of CJK fonts.

* Mon Mar 01 2004 Giuseppe Ghib <ghibo@mandrakesoft.com> 1.1-11mdk
- Added %%{epoch} openoffice-gen-langpack.sh Requires.

* Thu Feb 25 2004 Giuseppe Ghib <ghibo@mandrakesoft.com> 1.1-10mdk
- Don't use %%{epoch} for l10n Requires.

* Tue Feb 23 2004 Giuseppe Ghib <ghibo@mandrakesoft.com> 1.1-9mdk
- Added %%{epoch} to Requires.

* Mon Feb 09 2004 Giuseppe Ghib <ghibo@mandrakesoft.com> 1.1-8mdk
- Added "eu" => "ES" to the country exception list in the
  openoffice-wrapper.pl for the Basque.
- Fixed openoffice-gen-langpack.sh so to avoid entries
  'Provides: OpenOpenOffice.org-l10n-zh-TW' in other l10n packs.
- Moved section of "OpenOffice.org Draw" to Office/Graphs (Laurent).

* Sat Feb 07 2004 Giuseppe Ghib <ghibo@mandrakesoft.com> 1.1-7mdk
- Rebuilt Patch1016.
- Added Patch1018 (fixes for Excel5 & 95 filters).
- Added Patch1019 (fixes ISSUE #15909)
- Added Patch1020 for allow building under kernel 2.6.
- Added Patch1021 for adding a zoom combobox (fixes bug #7088).
- Updated basque Patch1010 (removed translations for setup).

* Sat Feb 07 2004 Giuseppe Ghib <ghibo@mandrakesoft.com> 1.1-6mdk
- Added missed help*.css to the dutch help package (Source113).
- Added basque set (Source20, Source114, Patch1010, Patch1011),
  from dooteo <dooteo@zundan.com>.
- Added Patch1012 for Issue #18588 (officecfg and extracting schema).
- Added Patch1013 (removes gtk from crashrep).
- Added Patch1014 (fixes incorrect Input field newlines code in saved MS Word documents).
- Added Patch1015 (fixes not translatable string in Tools/Options/External applications).
- Added Patch1016 (fixes for Word6 & 95 filters).
- Added Patch1017 (disable default OpenGL 3D acceleration)

* Wed Feb 04 2004 Giuseppe Ghib <ghibo@mandrakesoft.com> 1.1-5mdk
- Modified openoffice-wrapper.pl and openoffice-gen-langpack.sh so
  that "Bitstream Vera Sans" will be used for UI only for ISO-Latin1 
  languages (fix bug #6021).
- Added finnish help package.
- Added dutch help package (Source113).
- Modified %%init_xdisplay macro to start from DISPLAY :2
- Increased sleep time in %%init_xdisplay macro from 2/10s to 4/15s.
- Compile using LD_ASSUME_KERNEL=2.4.1, otherwise java goes in
  exception under glibc >= 2.3.3-8mdk...

* Sat Jan 31 2004 Giuseppe Ghib <ghibo@mandrakesoft.com> 1.1-4mdk
- Added patch to openoffice-wrapper.pl to allow execution of code
  in /etc/openoffice/customconfig (JMDault).

* Wed Jan 07 2004 Giuseppe Ghib <ghibo@mandrakesoft.com> 1.1-3mdk
- Default saving format to NATIVE and not to MS (requested by Jacques Le Marois).
- Added Patch1000, to get OOo compiling with freetype2 2.1.7.

* Thu Oct 23 2003 Giuseppe Ghib <ghibo@mandrakesoft.com> 1.1-2mdk
- Added Patch999 with some of the CWS vcl7pp1r2 patches (for fixing
  bug for IZ #16573, #19841).

* Wed Oct 22 2003 Giuseppe Ghib <ghibo@mandrakesoft.com> 1.1-1mdk
- Release 1.1mdk.
- Added --with jdk option.
- Rebuilt Patch37 (mdkfonts).

* Mon Sep 15 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.1-0.rc4.2mdk
- Really enable fixed Patch102 (bmp32)
- Patch40: Make font substitution algorithm match documentation (IZ #19591)
- Updates to wrapper script:
  - Really use localized instdb.ins files for installation
  - Reactivate font substitutions for now otherwise Japanese & Korean
    help content is broken. This concerns (Andale Sans UI, Albany, Arial)

* Fri Sep 12 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.1-0.rc4.1mdk
- 1.1rc4
- Nuke mutation of instdb.ins since it confuses updates and is now useless
- Refine selection of MySpell packages to install along with -l10n- packages
- Add Slovak help files, update Czech files to 1.1rc4 from OOo-cs project
- Make extra psprint filters work again
- Make sure we only handle 32-bit bmp images and don't default to that
  format. Otherwise, we need to always copy/transform things around
  and this slows UI down terribly
- Make doc defaults configurable through DOC_DEFAULTS variable in
  /etc/openoffice/openoffice.conf or ~/.oofficerc. i.e. set it to "MS"
  (default) for .doc formats or any other (e.g. "NATIVE") for OOo
- Revert to use Nimbus Roman No9L as default font for text since Vera
  Serif doesn't have any oblique face yet
- Add more "Word count" translations (thanks Pablo, Giuseppe)
- Patch11: Don't install python-2.2 stuff for now
- Patch31: Update to make $HOME/Documents default only if it exists
- Merge in more Ximian patches:
  - Patch101: Conditionalize use of MS defaults (default)
  - Patch106: Startup notification fixes (IZ #18970)
- Updates to wrapper script:
  - Try hard to update user install base even through different language
  - Always default to one installed language set, preferably matching
    the current locale

* Mon Sep  1 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.1-0.rc3.2mdk
- Merge in some Ximian patches:
  - Patch100: Add word count feature under Tools/Hyphenation item
  - Patch101: Default to .doc for text documents
  - Patch102: Add support for 32-bit bitmaps and icons
  - Patch103: Correct typo in Options->HTML compatibility for sv (IZ #16437)
  - Patch104: Export 'no color' background to doc (IZ #18671)
  - Patch105: Don't continually beep annoyingly (IZ #18440)

* Fri Aug 22 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.1-0.rc3.1mdk
- 1.1rc3
- Default compiler is now any gcc >= 3.2 (thusly MDK >= 9.0)
- Use built-in Mozilla address book libraries
- Add localized UI strings for: Portugus do Brasil
- Temporarily remove localized help files for: Russian, Finnish, Czech
- Try to fix encodings of localized menu File/New entries
- Don't install (unlocalized) readme & license files to user dir
- Patch11: Don't build crashdump reporter
- Patch30: Fix broken inclusions of STL headers
- Patch31: Make $HOME/Documents the work directory
- Patch32: Look for additional templates in <ooo>share/templates/extra/
- Patch33: Don't export crazy symbols from svunzip (IZ #17841)
- Patch34: Remove unneeded sched_yield calls (IZ #9277)
- Patch35: MySpell dictionaries are shared in /usr/share/dict/ooo
- Patch36: Enable automatic spellchecking by default
- Patch37: Use better default fonts available in the distribution
- Patch38: Fix crash in ExtendedFontStruct::HasUnicodeChar()
- Patch39: Disable KDE screensaver during presentations
- Patch405: Use system Vera fonts
- Deprecate UI_FONT & FONT_SCALING in openoffice.conf and don't handle
  them any longer (should be handled automatically with new font
  substitution facilities)
- Updates to wrapper script:
  - Handle CTL layouts (Arabic)
  - SAL_FONTPATH_USER is gone, SAL_FONTPATH should still work though
  - Only merge in new configuration data if we are switching locales
  - Attempt to update an existing installation and let OOo merge user
    *.xml files to new *xcu
  - Drop XML::Twig parser as configuration files format is now
    overkill to handle. Better user configimport tool to merge in new
    config bits

* Mon May 19 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.1-0.beta2.1mdk
- 1.1 beta 2

* Tue Apr 29 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.3-2mdk
- Patch0: Fix vcl printer code that may have caused a crash (1.0.3.1)
- Patch29: Update to add a generic PostScript distillable output (Giuseppe)
- Patch50: Reintroduce soffice.sh fix, it got mis-integrated upstream
- Patch53: Install OOo Impress templates
- Introduce UI_LANG variable to /etc/openoffice/openoffice.conf or
  ~/.oofficerc in order to force a specific language for the user or
  system wide. This helps if you have a mismatch between the system
  locale (which the ooffice script uses) and what you actually have
  installed as OOo-l10n-* package

* Wed Apr  9 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.3-1mdk
- BuildRequires: xpm-devel for nas library build
- Rework Patch400 (system-db) to fit libdb4.0 and lib64 on MDK >= 9.2
- Use zh_{CN,TW} instead of zh-{CN,TW} in package names so that
  rpmsrate can auto-expands the filelist
- Patch599: Colateral, induced by previous 64-bit patches on 32-bit arches
- Patch49: Enable user to set priorities among embedded bitmaps,
  auto-hinting and anti-aliasing. Backport from OOo 1.1. Variables are
  SAL_EMBEDDED_BITMAP_PRIORITY, SAL_ANTIALIASED_TEXT_PRIORITY,
  SAL_AUTOHINTING_PRIORITY to be set with numerical values. Defaults
  are 2/1/1, respectively. i.e. preferring embedded bitmaps first.
  <http://gsl.openoffice.org/servlets/ReadMsg?msgId=490464&listName=features>

* Mon Mar 10 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.2-7mdk
- Patch1: Ignore Xerrors from XSetInputFocus() for now (IZ #10779)
- Patch25: Update to handle Kerkis as default font for Greek. Also add
  better/available candidates for Asian locales
- Patch44: Update to get correct condition for PPDKey::eraseValue()
- Patch45: Update to immediately cache the PPD file to user's psprint
- Patch46: Handle SAL_DEBUGGER in soffice script
- Patch47: Make soffice script handle chdir to dirs denoted relatively
- Patch48: Always enable antialiasing if the font is antialias capable
- Patch109: Update to really enable Slovak localization
- Patch405: Update to match current CVS sources
- Fix localized help/err.html mutation, only special case for Finnish
- Updates to wrapper script:
  - Handle CJK locales configuration better
  - Handle new --debug(ger) and --help options
  - Handle language -> font mappings better
  - Use KerkisSans as UI font for Greek
  - Also substitute Albany and Arial UI fonts, if not available
  - Make LC_CTYPE an alternative to set UI localization, not LC_MESSAGES
  - On user installation, make sure that ~/.mime.types doesn't contain
    any duplicates. i.e. don't let it grow constantly

* Tue Mar  4 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.2-6mdk
- Remove ~/.openoffice/user/work symlink if target is user's HOME dir
- Requires: OpenOffice.org %{version} for -help and -l10n packages
- Patch44: Keep ordering of original PPD file values in Printer Properties
- Patch45: Use CUPS to grab the corresponding PPD file

* Mon Mar  3 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.2-5mdk
- Patch43: Use light hinting for freetype2 >= 2.1.3-3mdk (RH)
- Patch0: Take care of selected directory in Save dialogs (IZ #8928)
- Main package now owns help/en/err.html file to suggest a help
  package to install if it is not localized yet
- Default font scaling to 100 if FONT_SCALING is not set correctly

* Fri Feb 28 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.2-4mdk
- Force OOo Draw styles in English for main package
- Patch42: Use MDK colors
- Patch41: Fix crash with a PPD file that does not specify the DPI
  resolution in the string version of the "Resolution" option. (IZ #11616)
- Updates to Source5 (wrapper-script):
  - Handle Arabic UI fonts and language
  - For language selection, prefer LC_ALL which has higher priority
  - If FONT_SCALING variable is not set, don't change user's config either

* Fri Feb 21 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.2-3mdk
- Add localized UI strings for: Arab, Slovak
- Add localized help files for: Russian, Finnish, Czech, Japanese,
  Korean, Chinese (simplified and traditional)
- Patch39: Hack up scpzip so that it doesn't duplicate everything 17
  or more times than necessary (RH). Also make sure to handle
  localized help files.

* Wed Jan 29 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.2-2mdk
- Remove (obsolete) specfile nonsense
- Handle/skip -g in fake javac wrapper
- Patch37: Don't use obsolete CLK_TCK macros in debug=true mode
- Patch38: Fix rsc code in debug=true mode
- Updates to Source5 (wrapper-script):
  - Don't nuke away other OpenOffice.org installations info from sversionrc

* Tue Jan 28 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.2-1mdk
- Update to 1.0.2 final
- Patch16 (no-stlport): Remove bits merged upstream
- Add yet another fix to errno (Patch32)
- Patch406: Use system zlib + master truanderie
- Patch407: Directly link against system Xrender library
- Patch408: Fix conflict with system zlib brought in by recent
  freetype2 packages

* Wed Jan 15 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.2-0.1mdk
- Update to OOO_STABLE_1 2002/01/13
- Mostly get rid of tcsh use during main build
- Stop symlink'ing <ooo_home>/user/work, since user Common.xml is now
  correctly generated with user Work dir being his home

* Thu Jan  9 2003 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.1-10mdk
- Let extra templates be found by OOo in $(insturl)/share/template/extra
- Enforce dependency on perl-XML-Twig with a version known to work
- Add Requires: libsane1, Xaw3d
- Really make it ExclusiveArch: %{ix86} ppc
- Patch34: Enable dmake clean (Debian patch)
- Patch35: Enable RTTI & other optimizations on PPC (CVS, 1.0.2)
- Patch36: Fix bridges on PPC with gcc3 (CVS, 1.0.2)
- Patch37: Add Finnish localizatin, use "35" as prefix code
- Patch38: Fix references to errno
- Patch51: Fix build with recent Mozilla LDAP API changes
- Patch404: Correctly load system libsane
- Patch405: Fix build with newer FreeType 2.1.X libraries (Red Hat)
- Source21: Fix OpenSymbol font encoding table (RH #69996)

* Wed Sep 11 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.1-9mdk
- Patch33: Stop forwarding to stderr things we don't actually care of
  while testing for spooler availability. No longer Requires: lpddaemon
- Patch32: Add PDF converters both suitable for either view or press
  purposes as printer option to global psprint.conf (Giuseppe)
- Update wrapper script to reflect that change (auto page size selection)
- Make it run on "msec level 4" systems:
  - Patch30: Get command line arguments the regular way and not from
    /proc/<pid>/cmdline
  - Patch31: Stop trying to read directories up to the root to
    determine the full path of a file. Instead, use a derivative from
    realpath()

* Fri Sep  6 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.1-8mdk
- Fix calling of create-instdb script for future releases
- Requires the right set of font packages in -l10n- packages
- Make oo* wrapper scripts actually a link to real ooffice wrapper
- Updates to Source5 (wrapper-script):
  - Handle switch to zh-{CN,TW}
  - Handle more and correct language => UI font mappings
  - No longer expand fontpath from chkfontpath since OOo does exactly
    the same since, well, probably OOo 1.0.0.
  - Workaround MDK::Common::update_gnomekderc bug where a new
    PPD_PageSize entry was not added on a new line, if there was no
    previous user psprint.conf available and the last section didn't
    terminate with a newline character
  - Handle oo<component> --lang <lang> to actually start <component>
    in selected <lang>

* Tue Sep  3 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.1-7mdk
- Don't provide nor require any libraries from OOo at all.
- Patch29: Make setup look for a "localized" instdb.ins script
  specified by a new -LANG: option. Hackaround until I find a way to
  do that in scp or autoresponse files.
- Source20: Add script to generate localized instdb.ins files from
  setup.ins. Aka let the right files to be installed for a user
  installation in his language.
- Updates to Source5 (wrapper-script):
  - Add more mappings to Language -> Country table
  - Add --lang option to override default from locale
  - Use "localized" instdb.ins file as mentioned above, for a user
    installation

* Mon Sep  2 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.1-6mdk
- Add support for Mozilla addressbook and LDAP sources
- Fix permissions on thesaurus files
- OpenOffice.org-help-* packages now depends on locale-* as an DrakX hack
- Don't forcibly Requires: OpenOffice.org-l10n-en as it works with the
  right language package you want alone.
- Don't forcibly Requires: OpenOffice.org-l10n-* in -help- packages as
  Help can work without. e.g. Having English help with only Russian UI
  localization installed.
- Make transmute-help-errfile.pl hint about the help package to
  install in <b> instead of ugly <tt> with some fonts.
- Merge with Red Hat releases:
  - Start Xvfb in %%{init_xdisplay}
  - Set default document fonts to Nimbus Roman No9 L, Luxi Sans and
    Luxi Mono instead of the non existant Thorndale
  - Make sure New/Wizard menus and OfficeObjects are localized

* Wed Aug 28 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.1-5mdk
- Patch19: Make WM_CLASS property for ICCCM compliant, aka don't have
  "VCLSalFrame" showing up in taskbar of KDE 3.0 (IZ #4830, CVS HEAD)
- Add Catalan localization:
  - Source17: Catalan strings (Jesus Corrius, Jordi Mas)
  - Patch25: Add Catalan localization as POSTAPP2TARGET
  - Patch26: Various fixes/additions for Catalan support
  - Patch27: Catalan is only implemented as ca-ES (Jesus Corrius)
- Source18: Add global ooffice configation file
- Updates to Source5 (wrapper-script):
  - Define user work directory to $HOME
  - Use XML::Twig to parse and generate XML code. That's cleaner, more
    flexible but surely not the fastest way
  - Handle global ooffice config in /etc/openoffice/openoffice.conf
    and users' in ~/.oofficerc
  - Automatically define font to use for user interface based on the
    current locale. Overridden with UI_FONT config variable
  - Possibly set UI font scaling based on current display resolution
    (Jakub Jelinek, Red Hat). However, as this is not enabled by
    default, you need to properly set FONT_SCALING first
  - Define paper size to use based on the current locale, and provided
    you don't have any printer configured yet. Otherwise, printerdrake
    will still generate the right default values.

* Tue Aug 27 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.1-4mdk
- Fix BuildRequires: for xmlparse (Ian C. Sison)
- Patch17: Add POSTAPP<N>TARGET to be executed after APP targets are built
- Patch18: Add Czech localization as POSTAPP1TARGET
- Updates to Source5 (wrapper-script):
  - Correctly set default language for documents. Aka, transmute user
    Linguistic.xml, or create it if it doesn't exist yet
- Merge with Red Hat releases (5 new patches):
  - Patch{20,21,24,26}: Add Czech localization
  - Patch22: Fix language list for some languages
  - Patch{40,41,42}: Add some patches from <http://oo-cs.sourceforge.net/>

* Mon Aug 26 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.1-3mdk
- Move localized help files to new OpenOffice.org-help-* subpackages
- Add localized help files for Spanish, Italian, Swedish, German
- Make help/<lang> a real directory, possibly empty
- Patch16: Check that we have the necessary help files. The rationale
  is if help/<lang>/err.html exists then, we have localized help data,
  possibly not installed. Otherwise, we won't have localized help and
  we try to fallback to English

* Fri Aug 23 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.1-2mdk
- Add C/J/K UI localization. Likewise for Danish, Greek, Turkish
- bzip2 helpcontent even if bigger than tgz. We don't want binaries in CVS
- Don't handle upgrade, from 1.0-Xmdk with links from help/$ISOCODE to
  help/en, to 1.0.1-Ymdk where we sometimes have a real directory for
  help/$ISOCODE. Language packages PreReq: OpenOffice.org = %%{version}
  UPDATE: That still doesn't work. As a workaround, you can update
  with l10n-en first. Then, install proper l10n-*. That way works.
- Updates to Source13 (gen-langpack):
  - Fix %%description, don't redefine variables correctly set
  - Map zh-{CN|TW} to zh. Aka. correctly Requires: the right locales-* package
- Updates to Source5 (wrapper-script):
  - Fix silly typo introduced post-tests in versions file
    regeneration. If you installed 1.0.1-1mdk, you'd have better luck
    to rm -rf ~/.openoffice prior to rerunning "ooffice".
  - Add current version tag if it does not exist already. This occurs
    when you upgrade from 1.0 to 1.0.1 for example.
  - If the user installation exists, then the versions file is likely
    to exist too. Otherwise, if we (or the user) nuked it away, then
    simply regenerate it.

* Thu Aug 22 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0.1-1mdk
- OpenOffice.org 1.0.1
- Requires: libunixODBC2
- Requires: virtual package myspell-dictionary
- Add fully versioned Requires: libgcc
- BuildRequires: gcc3.2 >= 3.2-0.3mdk
- Build with STLport 4.5.3 everywhere
- New "libs" subpackage with OpenOffice.org libraries
- Really make dictionaries stuff go to %{_datadir}/dict/ooo/
- Add localized helpcontent for French
- Update Source7 (dpack-lang) to extract help files in some cases
- Merge Source6 (xlate-lang) with Debian 1.0.1-5
- Automatically regenerate Source6 (xlate-lang) data, add resource names
- Remove support for inexistant Finnish localisation
- Rewrite Source5 (wrapper-script) in full perl. Hopefully, it's now
  more flexible and readable. Also add or fixes the following:
  - Fix paths returned by chkconfig
  - Remove older dictionary symlinks that are now global
  - Don't remove user dictionaries however
  - Add ability to change UI localisation dynamically (merge ideas
    from both Debian and Red Hat people). You have to make sure the
    correct OpenOffice.org-l10-* package is installed however
- Source1[01]: Add additional templates and gallery files from upstream
- Source13: Automatically generate language subpackages
- Patch12: Add parallel build.pl from CVS HEAD (tune later)
- Patch14: Fix set_new_handler() exception specifications, if necessary
- Patch100: Add support for gcc3.2 to UNO
- Patch101: Any gcc >= 3.1.1 has versioned libstdc++ headers location
- Patch303: Add support for any gcc >= 3.1.1 includes dir in STLport
- Patch304: Add EXTRA_CXXFLAGS for RPM_OPT_FLAGS, some fixlets for STLport
- Patch400: Use system db3 library, but only on MDK 9.0 builds
- Patch403: Load libodbc library, not linker name library (from -devel package)
- Make sure we have a correct tcsh when building on MDK 9.0
- Nuke dependency on Sun JDK, use gcj instead (Jakub Jelinek)
- Use perl regexp for postprocess in xmlparse replacement (sed loops otherwise)
- Merge with Red Hat releases (12 new patches):
  - Don't uglify HTML for iso 8859-2
  - Don't catch SIGSEGV and SIGILL
  - Don't die if we cannot write registry cache
  - Don't build internal STLport when using gcc3
  - Make sure we don't do -I/usr/include, it's evil
  - Add support for compiler variables to configure script
  - Add support for new compiler variables to makefiles (COMPCC, COMPCXX)
  - Add debug for setup so that the /tmp directory is not removed
  - Fix broken inline assembly
  - Fix broken makefiles
  - Nuke STLport badlink
  - Use system getopt()

* Wed May 29 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0-5mdk
- Add Russian localization
- Build with gcc3.1 for all supported arches in MDK 9.0
- Remove Patch3, Patch4, Patch13, Patch19, Patch22
- Merge Patch22 (gcc31-misc) and Patch13 (gcc3-linker) in Patch5 (mdkconfig)
- Patch3: Add support for gcc3 on PPC
- Patch4: Workaround gcc3.1 bugs on PPC
- Patch19: Don't copy nor install at setup time standard libraries
- Patch22: Improve font server discovery (OOo 1.0-branch)
- Patch23: Updates to lingucomponent from OOo 1.0-branch:
  - Register own hypenation dictionaries (IZ #45555, IZ #4687)
  - Fix segfault under Thesaurus (IZ #4435)
  - Enable shared spellchecking capabilities
- Update Source4 (local autoresponse) to disable Java detection
- Update Source5 (wrapper script):
  - Better detection of setup failure for user installation
  - Remove any reference to en_US dictionaries for now since OOo
    provides shared ones that work
  - Better handling of broken links in the ~/.openoffice/user/worbook/
    directory. Also possibly unregister the previous dictionary

* Wed May 22 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0-4mdk
- Patch22: Misc patches for gcc3.1 (experimental)
- Rebuild with gcc3.1-1mdk in Cooker

* Wed May 15 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0-3mdk
- Default to gcc3.0 in Cooker/x86 for now
- Only build STLport 4.5.3 with gcc-3.0+ builds
- BuildRequires: blackdown-j2sdk = 1.3.1 on PPC (Stew)
- Patch20: cpputools regcomp workaround on PPC (Stew, IZ #3980)
- Patch21: Move OOo Math into the correct GNOME integration module
- Use official OpenOffice.org 1.0 menu icons
- Update and clean %%description to notify language packs available
- Update KDE and GNOME integration
- Update OOo Math document association
- Update Source4 (local autoresponse file) to detect Java Runtime
- Disable desktop (KDE, GNOME, CDE) integration at user's level

* Tue May  7 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0-2mdk
- Build Mozilla Address book on X86. Later for PPC
- BuildRequires: freetype2-devel
- Patch17: Minor fontcache fix (copy weight attribute) from CVS
- Patch18: Build with system FreeType 2 library
- Patch19: Don't install standard libraries (libgcc_s, libstdc++)
- Update Patch8 (no-mozab) to not install mozab and runtime from setup
- Update specfile to remove hackage now done by the above two patches
- Update Patch9 (user-fontpath) to apply to the new oounix/ directory
- Update Source5 (wrapper script):
  - If ~/.openoffice user directory is not detected, remove any
    reference to that directory in ~/.sversionrc, if that file exists
  - Check that user installation succeeded. Exit 1 otherwise

* Fri May  3 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0-1mdk
- OpenOffice.org 1.0
- Epoch: 1 since openoffice is obsoleted
- Remove Patch10 (psprint-euro) since merged upstream
- Patch10: Fix configure script with NULL statement for X check on Darwin
- Update KDE applnk files, icons and MIME associations unpacking
- Update Source5 (wrapper script) to patch new version tag if a
  previous installation of 641-series is found

* Tue Apr 16 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 1.0-0.1mdk
- Update to OpenOffice.org 641d
- Package is now called OpenOffice.org. Full transition for the file
  hierarchy and revamp of "ooffice" wrapper script will happen later
  though. As this ChangeLog is becoming bigger and bigger ;-)
- ExclusiveArch: %%{ix86} ppc
- Update %%description to clarify myspell purposes
- Add northern languages: Swedish, Finnish, Polish
- Revamp compiler selection:
  - Use gcc-2.95.x on Mandrake Linux 8.2/PowerPC
  - Use gcc-3.0.4 on Mandrake Linux 8.2/Intel x86
  - Use gcc-3.1 on Mandrake Linux 9.0/Intel x86 [LATER]
- Split Patch2 into Patch1 (CLK_TCK), Patch[34] (gcc3[01]-libs)
- Remove Patch6 (bison-1.30+) since merged upstream
- Regenerate Patch3 (MDK config) into Patch5
- Regenerate Patch4 (exceptions specifications) into Patch6
- Update Patch6 with more excp-fixes for bridges test programs
- Update Patch8 (no-mozab) to remove dependency on moz module
- Patch11: Add support for gcc-3.1
- Patch12: Add support for gcc-3.1 to STLport-4.5.3
- Patch13: gcc3+ linker should be g++ instead of gcc
- Patch14: Fix main() return values in bridges tests
- Patch15: Workaround _STL to std:: for gcc < 3.0
- Patch16: JDK 1.3 does exist on PPC too
- Fix /net installation under Xvfb in %%install
- Fix instdb.ins to get rid of $RPM_BUILD_ROOT
- Remove workaround for English wordbook in %%install
- Update "ooffice" wrapper script to reflect this change
- Also make sure to remove (possibly update) broken links to dictionaries

* Wed Mar 13 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 6.0.41-6mdk
- BuildRequires: jdk = 1.3.1 exactly
- Disable strict aliasing for all gcc builds. aka. Fix copy-pasting in
  Calc component.

* Wed Mar  6 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 6.0.41-5mdk
- Add mimetypes item to menu entries
- Fix component wrapper scripts
- Fix %%post to get language from LC_MESSAGES environment variable
  instead of /etc/sysconfig/i18n
- Update the ooffice wrapper script to get rid of possible
  /usr/share/fonts/ttf/japanese/ font path that could cause
  OpenOffice.org to crash

* Mon Mar  4 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 6.0.41-4mdk
- Update %%description to note the existence of myspell-* packages
- Fix %%post and enhance instdb.ins mutation
- Source5: Updates to the ooffice wrapper script to support
  registration of dictionary files in the user's installation

* Mon Mar  4 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 6.0.41-3mdk
- Patch9: Fix printing of Euro symbol (Till, Giuseppe)
- Source5: Updates to the ooffice wrapper script:
  - Enhance even more to take the result of chkfontpath into account,
    if installed. Otherwise, default to the old method
  - Remove any entry in ~/.sversionrc if OpenOffice.org was not
    provided from this package
  - Workaround location of English workdbook

* Thu Feb 28 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 6.0.41-2mdk
- Clean rebuild with more languages: Spanish, Dutch, Italian, Portugese
- Add KDE icons and MIME associations
- Patch8: Support extra font paths with the SAL_FONTPATH_USER variable
- Source5: Enhance with extra font paths (TrueType and Type1 fonts)

* Tue Feb 26 2002 Gwenole Beauchesne <gbeauchesne@mandrakesoft.com> 6.0.41-1mdk
- Release 641c
- Support (experimental) auto-selection of language pack
- 5 new sources:
  - Source3: Global autoresponse file for rpm build
  - Source4: Local autoresponse file for user setup
  - Source5: OpenOffice.org wrapper script (setup if necessary)
  - Source6: Misc hashes related to language sets
  - Source7: Unpack language sets
- 8 new patches:
  - Patch0: Add support/fixes for gcc-"2.96"
  - Patch1: Add support/fixes for gcc-3.0.4
  - Patch2: Exception patch for STLport 4.5.3 and gcc3
  - Patch3: MDK config (CFLAGS et al.)
  - Patch4: Fix exception specifications here and there
  - Patch5: Hackery around zipdep
  - Patch6: Hackery for new bison (1.30+)
  - Patch7: Don't build Mozilla Address Book

* Mon Oct 23 2000 Frederic Crozat <fcrozat@mandrakesoft.com> 6.0.5-1mdk
- Initial Release

# end of file
